/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nagios;

import com.googlecode.jsendnsca.core.Level;
import com.googlecode.jsendnsca.core.MessagePayload;
import com.googlecode.jsendnsca.core.NagiosPassiveCheckSender;
import com.googlecode.jsendnsca.core.NagiosSettings;
import java.util.EventObject;
import org.apache.camel.component.nagios.NagiosConfiguration;
import org.apache.camel.management.event.CamelContextStartupFailureEvent;
import org.apache.camel.management.event.CamelContextStopFailureEvent;
import org.apache.camel.management.event.ExchangeFailedEvent;
import org.apache.camel.management.event.ExchangeFailureHandledEvent;
import org.apache.camel.management.event.ExchangeRedeliveryEvent;
import org.apache.camel.management.event.ServiceStartupFailureEvent;
import org.apache.camel.management.event.ServiceStopFailureEvent;
import org.apache.camel.support.EventNotifierSupport;

public class NagiosEventNotifier
extends EventNotifierSupport {
    private NagiosSettings nagiosSettings;
    private NagiosConfiguration configuration;
    private NagiosPassiveCheckSender sender;
    private String serviceName = "Camel";
    private String hostName = "localhost";

    public NagiosEventNotifier() {
    }

    public NagiosEventNotifier(NagiosPassiveCheckSender sender) {
        this.sender = sender;
    }

    public void notify(EventObject eventObject) throws Exception {
        String message = eventObject.toString();
        Level level = this.determineLevel(eventObject);
        MessagePayload payload = new MessagePayload(this.getHostName(), level.ordinal(), this.getServiceName(), message);
        if (this.log.isInfoEnabled()) {
            this.log.info("Sending notification to Nagios: {}", (Object)payload.getMessage());
        }
        this.sender.send(payload);
        this.log.trace("Sending notification done");
    }

    public boolean isEnabled(EventObject eventObject) {
        return true;
    }

    protected Level determineLevel(EventObject eventObject) {
        if (eventObject instanceof ExchangeFailedEvent || eventObject instanceof CamelContextStartupFailureEvent || eventObject instanceof CamelContextStopFailureEvent || eventObject instanceof ServiceStartupFailureEvent || eventObject instanceof ServiceStopFailureEvent) {
            return Level.CRITICAL;
        }
        if (eventObject instanceof ExchangeFailureHandledEvent || eventObject instanceof ExchangeRedeliveryEvent) {
            return Level.WARNING;
        }
        return Level.OK;
    }

    public NagiosConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new NagiosConfiguration();
        }
        return this.configuration;
    }

    public void setConfiguration(NagiosConfiguration configuration) {
        this.configuration = configuration;
    }

    public NagiosSettings getNagiosSettings() {
        return this.nagiosSettings;
    }

    public void setNagiosSettings(NagiosSettings nagiosSettings) {
        this.nagiosSettings = nagiosSettings;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    protected void doStart() throws Exception {
        if (this.nagiosSettings == null) {
            this.nagiosSettings = this.configuration.getNagiosSettings();
        }
        if (this.sender == null) {
            this.sender = new NagiosPassiveCheckSender(this.nagiosSettings);
        }
        this.log.info("Using " + this.configuration);
    }

    protected void doStop() throws Exception {
        this.sender = null;
    }
}

