/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nagios;

import com.googlecode.jsendnsca.core.Encryption;
import com.googlecode.jsendnsca.core.NagiosSettings;
import java.net.URI;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.nagios.NagiosEncryptionMethod;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;

@UriParams
public class NagiosConfiguration
implements Cloneable {
    private transient NagiosSettings nagiosSettings;
    @UriPath
    @Metadata(required="true")
    private String host;
    @UriPath
    @Metadata(required="true")
    private int port;
    @UriParam(defaultValue="5000")
    private int connectionTimeout = 5000;
    @UriParam(defaultValue="5000")
    private int timeout = 5000;
    @UriParam(label="security", secret=true)
    private String password;
    @UriParam(label="security")
    private NagiosEncryptionMethod encryptionMethod;

    public NagiosConfiguration copy() {
        try {
            NagiosConfiguration copy = (NagiosConfiguration)this.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public void configure(URI uri) {
        int port;
        String value = uri.getHost();
        if (value != null) {
            this.setHost(value);
        }
        if ((port = uri.getPort()) > 0) {
            this.setPort(port);
        }
    }

    public synchronized NagiosSettings getNagiosSettings() {
        if (this.nagiosSettings == null) {
            ObjectHelper.notEmpty((String)this.host, (String)"host", (Object)this);
            if (this.port <= 0) {
                throw new IllegalArgumentException("Port must be a positive number on " + this);
            }
            this.nagiosSettings = new NagiosSettings();
            this.nagiosSettings.setConnectTimeout(this.getConnectionTimeout());
            this.nagiosSettings.setTimeout(this.getTimeout());
            this.nagiosSettings.setNagiosHost(this.getHost());
            this.nagiosSettings.setPort(this.getPort());
            this.nagiosSettings.setPassword(this.getPassword());
            if (this.encryptionMethod != null) {
                if (NagiosEncryptionMethod.No == this.encryptionMethod) {
                    this.nagiosSettings.setEncryptionMethod(Encryption.NO_ENCRYPTION);
                } else if (NagiosEncryptionMethod.Xor == this.encryptionMethod) {
                    this.nagiosSettings.setEncryptionMethod(Encryption.XOR_ENCRYPTION);
                } else if (NagiosEncryptionMethod.TripleDes == this.encryptionMethod) {
                    this.nagiosSettings.setEncryptionMethod(Encryption.TRIPLE_DES_ENCRYPTION);
                } else {
                    throw new IllegalArgumentException("Unknown encryption method: " + (Object)((Object)this.encryptionMethod));
                }
            }
        }
        return this.nagiosSettings;
    }

    public void setNagiosSettings(NagiosSettings nagiosSettings) {
        this.nagiosSettings = nagiosSettings;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public NagiosEncryptionMethod getEncryptionMethod() {
        return this.encryptionMethod;
    }

    public void setEncryptionMethod(NagiosEncryptionMethod encryptionMethod) {
        this.encryptionMethod = encryptionMethod;
    }

    public String toString() {
        return "NagiosConfiguration[host=" + this.host + ":" + this.port + ", connectionTimeout=" + this.connectionTimeout + ", timeout=" + this.timeout + ", encryptionMethod=" + (Object)((Object)this.encryptionMethod) + "]";
    }
}

