/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.io.InputStream;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.hazelcast.HazelcastCommand;
import org.apache.camel.component.hazelcast.HazelcastDefaultEndpoint;
import org.apache.camel.component.hazelcast.atomicnumber.HazelcastAtomicnumberEndpoint;
import org.apache.camel.component.hazelcast.instance.HazelcastInstanceEndpoint;
import org.apache.camel.component.hazelcast.list.HazelcastListEndpoint;
import org.apache.camel.component.hazelcast.map.HazelcastMapEndpoint;
import org.apache.camel.component.hazelcast.multimap.HazelcastMultimapEndpoint;
import org.apache.camel.component.hazelcast.queue.HazelcastQueueEndpoint;
import org.apache.camel.component.hazelcast.replicatedmap.HazelcastReplicatedmapEndpoint;
import org.apache.camel.component.hazelcast.ringbuffer.HazelcastRingbufferEndpoint;
import org.apache.camel.component.hazelcast.seda.HazelcastSedaConfiguration;
import org.apache.camel.component.hazelcast.seda.HazelcastSedaEndpoint;
import org.apache.camel.component.hazelcast.set.HazelcastSetEndpoint;
import org.apache.camel.component.hazelcast.topic.HazelcastTopicConfiguration;
import org.apache.camel.component.hazelcast.topic.HazelcastTopicEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ResourceHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastComponent
extends DefaultComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(HazelcastComponent.class);
    private final Set<HazelcastInstance> customHazelcastInstances = new LinkedHashSet<HazelcastInstance>();
    @Metadata(label="advanced")
    private HazelcastInstance hazelcastInstance;
    @Metadata(label="advanced", defaultValue="node")
    private String hazelcastMode = "node";

    public HazelcastComponent() {
    }

    public HazelcastComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Object config;
        HazelcastInstance hzInstance = ObjectHelper.equal((Object)this.hazelcastMode, (Object)"node") ? this.getOrCreateHzInstance(this.getCamelContext(), parameters) : this.getOrCreateHzClientInstance(this.getCamelContext(), parameters);
        String defaultOperation = (String)this.getAndRemoveOrResolveReferenceParameter(parameters, "operation", String.class);
        if (defaultOperation == null) {
            defaultOperation = (String)this.getAndRemoveOrResolveReferenceParameter(parameters, "defaultOperation", String.class);
        }
        HazelcastDefaultEndpoint endpoint = null;
        if (remaining.startsWith("map:")) {
            remaining = StringHelper.removeStartingCharacters((String)remaining.substring("map:".length()), (char)'/');
            endpoint = new HazelcastMapEndpoint(hzInstance, uri, remaining, this);
            endpoint.setCommand(HazelcastCommand.map);
        }
        if (remaining.startsWith("multimap:")) {
            remaining = StringHelper.removeStartingCharacters((String)remaining.substring("multimap:".length()), (char)'/');
            endpoint = new HazelcastMultimapEndpoint(hzInstance, uri, remaining, this);
            endpoint.setCommand(HazelcastCommand.multimap);
        }
        if (remaining.startsWith("atomicvalue:")) {
            remaining = StringHelper.removeStartingCharacters((String)remaining.substring("atomicvalue:".length()), (char)'/');
            endpoint = new HazelcastAtomicnumberEndpoint(hzInstance, uri, (Component)this, remaining);
            endpoint.setCommand(HazelcastCommand.atomicvalue);
        }
        if (remaining.startsWith("instance:")) {
            remaining = StringHelper.removeStartingCharacters((String)remaining.substring("instance:".length()), (char)'/');
            endpoint = new HazelcastInstanceEndpoint(hzInstance, uri, this);
            endpoint.setCommand(HazelcastCommand.instance);
        }
        if (remaining.startsWith("queue:")) {
            remaining = StringHelper.removeStartingCharacters((String)remaining.substring("queue:".length()), (char)'/');
            endpoint = new HazelcastQueueEndpoint(hzInstance, uri, (Component)this, remaining);
            endpoint.setCommand(HazelcastCommand.queue);
        }
        if (remaining.startsWith("topic:")) {
            remaining = StringHelper.removeStartingCharacters((String)remaining.substring("topic:".length()), (char)'/');
            config = new HazelcastTopicConfiguration();
            this.setProperties(config, parameters);
            endpoint = new HazelcastTopicEndpoint(hzInstance, uri, (Component)this, remaining, (HazelcastTopicConfiguration)config);
            endpoint.setCommand(HazelcastCommand.topic);
        }
        if (remaining.startsWith("seda:")) {
            remaining = StringHelper.removeStartingCharacters((String)remaining.substring("seda:".length()), (char)'/');
            config = new HazelcastSedaConfiguration();
            this.setProperties(config, parameters);
            ((HazelcastSedaConfiguration)config).setQueueName(remaining);
            endpoint = new HazelcastSedaEndpoint(hzInstance, uri, this, (HazelcastSedaConfiguration)config);
            endpoint.setCacheName(remaining);
            endpoint.setCommand(HazelcastCommand.seda);
        }
        if (remaining.startsWith("list:")) {
            remaining = StringHelper.removeStartingCharacters((String)remaining.substring("list:".length()), (char)'/');
            endpoint = new HazelcastListEndpoint(hzInstance, uri, (Component)this, remaining);
            endpoint.setCommand(HazelcastCommand.list);
        }
        if (remaining.startsWith("replicatedmap:")) {
            remaining = StringHelper.removeStartingCharacters((String)remaining.substring("replicatedmap:".length()), (char)'/');
            endpoint = new HazelcastReplicatedmapEndpoint(hzInstance, uri, remaining, this);
            endpoint.setCommand(HazelcastCommand.replicatedmap);
        }
        if (remaining.startsWith("set:")) {
            remaining = StringHelper.removeStartingCharacters((String)remaining.substring("set:".length()), (char)'/');
            endpoint = new HazelcastSetEndpoint(hzInstance, uri, (Component)this, remaining);
            endpoint.setCommand(HazelcastCommand.set);
        }
        if (remaining.startsWith("ringbuffer:")) {
            remaining = StringHelper.removeStartingCharacters((String)remaining.substring("ringbuffer:".length()), (char)'/');
            endpoint = new HazelcastRingbufferEndpoint(hzInstance, uri, (Component)this, remaining);
            endpoint.setCommand(HazelcastCommand.ringbuffer);
        }
        if (endpoint == null) {
            throw new IllegalArgumentException(String.format("Your URI does not provide a correct 'type' prefix. It should be anything like 'hazelcast:[%s|%s|%s|%s|%s|%s|%s|%s|%s|%s]name' but is '%s'.", "map:", "multimap:", "atomicvalue:", "instance:", "queue:", "seda:", "list:", "replicatedmap:", "set:", "ringbuffer:", uri));
        }
        endpoint.setDefaultOperation(defaultOperation);
        return endpoint;
    }

    public void doStart() throws Exception {
        super.doStart();
    }

    public void doStop() throws Exception {
        for (HazelcastInstance hazelcastInstance : this.customHazelcastInstances) {
            hazelcastInstance.getLifecycleService().shutdown();
        }
        this.customHazelcastInstances.clear();
        super.doStop();
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.hazelcastInstance;
    }

    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    public String getHazelcastMode() {
        return this.hazelcastMode;
    }

    public void setHazelcastMode(String hazelcastMode) {
        this.hazelcastMode = hazelcastMode;
    }

    private HazelcastInstance getOrCreateHzInstance(CamelContext context, Map<String, Object> parameters) throws Exception {
        HazelcastInstance hzInstance = null;
        Config config = null;
        hzInstance = (HazelcastInstance)this.resolveAndRemoveReferenceParameter(parameters, "hazelcastInstance", HazelcastInstance.class);
        if (hzInstance == null && parameters.get("hazelcastInstanceName") != null) {
            hzInstance = Hazelcast.getHazelcastInstanceByName((String)((String)parameters.get("hazelcastInstanceName")));
        }
        if (hzInstance == null) {
            config = (Config)this.resolveAndRemoveReferenceParameter(parameters, "hazelcastConfig", Config.class);
            if (config == null) {
                String configUri = (String)this.getAndRemoveParameter(parameters, "hazelcastConfigUri", String.class);
                if (configUri != null) {
                    configUri = this.getCamelContext().resolvePropertyPlaceholders(configUri);
                }
                if (configUri != null) {
                    InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)context, (String)configUri);
                    config = new XmlConfigBuilder(is).build();
                }
            }
            if (this.hazelcastInstance == null && config == null) {
                config = new XmlConfigBuilder().build();
                config.getProperties().setProperty("hazelcast.version.check.enabled", "false");
                config.getProperties().setProperty("hazelcast.phone.home.enabled", "false");
                hzInstance = Hazelcast.newHazelcastInstance((Config)config);
            } else if (config != null) {
                hzInstance = ObjectHelper.isNotEmpty((Object)config.getInstanceName()) ? Hazelcast.getOrCreateHazelcastInstance((Config)config) : Hazelcast.newHazelcastInstance((Config)config);
            }
            if (hzInstance != null && this.customHazelcastInstances.add(hzInstance)) {
                LOGGER.debug("Add managed HZ instance {}", (Object)hzInstance.getName());
            }
        }
        return hzInstance == null ? this.hazelcastInstance : hzInstance;
    }

    private HazelcastInstance getOrCreateHzClientInstance(CamelContext context, Map<String, Object> parameters) throws Exception {
        HazelcastInstance hzInstance = null;
        ClientConfig config = null;
        hzInstance = (HazelcastInstance)this.resolveAndRemoveReferenceParameter(parameters, "hazelcastInstance", HazelcastInstance.class);
        if (hzInstance == null && parameters.get("hazelcastInstanceName") != null) {
            hzInstance = Hazelcast.getHazelcastInstanceByName((String)((String)parameters.get("hazelcastInstanceName")));
        }
        if (hzInstance == null) {
            config = (ClientConfig)this.resolveAndRemoveReferenceParameter(parameters, "hazelcastConfig", ClientConfig.class);
            if (config == null) {
                String configUri = (String)this.getAndRemoveParameter(parameters, "hazelcastConfigUri", String.class);
                if (configUri != null) {
                    configUri = this.getCamelContext().resolvePropertyPlaceholders(configUri);
                }
                if (configUri != null) {
                    InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)context, (String)configUri);
                    config = new XmlClientConfigBuilder(is).build();
                }
            }
            if (this.hazelcastInstance == null && config == null) {
                config = new XmlClientConfigBuilder().build();
                config.getProperties().setProperty("hazelcast.version.check.enabled", "false");
                config.getProperties().setProperty("hazelcast.phone.home.enabled", "false");
                hzInstance = HazelcastClient.newHazelcastClient((ClientConfig)config);
            } else if (config != null) {
                hzInstance = HazelcastClient.newHazelcastClient((ClientConfig)config);
            }
            if (hzInstance != null && this.customHazelcastInstances.add(hzInstance)) {
                LOGGER.debug("Add managed HZ instance {}", (Object)hzInstance.getName());
            }
        }
        return hzInstance == null ? this.hazelcastInstance : hzInstance;
    }
}

