/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow.releases.helsinki;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.servicenow.AbstractServiceNowProcessor;
import org.apache.camel.component.servicenow.ServiceNowEndpoint;
import org.apache.camel.util.ObjectHelper;

class HelsinkiServiceNowImportSetProcessor
extends AbstractServiceNowProcessor {
    HelsinkiServiceNowImportSetProcessor(ServiceNowEndpoint endpoint) throws Exception {
        super(endpoint);
        this.addDispatcher("retrieve", this::retrieveRecord);
        this.addDispatcher("create", this::createRecord);
    }

    private void retrieveRecord(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        String tableName = this.getTableName(in);
        String apiVersion = this.getApiVersion(in);
        Class<?> responseModel = this.getResponseModel(in, tableName);
        String sysId = this.getSysID(in);
        Response response = this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("now").path(apiVersion).path("import").path(ObjectHelper.notNull((Object)tableName, (String)"tableName")).path(ObjectHelper.notNull((Object)sysId, (String)"sysId")).invoke("GET");
        this.setBodyAndHeaders(in, responseModel, response);
    }

    private void createRecord(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        String tableName = this.getTableName(in);
        String apiVersion = this.getApiVersion(in);
        Class<?> requestModel = this.getRequestModel(in, tableName);
        Class<?> responseModel = this.getResponseModel(in, tableName);
        this.validateBody(in, requestModel);
        Response response = this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("now").path(apiVersion).path("import").path(tableName).invoke("POST", in.getMandatoryBody());
        this.setBodyAndHeaders(in, responseModel, response);
    }
}

