/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.elasticsearch5;

import java.net.InetAddress;
import java.util.ArrayList;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.elasticsearch5.ElasticsearchConfiguration;
import org.apache.camel.component.elasticsearch5.ElasticsearchEndpoint;
import org.apache.camel.component.elasticsearch5.ElasticsearchOperation;
import org.apache.camel.impl.DefaultProducer;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.transport.client.PreBuiltTransportClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchProducer.class);
    protected final ElasticsearchConfiguration configuration;
    private TransportClient client;

    public ElasticsearchProducer(ElasticsearchEndpoint endpoint, ElasticsearchConfiguration configuration) {
        super((Endpoint)endpoint);
        this.configuration = configuration;
    }

    private ElasticsearchOperation resolveOperation(Exchange exchange) {
        Object request = exchange.getIn().getBody();
        if (request instanceof IndexRequest) {
            return ElasticsearchOperation.INDEX;
        }
        if (request instanceof GetRequest) {
            return ElasticsearchOperation.GET_BY_ID;
        }
        if (request instanceof MultiGetRequest) {
            return ElasticsearchOperation.MULTIGET;
        }
        if (request instanceof UpdateRequest) {
            return ElasticsearchOperation.UPDATE;
        }
        if (request instanceof BulkRequest) {
            if (this.configuration.getOperation() == ElasticsearchOperation.BULK_INDEX) {
                this.configuration.getOperation();
                return ElasticsearchOperation.BULK_INDEX;
            }
            this.configuration.getOperation();
            return ElasticsearchOperation.BULK;
        }
        if (request instanceof DeleteRequest) {
            return ElasticsearchOperation.DELETE;
        }
        if (request instanceof SearchRequest) {
            return ElasticsearchOperation.SEARCH;
        }
        if (request instanceof MultiSearchRequest) {
            return ElasticsearchOperation.MULTISEARCH;
        }
        if (request instanceof DeleteIndexRequest) {
            return ElasticsearchOperation.DELETE_INDEX;
        }
        ElasticsearchOperation operationConfig = (ElasticsearchOperation)((Object)exchange.getIn().getHeader("operation", ElasticsearchOperation.class));
        if (operationConfig == null) {
            operationConfig = this.configuration.getOperation();
        }
        if (operationConfig == null) {
            throw new IllegalArgumentException("operation value '" + (Object)((Object)operationConfig) + "' is not supported");
        }
        return operationConfig;
    }

    public void process(Exchange exchange) throws Exception {
        Message message = exchange.getIn();
        ElasticsearchOperation operation = this.resolveOperation(exchange);
        boolean configIndexName = false;
        String indexName = (String)message.getHeader("indexName", String.class);
        if (indexName == null) {
            message.setHeader("indexName", (Object)this.configuration.getIndexName());
            configIndexName = true;
        }
        boolean configIndexType = false;
        String indexType = (String)message.getHeader("indexType", String.class);
        if (indexType == null) {
            message.setHeader("indexType", (Object)this.configuration.getIndexType());
            configIndexType = true;
        }
        boolean configWaitForActiveShards = false;
        Integer waitForActiveShards = (Integer)message.getHeader("waitForActiveShards", Integer.class);
        if (waitForActiveShards == null) {
            message.setHeader("waitForActiveShards", (Object)this.configuration.getWaitForActiveShards());
            configWaitForActiveShards = true;
        }
        if (operation == ElasticsearchOperation.INDEX) {
            IndexRequest indexRequest = (IndexRequest)message.getBody(IndexRequest.class);
            message.setBody((Object)((IndexResponse)this.client.index(indexRequest).actionGet()).getId());
        } else if (operation == ElasticsearchOperation.UPDATE) {
            UpdateRequest updateRequest = (UpdateRequest)message.getBody(UpdateRequest.class);
            message.setBody((Object)((UpdateResponse)this.client.update(updateRequest).actionGet()).getId());
        } else if (operation == ElasticsearchOperation.GET_BY_ID) {
            GetRequest getRequest = (GetRequest)message.getBody(GetRequest.class);
            message.setBody((Object)this.client.get(getRequest));
        } else if (operation == ElasticsearchOperation.MULTIGET) {
            MultiGetRequest multiGetRequest = (MultiGetRequest)message.getBody(MultiGetRequest.class);
            message.setBody((Object)this.client.multiGet(multiGetRequest));
        } else if (operation == ElasticsearchOperation.BULK) {
            BulkRequest bulkRequest = (BulkRequest)message.getBody(BulkRequest.class);
            message.setBody(this.client.bulk(bulkRequest).actionGet());
        } else if (operation == ElasticsearchOperation.BULK_INDEX) {
            BulkRequest bulkRequest = (BulkRequest)message.getBody(BulkRequest.class);
            ArrayList<String> indexedIds = new ArrayList<String>();
            for (BulkItemResponse response : ((BulkResponse)this.client.bulk(bulkRequest).actionGet()).getItems()) {
                indexedIds.add(response.getId());
            }
            message.setBody(indexedIds);
        } else if (operation == ElasticsearchOperation.DELETE) {
            DeleteRequest deleteRequest = (DeleteRequest)message.getBody(DeleteRequest.class);
            message.setBody(this.client.delete(deleteRequest).actionGet());
        } else if (operation == ElasticsearchOperation.EXISTS) {
            SearchRequest searchRequest = new SearchRequest(new String[]{(String)exchange.getIn().getHeader("indexName", String.class)});
            try {
                this.client.prepareSearch(searchRequest.indices()).setSize(0).setTerminateAfter(1).get();
                message.setBody((Object)true);
            }
            catch (IndexNotFoundException e) {
                message.setBody((Object)false);
            }
        } else if (operation == ElasticsearchOperation.SEARCH) {
            SearchRequest searchRequest = (SearchRequest)message.getBody(SearchRequest.class);
            message.setBody(this.client.search(searchRequest).actionGet());
        } else if (operation == ElasticsearchOperation.MULTISEARCH) {
            MultiSearchRequest multiSearchRequest = (MultiSearchRequest)message.getBody(MultiSearchRequest.class);
            message.setBody((Object)this.client.multiSearch(multiSearchRequest));
        } else if (operation == ElasticsearchOperation.DELETE_INDEX) {
            DeleteIndexRequest deleteIndexRequest = (DeleteIndexRequest)message.getBody(DeleteIndexRequest.class);
            message.setBody(this.client.admin().indices().delete(deleteIndexRequest).actionGet());
        } else {
            throw new IllegalArgumentException("operation value '" + (Object)((Object)operation) + "' is not supported");
        }
        if (configIndexName) {
            message.removeHeader("indexName");
        }
        if (configIndexType) {
            message.removeHeader("indexType");
        }
        if (configWaitForActiveShards) {
            message.removeHeader("waitForActiveShards");
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.client == null) {
            LOG.info("Connecting to the ElasticSearch cluster: " + this.configuration.getClusterName());
            if (this.configuration.getIp() != null) {
                this.client = new PreBuiltTransportClient(this.getSettings(), new Class[0]).addTransportAddress((TransportAddress)new InetSocketTransportAddress(InetAddress.getByName(this.configuration.getIp()), this.configuration.getPort()));
            } else if (this.configuration.getTransportAddressesList() != null && !this.configuration.getTransportAddressesList().isEmpty()) {
                ArrayList<TransportAddress> addresses = new ArrayList<TransportAddress>(this.configuration.getTransportAddressesList().size());
                for (TransportAddress transportAddress : this.configuration.getTransportAddressesList()) {
                    addresses.add(transportAddress);
                }
                this.client = new PreBuiltTransportClient(this.getSettings(), new Class[0]).addTransportAddresses(addresses.toArray(new TransportAddress[addresses.size()]));
            } else {
                LOG.info("Incorrect ip address and port parameters settings for ElasticSearch cluster");
            }
        }
    }

    private Settings getSettings() {
        return Settings.builder().put("cluster.name", this.configuration.getClusterName()).put("client.transport.ignore_cluster_name", false).put("client.transport.sniff", this.configuration.getClientTransportSniff().booleanValue()).build();
    }

    protected void doStop() throws Exception {
        if (this.client != null) {
            LOG.info("Disconnecting from ElasticSearch cluster: " + this.configuration.getClusterName());
            this.client.close();
            this.client = null;
        }
        super.doStop();
    }
}

