/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.elasticsearch5;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.elasticsearch5.ElasticsearchConfiguration;
import org.apache.camel.component.elasticsearch5.ElasticsearchEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.elasticsearch.common.transport.InetSocketTransportAddress;

public class ElasticsearchComponent
extends UriEndpointComponent {
    public ElasticsearchComponent() {
        super(ElasticsearchEndpoint.class);
    }

    public ElasticsearchComponent(CamelContext context) {
        super(context, ElasticsearchEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        ElasticsearchConfiguration config = new ElasticsearchConfiguration();
        this.setProperties(config, parameters);
        config.setClusterName(remaining);
        config.setTransportAddressesList(this.parseTransportAddresses(config.getTransportAddresses(), config));
        ElasticsearchEndpoint endpoint = new ElasticsearchEndpoint(uri, this, config);
        return endpoint;
    }

    private List<InetSocketTransportAddress> parseTransportAddresses(String ipsString, ElasticsearchConfiguration config) throws UnknownHostException {
        if (ipsString == null || ipsString.isEmpty()) {
            return null;
        }
        List<String> addressesStr = Arrays.asList(ipsString.split(","));
        ArrayList<InetSocketTransportAddress> addressesTrAd = new ArrayList<InetSocketTransportAddress>(addressesStr.size());
        for (String address : addressesStr) {
            String[] split = address.split(":");
            if (split.length <= 0) {
                throw new IllegalArgumentException();
            }
            String hostname = split[0];
            Integer port = split.length > 1 ? Integer.parseInt(split[1]) : 9300;
            addressesTrAd.add(new InetSocketTransportAddress(InetAddress.getByName(hostname), port.intValue()));
        }
        return addressesTrAd;
    }
}

