/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul.policy;

import com.google.common.base.Optional;
import com.orbitz.consul.Consul;
import com.orbitz.consul.KeyValueClient;
import com.orbitz.consul.SessionClient;
import com.orbitz.consul.async.ConsulResponseCallback;
import com.orbitz.consul.model.ConsulResponse;
import com.orbitz.consul.model.kv.Value;
import com.orbitz.consul.model.session.ImmutableSession;
import com.orbitz.consul.model.session.Session;
import com.orbitz.consul.option.QueryOptions;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Route;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.consul.ConsulConfiguration;
import org.apache.camel.component.consul.ConsulConstants;
import org.apache.camel.support.RoutePolicySupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Route policy using Consul as clustered lock")
public final class ConsulRoutePolicy
extends RoutePolicySupport
implements CamelContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsulRoutePolicy.class);
    private final Object lock = new Object();
    private final AtomicBoolean leader = new AtomicBoolean(false);
    private final Set<Route> suspendedRoutes = new HashSet<Route>();
    private final AtomicReference<BigInteger> index = new AtomicReference<BigInteger>(BigInteger.valueOf(0L));
    private Route route;
    private CamelContext camelContext;
    private String serviceName;
    private String servicePath;
    private ExecutorService executorService;
    private int ttl = 60;
    private int lockDelay = 10;
    private boolean shouldStopConsumer = true;
    private String consulUrl = ConsulConstants.CONSUL_DEFAULT_URL;
    private Consul consul;
    private SessionClient sessionClient;
    private KeyValueClient keyValueClient;
    private String sessionId;

    public ConsulRoutePolicy() {
    }

    public ConsulRoutePolicy(String consulUrl) {
        this.consulUrl = consulUrl;
    }

    public ConsulRoutePolicy(ConsulConfiguration configuration) throws Exception {
        this.consulUrl = configuration.getUrl();
        this.consul = configuration.createConsulClient();
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getConsulUrl() {
        return this.consulUrl;
    }

    public void setConsulUrl(String consulUrl) {
        this.consulUrl = consulUrl;
    }

    public void onInit(Route route) {
        super.onInit(route);
        this.route = route;
    }

    public void onStart(Route route) {
        if (!this.leader.get() && this.shouldStopConsumer) {
            this.stopConsumer(route);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStop(Route route) {
        Object object = this.lock;
        synchronized (object) {
            this.suspendedRoutes.remove(route);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onSuspend(Route route) {
        Object object = this.lock;
        synchronized (object) {
            this.suspendedRoutes.remove(route);
        }
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"camelContext");
        ObjectHelper.notNull((Object)this.serviceName, (String)"serviceName");
        ObjectHelper.notNull((Object)this.servicePath, (String)"servicePath");
        if (this.consul == null) {
            Consul.Builder builder = Consul.builder();
            if (this.consulUrl != null) {
                builder.withUrl(this.consulUrl);
            }
            this.consul = builder.build();
        }
        if (this.sessionClient == null) {
            this.sessionClient = this.consul.sessionClient();
        }
        if (this.keyValueClient == null) {
            this.keyValueClient = this.consul.keyValueClient();
        }
        if (this.sessionId == null) {
            this.sessionId = this.sessionClient.createSession((Session)ImmutableSession.builder().name(this.serviceName).ttl(this.ttl + "s").lockDelay(this.lockDelay + "s").build()).getId();
            LOGGER.debug("SessionID = {}", (Object)this.sessionId);
            if (this.executorService == null) {
                this.executorService = this.getCamelContext().getExecutorServiceManager().newSingleThreadExecutor((Object)this, "ConsulRoutePolicy");
            }
            this.setLeader(this.keyValueClient.acquireLock(this.servicePath, this.sessionId));
            this.executorService.submit(new Watcher());
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.sessionId != null) {
            this.sessionClient.destroySession(this.sessionId);
            this.sessionId = null;
        }
        if (this.executorService != null) {
            this.getCamelContext().getExecutorServiceManager().shutdownGraceful(this.executorService);
        }
    }

    protected void setLeader(boolean isLeader) {
        if (isLeader && this.leader.compareAndSet(false, isLeader)) {
            LOGGER.debug("Leadership taken ({}, {})", (Object)this.serviceName, (Object)this.sessionId);
            this.startAllStoppedConsumers();
        } else if (!this.leader.getAndSet(isLeader) && isLeader) {
            LOGGER.debug("Leadership lost ({}, {})", (Object)this.serviceName, (Object)this.sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startConsumer(Route route) {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.suspendedRoutes.contains(route)) {
                    this.startConsumer(route.getConsumer());
                    this.suspendedRoutes.remove(route);
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopConsumer(Route route) {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (!this.suspendedRoutes.contains(route)) {
                    LOGGER.debug("Stopping consumer for {} ({})", (Object)route.getId(), (Object)route.getConsumer());
                    this.stopConsumer(route.getConsumer());
                    this.suspendedRoutes.add(route);
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAllStoppedConsumers() {
        Object object = this.lock;
        synchronized (object) {
            try {
                for (Route route : this.suspendedRoutes) {
                    LOGGER.debug("Starting consumer for {} ({})", (Object)route.getId(), (Object)route.getConsumer());
                    this.startConsumer(route.getConsumer());
                }
                this.suspendedRoutes.clear();
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    @ManagedAttribute(description="The route id")
    public String getRouteId() {
        if (this.route != null) {
            return this.route.getId();
        }
        return null;
    }

    @ManagedAttribute(description="The consumer endpoint", mask=true)
    public String getEndpointUrl() {
        if (this.route != null && this.route.getConsumer() != null && this.route.getConsumer().getEndpoint() != null) {
            return this.route.getConsumer().getEndpoint().toString();
        }
        return null;
    }

    public Consul getConsul() {
        return this.consul;
    }

    @ManagedAttribute(description="The consul service name")
    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
        this.servicePath = String.format("/service/%s/leader", serviceName);
    }

    @ManagedAttribute(description="The time to live (seconds)")
    public int getTtl() {
        return this.ttl;
    }

    public void setTtl(int ttl) {
        this.ttl = ttl > 10 ? ttl : 10;
    }

    @ManagedAttribute(description="The lock delay (seconds)")
    public int getLockDelay() {
        return this.lockDelay;
    }

    public void setLockDelay(int lockDelay) {
        this.lockDelay = lockDelay > 10 ? lockDelay : 10;
    }

    @ManagedAttribute(description="Whether to stop consumer when starting up and failed to become master")
    public boolean isShouldStopConsumer() {
        return this.shouldStopConsumer;
    }

    public void setShouldStopConsumer(boolean shouldStopConsumer) {
        this.shouldStopConsumer = shouldStopConsumer;
    }

    @ManagedAttribute(description="Is this route the master or a slave")
    public boolean isLeader() {
        return this.leader.get();
    }

    private class Watcher
    implements Runnable,
    ConsulResponseCallback<Optional<Value>> {
        private Watcher() {
        }

        public void onComplete(ConsulResponse<Optional<Value>> consulResponse) {
            if (ConsulRoutePolicy.this.isRunAllowed()) {
                Optional value = (Optional)consulResponse.getResponse();
                if (value.isPresent()) {
                    Optional sid = ((Value)value.get()).getSession();
                    if (sid.isPresent() && ObjectHelper.isNotEmpty((Object)sid.get())) {
                        LOGGER.debug("Try to take leadership ...");
                        ConsulRoutePolicy.this.setLeader(ConsulRoutePolicy.this.keyValueClient.acquireLock(ConsulRoutePolicy.this.servicePath, ConsulRoutePolicy.this.sessionId));
                    } else if (!ConsulRoutePolicy.this.sessionId.equals(sid) && ConsulRoutePolicy.this.leader.get()) {
                        ConsulRoutePolicy.this.setLeader(false);
                    }
                }
                ConsulRoutePolicy.this.index.set(consulResponse.getIndex());
                this.run();
            }
        }

        public void onFailure(Throwable throwable) {
            ConsulRoutePolicy.this.handleException(throwable);
        }

        @Override
        public void run() {
            if (ConsulRoutePolicy.this.isRunAllowed()) {
                ConsulRoutePolicy.this.sessionClient.renewSession(ConsulRoutePolicy.this.sessionId);
                ConsulRoutePolicy.this.keyValueClient.getValue(ConsulRoutePolicy.this.servicePath, (QueryOptions)QueryOptions.blockSeconds((int)(ConsulRoutePolicy.this.ttl / 3), (BigInteger)((BigInteger)ConsulRoutePolicy.this.index.get())).build(), (ConsulResponseCallback)this);
            }
        }
    }
}

