/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.producer;

import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.ResourceQuotaBuilder;
import io.fabric8.kubernetes.api.model.ResourceQuotaFluent;
import io.fabric8.kubernetes.api.model.ResourceQuotaList;
import io.fabric8.kubernetes.api.model.ResourceQuotaSpec;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.kubernetes.KubernetesEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesResourcesQuotaProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesResourcesQuotaProducer.class);

    public KubernetesResourcesQuotaProducer(KubernetesEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public KubernetesEndpoint getEndpoint() {
        return (KubernetesEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation = ObjectHelper.isEmpty((Object)this.getEndpoint().getKubernetesConfiguration().getOperation()) ? (String)exchange.getIn().getHeader("CamelKubernetesOperation", String.class) : this.getEndpoint().getKubernetesConfiguration().getOperation();
        switch (operation) {
            case "listResourcesQuota": {
                this.doList(exchange, operation);
                break;
            }
            case "listSecretsByLabels": {
                this.doListResourceQuotasByLabels(exchange, operation);
                break;
            }
            case "getResourceQuota": {
                this.doGetResourceQuota(exchange, operation);
                break;
            }
            case "createResourceQuota": {
                this.doCreateResourceQuota(exchange, operation);
                break;
            }
            case "deleteResourceQuota": {
                this.doDeleteResourceQuota(exchange, operation);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange, String operation) throws Exception {
        ResourceQuotaList resList = (ResourceQuotaList)this.getEndpoint().getKubernetesClient().resourceQuotas().list();
        exchange.getOut().setBody((Object)resList.getItems());
    }

    protected void doListResourceQuotasByLabels(Exchange exchange, String operation) throws Exception {
        ResourceQuotaList resList = null;
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesResourcesQuotaLabels", Map.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (!ObjectHelper.isEmpty((Object)namespaceName)) {
            NonNamespaceOperation resQuota = (NonNamespaceOperation)this.getEndpoint().getKubernetesClient().resourceQuotas().inNamespace(namespaceName);
            for (Map.Entry entry : labels.entrySet()) {
                resQuota.withLabel((String)entry.getKey(), (String)entry.getValue());
            }
            resList = (ResourceQuotaList)resQuota.list();
        } else {
            MixedOperation resQuota = this.getEndpoint().getKubernetesClient().resourceQuotas();
            for (Map.Entry entry : labels.entrySet()) {
                resQuota.withLabel((String)entry.getKey(), (String)entry.getValue());
            }
            resList = (ResourceQuotaList)resQuota.list();
        }
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)resList.getItems());
    }

    protected void doGetResourceQuota(Exchange exchange, String operation) throws Exception {
        ResourceQuota rq = null;
        String rqName = (String)exchange.getIn().getHeader("CamelKubernetesResourcesQuotaName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((Object)rqName)) {
            LOG.error("Get a specific Resource Quota require specify a Resource Quota name");
            throw new IllegalArgumentException("Get a specific Resource Quota require specify a Resource Quota name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Get a specific Resource Quota require specify a namespace name");
            throw new IllegalArgumentException("Get a specific Resource Quota require specify a namespace name");
        }
        rq = (ResourceQuota)((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().resourceQuotas().inNamespace(namespaceName)).withName(rqName)).get();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)rq);
    }

    protected void doCreateResourceQuota(Exchange exchange, String operation) throws Exception {
        ResourceQuota rq = null;
        String rqName = (String)exchange.getIn().getHeader("CamelKubernetesResourcesQuotaName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        ResourceQuotaSpec rqSpec = (ResourceQuotaSpec)exchange.getIn().getHeader("CamelKubernetesResourceQuotaSpec", ResourceQuotaSpec.class);
        if (ObjectHelper.isEmpty((Object)rqName)) {
            LOG.error("Create a specific resource quota require specify a resource quota name");
            throw new IllegalArgumentException("Create a specific resource quota require specify a resource quota name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Create a specific resource quota require specify a namespace name");
            throw new IllegalArgumentException("Create a specific resource quota require specify a namespace name");
        }
        if (ObjectHelper.isEmpty((Object)rqSpec)) {
            LOG.error("Create a specific resource quota require specify a resource quota spec bean");
            throw new IllegalArgumentException("Create a specific resource quota require specify a resource quota spec bean");
        }
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesResourcesQuotaLabels", Map.class);
        ResourceQuota rqCreating = ((ResourceQuotaBuilder)((ResourceQuotaBuilder)((ResourceQuotaFluent.MetadataNested)((ResourceQuotaFluent.MetadataNested)new ResourceQuotaBuilder().withNewMetadata().withName(rqName)).withLabels(labels)).endMetadata()).withSpec(rqSpec)).build();
        rq = (ResourceQuota)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().resourceQuotas().inNamespace(namespaceName)).create((Object[])new ResourceQuota[]{rqCreating});
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)rq);
    }

    protected void doDeleteResourceQuota(Exchange exchange, String operation) throws Exception {
        String rqName = (String)exchange.getIn().getHeader("CamelKubernetesResourcesQuotaName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((Object)rqName)) {
            LOG.error("Delete a specific resource quota require specify a resource quota name");
            throw new IllegalArgumentException("Delete a specific resource quota require specify a resource quota name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Delete a specific resource quota require specify a namespace name");
            throw new IllegalArgumentException("Delete a specific resource quota require specify a namespace name");
        }
        boolean rqDeleted = (Boolean)((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().resourceQuotas().inNamespace(namespaceName)).withName(rqName)).delete();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)rqDeleted);
    }
}

