/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.producer;

import io.fabric8.kubernetes.api.model.PersistentVolume;
import io.fabric8.kubernetes.api.model.PersistentVolumeList;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.kubernetes.KubernetesEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesPersistentVolumesProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesPersistentVolumesProducer.class);

    public KubernetesPersistentVolumesProducer(KubernetesEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public KubernetesEndpoint getEndpoint() {
        return (KubernetesEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation = ObjectHelper.isEmpty((Object)this.getEndpoint().getKubernetesConfiguration().getOperation()) ? (String)exchange.getIn().getHeader("CamelKubernetesOperation", String.class) : this.getEndpoint().getKubernetesConfiguration().getOperation();
        switch (operation) {
            case "listPersistentVolumes": {
                this.doList(exchange, operation);
                break;
            }
            case "listPersistentVolumesByLabels": {
                this.doListPersistentVolumesByLabels(exchange, operation);
                break;
            }
            case "getPersistentVolume": {
                this.doGetPersistentVolume(exchange, operation);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange, String operation) throws Exception {
        PersistentVolumeList persistentVolumeList = (PersistentVolumeList)this.getEndpoint().getKubernetesClient().persistentVolumes().list();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)persistentVolumeList.getItems());
    }

    protected void doListPersistentVolumesByLabels(Exchange exchange, String operation) throws Exception {
        PersistentVolumeList pvList = null;
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesPersistentVolumesLabels", Map.class);
        NonNamespaceOperation pvs = this.getEndpoint().getKubernetesClient().persistentVolumes();
        for (Map.Entry entry : labels.entrySet()) {
            pvs.withLabel((String)entry.getKey(), (String)entry.getValue());
        }
        pvList = (PersistentVolumeList)pvs.list();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)pvList.getItems());
    }

    protected void doGetPersistentVolume(Exchange exchange, String operation) throws Exception {
        PersistentVolume pv = null;
        String pvName = (String)exchange.getIn().getHeader("CamelKubernetesPersistentVolumeName", String.class);
        if (ObjectHelper.isEmpty((Object)pvName)) {
            LOG.error("Get a specific Persistent Volume require specify a Persistent Volume name");
            throw new IllegalArgumentException("Get a specific Persistent Volume require specify a Persistent Volume name");
        }
        pv = (PersistentVolume)((Resource)this.getEndpoint().getKubernetesClient().persistentVolumes().withName(pvName)).get();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)pv);
    }
}

