/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.apache.camel.component.mllp.MllpAcknowledgementTimeoutException;
import org.apache.camel.component.mllp.MllpComponent;
import org.apache.camel.component.mllp.MllpException;
import org.apache.camel.component.mllp.MllpReceiveAcknowledgementException;
import org.apache.camel.component.mllp.MllpReceiveException;
import org.apache.camel.component.mllp.MllpTimeoutException;
import org.apache.camel.component.mllp.impl.MllpSocketUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MllpSocketReader {
    final Socket socket;
    final int receiveTimeout;
    final int readTimeout;
    final boolean acknowledgementReader;
    Logger log = LoggerFactory.getLogger(this.getClass());
    byte[] receiveBuffer;
    ByteArrayOutputStream readAdditionalStream;

    public MllpSocketReader(Socket socket, int receiveTimeout, int readTimeout, boolean acknowledgementReader) {
        this.socket = socket;
        this.receiveTimeout = receiveTimeout;
        this.readTimeout = readTimeout;
        this.acknowledgementReader = acknowledgementReader;
        try {
            this.receiveBuffer = new byte[socket.getReceiveBufferSize()];
        }
        catch (SocketException socketEx) {
            throw new IllegalStateException("Cannot retrieve the value of SO_RCVBUF from the Socket", socketEx);
        }
    }

    public byte[] readEnvelopedPayload() throws MllpException {
        return this.readEnvelopedPayload(null, null);
    }

    public byte[] readEnvelopedPayload(byte[] hl7MessageBytes) throws MllpException {
        return this.readEnvelopedPayload(null, hl7MessageBytes);
    }

    public byte[] readEnvelopedPayload(Integer initialByte) throws MllpException {
        return this.readEnvelopedPayload(initialByte, null);
    }

    protected byte[] readEnvelopedPayload(Integer initialByte, byte[] hl7MessageBytes) throws MllpException {
        int availableCount;
        int readCount;
        byte[] answer = null;
        MllpSocketUtil.setSoTimeout(this.socket, this.receiveTimeout, this.log, "Preparing to receive payload");
        InputStream socketInputStream = null;
        try {
            socketInputStream = this.socket.getInputStream();
        }
        catch (IOException ioEx) {
            String errorMessage = "Failed to retrieve the InputStream from the Socket";
            this.resetConnection("Failed to retrieve the InputStream from the Socket");
            throw this.isAcknowledgementReader() ? new MllpReceiveAcknowledgementException("Failed to retrieve the InputStream from the Socket", hl7MessageBytes, (Throwable)ioEx) : new MllpReceiveException("Failed to retrieve the InputStream from the Socket", ioEx);
        }
        int startPosition = initialByte != null && initialByte == 11 ? 0 : -1;
        do {
            try {
                readCount = socketInputStream.read(this.receiveBuffer);
                if (readCount == -1) {
                    String errorMessage = "END_OF_STREAM encountered while attempting to receive payload - was Socket closed?";
                    this.resetConnection(errorMessage);
                    throw this.isAcknowledgementReader() ? new MllpReceiveAcknowledgementException(errorMessage, hl7MessageBytes) : new MllpReceiveException(errorMessage);
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Received bytes: {}", (Object)MllpComponent.covertBytesToPrintFriendlyString(this.receiveBuffer, 0, readCount));
                }
            }
            catch (SocketTimeoutException timeoutEx) {
                if (this.isAcknowledgementReader()) {
                    throw new MllpAcknowledgementTimeoutException(hl7MessageBytes, (Throwable)timeoutEx);
                }
                if (initialByte != null && initialByte == 11) {
                    answer = new byte[]{initialByte.byteValue()};
                    throw new MllpTimeoutException(answer, (Throwable)timeoutEx);
                }
                return null;
            }
            catch (IOException ioEx) {
                String errorMessage = "Error receiving payload";
                this.log.error(errorMessage, (Throwable)ioEx);
                this.resetConnection(errorMessage);
                throw this.isAcknowledgementReader() ? new MllpReceiveAcknowledgementException(errorMessage, hl7MessageBytes, (Throwable)ioEx) : new MllpReceiveException(errorMessage, ioEx);
            }
            if (readCount <= 0) continue;
            if (initialByte != null && initialByte == 11) {
                startPosition = 0;
            } else {
                int startOfBlock = MllpSocketUtil.findStartOfBlock(this.receiveBuffer, readCount);
                int n = startPosition = startOfBlock == -1 ? -1 : startOfBlock + 1;
            }
            if (startPosition <= 1) continue;
            String format = "Ignoring {} out-of-band bytes received before the beginning of the payload";
            int length = readCount - startPosition - 1;
            if (MllpComponent.isLogPhi()) {
                this.log.warn("Ignoring {} out-of-band bytes received before the beginning of the payload: {}", (Object)length, (Object)MllpComponent.covertBytesToPrintFriendlyString(this.receiveBuffer, 0, length));
                continue;
            }
            this.log.warn("Ignoring {} out-of-band bytes received before the beginning of the payload", (Object)length);
        } while (startPosition == -1);
        int endPosition = MllpSocketUtil.findEndOfMessage(this.receiveBuffer, readCount);
        if (endPosition != -1) {
            if (endPosition < readCount - 3) {
                String format = "Ignoring {} out-of-band bytes received after the end of the payload";
                int length = readCount - endPosition - 2;
                if (MllpComponent.isLogPhi()) {
                    this.log.warn("Ignoring {} out-of-band bytes received after the end of the payload: {}", (Object)length, (Object)MllpComponent.covertBytesToPrintFriendlyString(this.receiveBuffer, endPosition + 1, length));
                } else {
                    this.log.warn("Ignoring {} out-of-band bytes received after the end of the payload", (Object)length);
                }
            }
            int length = endPosition - startPosition;
            answer = new byte[length];
            System.arraycopy(this.receiveBuffer, startPosition, answer, 0, length);
        } else {
            this.getReadAdditionalStream().reset();
            this.readAdditionalStream.write(this.receiveBuffer, startPosition, readCount - startPosition);
            MllpSocketUtil.setSoTimeout(this.socket, this.readTimeout, this.log, "Preparing to continue reading payload");
            endPosition = -1;
            do {
                try {
                    readCount = socketInputStream.read(this.receiveBuffer);
                    if (readCount == -1) {
                        String errorMessage = "END_OF_STREAM encountered while attempting to read the end of the payload - Socket was closed or reset";
                        this.resetConnection(errorMessage);
                        byte[] partialPayload = this.readAdditionalStream.size() > 0 ? this.readAdditionalStream.toByteArray() : null;
                        throw this.isAcknowledgementReader() ? new MllpReceiveAcknowledgementException(errorMessage, hl7MessageBytes, partialPayload) : new MllpReceiveException(errorMessage, partialPayload);
                    }
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("Read additional bytes: {}", (Object)MllpComponent.covertBytesToPrintFriendlyString(this.receiveBuffer, 0, readCount));
                    }
                }
                catch (SocketTimeoutException timeoutEx) {
                    String errorMessage = "Timeout reading the end of the payload";
                    this.resetConnection(errorMessage);
                    byte[] partialPayload = this.readAdditionalStream.size() > 0 ? this.readAdditionalStream.toByteArray() : null;
                    throw this.isAcknowledgementReader() ? new MllpAcknowledgementTimeoutException(errorMessage, hl7MessageBytes, partialPayload, timeoutEx) : new MllpTimeoutException(errorMessage, partialPayload, timeoutEx);
                }
                catch (IOException ioEx) {
                    String errorMessage = "Error reading  the end of the payload";
                    this.resetConnection(errorMessage);
                    this.log.error(errorMessage);
                    byte[] partialPayload = this.readAdditionalStream.size() > 0 ? this.readAdditionalStream.toByteArray() : null;
                    throw this.isAcknowledgementReader() ? new MllpReceiveAcknowledgementException(errorMessage, hl7MessageBytes, partialPayload, ioEx) : new MllpReceiveException(errorMessage, partialPayload, ioEx);
                }
                if (readCount <= 0) continue;
                endPosition = MllpSocketUtil.findEndOfMessage(this.receiveBuffer, readCount);
                if (endPosition != -1) {
                    if (endPosition < readCount - 2) {
                        String format = "Ignoring {} out-of-band bytes after the end of the payload";
                        int length = readCount - endPosition - 2;
                        if (MllpComponent.isLogPhi()) {
                            this.log.warn("Ignoring {} out-of-band bytes after the end of the payload: {}", (Object)length, (Object)MllpComponent.covertBytesToPrintFriendlyString(this.receiveBuffer, endPosition + 2, length));
                        } else {
                            this.log.warn("Ignoring {} out-of-band bytes after the end of the payload", (Object)length);
                        }
                    }
                    this.readAdditionalStream.write(this.receiveBuffer, 0, endPosition);
                    continue;
                }
                this.readAdditionalStream.write(this.receiveBuffer, 0, readCount);
            } while (endPosition == -1);
            answer = this.readAdditionalStream.toByteArray();
        }
        do {
            try {
                availableCount = socketInputStream.available();
            }
            catch (IOException ioEx) {
                this.log.warn("Ignoring IOException encountered while checking for additional available trailing bytes", (Throwable)ioEx);
                break;
            }
            if (availableCount <= 0) continue;
            try {
                readCount = socketInputStream.read(this.receiveBuffer);
                String format = "Ignoring {} out-of-band bytes trailing after the end of the payload";
                if (MllpComponent.isLogPhi()) {
                    this.log.warn("Ignoring {} out-of-band bytes trailing after the end of the payload: {}", (Object)readCount, (Object)MllpComponent.covertBytesToPrintFriendlyString(this.receiveBuffer, 0, readCount));
                    continue;
                }
                this.log.warn("Ignoring {} out-of-band bytes trailing after the end of the payload", (Object)readCount);
            }
            catch (IOException ioEx) {
                this.log.warn(String.format("Ignoring IOException encountered while attempting to read %d bytes of trailing data", availableCount), (Throwable)ioEx);
                break;
            }
        } while (availableCount != 0);
        return answer;
    }

    public void closeConnection(String reasonMessage) {
        MllpSocketUtil.close(this.socket, this.log, reasonMessage);
    }

    public void resetConnection(String reasonMessage) {
        MllpSocketUtil.reset(this.socket, this.log, reasonMessage);
    }

    public Socket getSocket() {
        return this.socket;
    }

    public int getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public byte[] getReceiveBuffer() {
        return this.receiveBuffer;
    }

    public boolean isAcknowledgementReader() {
        return this.acknowledgementReader;
    }

    public ByteArrayOutputStream getReadAdditionalStream() {
        if (this.readAdditionalStream == null) {
            this.readAdditionalStream = new ByteArrayOutputStream(this.receiveBuffer.length);
        }
        return this.readAdditionalStream;
    }
}

