/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.policy;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.infinispan.InfinispanConfiguration;
import org.apache.camel.component.infinispan.InfinispanManager;
import org.apache.camel.component.infinispan.InfinispanUtil;
import org.apache.camel.support.RoutePolicySupport;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryExpired;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryRemoved;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryExpiredEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryRemovedEvent;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.api.BasicCacheContainer;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryExpired;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Route policy using Infinispan as clustered lock")
public class InfinispanRoutePolicy
extends RoutePolicySupport
implements CamelContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfinispanRoutePolicy.class);
    private final AtomicBoolean leader;
    private final Set<Route> suspendedRoutes;
    private final InfinispanManager manager;
    private Route route;
    private CamelContext camelContext;
    private ScheduledExecutorService executorService;
    private boolean shouldStopConsumer;
    private String lockMapName;
    private String lockKey;
    private String lockValue;
    private long lifespan;
    private TimeUnit lifespanTimeUnit;
    private ScheduledFuture<?> future;
    private Service service;

    public InfinispanRoutePolicy(InfinispanConfiguration configuration) {
        this(new InfinispanManager(configuration), null, null);
    }

    public InfinispanRoutePolicy(InfinispanManager manager) {
        this(manager, null, null);
    }

    public InfinispanRoutePolicy(InfinispanManager manager, String lockKey, String lockValue) {
        this.manager = manager;
        this.suspendedRoutes = new HashSet<Route>();
        this.leader = new AtomicBoolean(false);
        this.shouldStopConsumer = true;
        this.lockKey = lockKey;
        this.lockValue = lockValue;
        this.lifespan = 30L;
        this.lifespanTimeUnit = TimeUnit.SECONDS;
        this.service = null;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void onInit(Route route) {
        super.onInit(route);
        this.route = route;
    }

    public void onStart(Route route) {
        try {
            this.startService();
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
        if (!this.leader.get() && this.shouldStopConsumer) {
            this.stopConsumer(route);
        }
    }

    public synchronized void onStop(Route route) {
        try {
            this.stopService();
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
        this.suspendedRoutes.remove(route);
    }

    public synchronized void onSuspend(Route route) {
        try {
            this.stopService();
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
        this.suspendedRoutes.remove(route);
    }

    protected void doStart() throws Exception {
        StringHelper.notEmpty((String)this.lockMapName, (String)"lockMapName", (Object)((Object)this));
        StringHelper.notEmpty((String)this.lockKey, (String)"lockKey", (Object)((Object)this));
        StringHelper.notEmpty((String)this.lockValue, (String)"lockValue", (Object)((Object)this));
        ObjectHelper.notNull((Object)this.camelContext, (String)"camelContext", (Object)((Object)this));
        this.manager.start();
        this.executorService = this.getCamelContext().getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)this, "InfinispanRoutePolicy");
        if (this.lifespanTimeUnit.convert(this.lifespan, TimeUnit.SECONDS) < 2L) {
            throw new IllegalArgumentException("Lock lifespan can not be less that 2 seconds");
        }
        if (this.manager.isCacheContainerEmbedded()) {
            BasicCache cache = this.manager.getCache(this.lockMapName);
            this.service = new EmbeddedCacheService(InfinispanUtil.asEmbedded(cache));
        } else {
            BasicCache cache = this.manager.getCache(this.lockMapName, true);
            this.service = new RemoteCacheService(InfinispanUtil.asRemote(cache));
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this.future != null) {
            this.future.cancel(true);
            this.future = null;
        }
        if (this.service != null) {
            this.service.stop();
        }
        this.getCamelContext().getExecutorServiceManager().shutdownGraceful((ExecutorService)this.executorService);
        this.leader.set(false);
        this.manager.stop();
        super.doStop();
    }

    private void startService() throws Exception {
        if (this.service == null) {
            throw new IllegalStateException("An Infinispan CacheService should be configured");
        }
        this.service.start();
    }

    private void stopService() throws Exception {
        this.leader.set(false);
        if (this.service != null) {
            this.service.stop();
        }
    }

    protected void setLeader(boolean isLeader) {
        if (isLeader && this.leader.compareAndSet(false, isLeader)) {
            LOGGER.info("Leadership taken (map={}, key={}, val={})", new Object[]{this.lockMapName, this.lockKey, this.lockValue});
            this.startAllStoppedConsumers();
        } else if (!isLeader && this.leader.getAndSet(isLeader)) {
            LOGGER.info("Leadership lost (map={}, key={} val={})", new Object[]{this.lockMapName, this.lockKey, this.lockValue});
        }
        if (!isLeader && this.route != null) {
            this.stopConsumer(this.route);
        }
    }

    private synchronized void startConsumer(Route route) {
        try {
            if (this.suspendedRoutes.contains(route)) {
                this.startConsumer(route.getConsumer());
                this.suspendedRoutes.remove(route);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private synchronized void stopConsumer(Route route) {
        try {
            if (!this.suspendedRoutes.contains(route)) {
                LOGGER.debug("Stopping consumer for {} ({})", (Object)route.getId(), (Object)route.getConsumer());
                this.stopConsumer(route.getConsumer());
                this.suspendedRoutes.add(route);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private synchronized void startAllStoppedConsumers() {
        try {
            for (Route route : this.suspendedRoutes) {
                LOGGER.debug("Starting consumer for {} ({})", (Object)route.getId(), (Object)route.getConsumer());
                this.startConsumer(route.getConsumer());
            }
            this.suspendedRoutes.clear();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @ManagedAttribute(description="The route id")
    public String getRouteId() {
        if (this.route != null) {
            return this.route.getId();
        }
        return null;
    }

    @ManagedAttribute(description="The consumer endpoint", mask=true)
    public String getEndpointUrl() {
        if (this.route != null && this.route.getConsumer() != null && this.route.getConsumer().getEndpoint() != null) {
            return this.route.getConsumer().getEndpoint().toString();
        }
        return null;
    }

    @ManagedAttribute(description="Whether to stop consumer when starting up and failed to become master")
    public boolean isShouldStopConsumer() {
        return this.shouldStopConsumer;
    }

    public void setShouldStopConsumer(boolean shouldStopConsumer) {
        this.shouldStopConsumer = shouldStopConsumer;
    }

    @ManagedAttribute(description="The lock map name")
    public String getLockMapName() {
        return this.lockMapName;
    }

    public void setLockMapName(String lockMapName) {
        this.lockMapName = lockMapName;
    }

    @ManagedAttribute(description="The lock key")
    public String getLockKey() {
        return this.lockKey;
    }

    public void setLockKey(String lockKey) {
        this.lockKey = lockKey;
    }

    @ManagedAttribute(description="The lock value")
    public String getLockValue() {
        return this.lockValue;
    }

    public void setLockValue(String lockValue) {
        this.lockValue = lockValue;
    }

    @ManagedAttribute(description="The key lifespan for the lock")
    public long getLifespan() {
        return this.lifespan;
    }

    public void setLifespan(long lifespan) {
        this.lifespan = lifespan;
    }

    public void setLifespan(long lifespan, TimeUnit lifespanTimeUnit) {
        this.lifespan = lifespan;
        this.lifespanTimeUnit = lifespanTimeUnit;
    }

    @ManagedAttribute(description="The key lifespan time unit for the lock")
    public TimeUnit getLifespanTimeUnit() {
        return this.lifespanTimeUnit;
    }

    public void setLifespanTimeUnit(TimeUnit lifespanTimeUnit) {
        this.lifespanTimeUnit = lifespanTimeUnit;
    }

    @ManagedAttribute(description="Is this route the master or a slave")
    public boolean isLeader() {
        return this.leader.get();
    }

    public static InfinispanRoutePolicy withManager(BasicCacheContainer cacheContainer) {
        InfinispanConfiguration conf = new InfinispanConfiguration();
        conf.setCacheContainer(cacheContainer);
        return new InfinispanRoutePolicy(conf);
    }

    @ClientListener
    private final class RemoteCacheService
    extends ServiceSupport
    implements Runnable {
        private RemoteCache<String, String> cache;
        private ScheduledFuture<?> future;
        private Long version;

        RemoteCacheService(RemoteCache<String, String> cache) {
            this.cache = cache;
            this.future = null;
            this.version = null;
        }

        protected void doStart() throws Exception {
            this.future = InfinispanRoutePolicy.this.executorService.scheduleAtFixedRate(this::run, 0L, InfinispanRoutePolicy.this.lifespan / 2L, InfinispanRoutePolicy.this.lifespanTimeUnit);
            this.cache.addClientListener((Object)this);
        }

        protected void doStop() throws Exception {
            this.cache.removeClientListener((Object)this);
            if (this.version != null) {
                this.cache.removeWithVersion((Object)InfinispanRoutePolicy.this.lockKey, this.version.longValue());
            }
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
        }

        @Override
        public void run() {
            if (!this.isRunAllowed() || !InfinispanRoutePolicy.this.isRunAllowed()) {
                return;
            }
            if (InfinispanRoutePolicy.this.isLeader() && this.version != null) {
                LOGGER.debug("Lock refresh key={} with version={}", (Object)InfinispanRoutePolicy.this.lockKey, (Object)this.version);
                if (!this.cache.replaceWithVersion((Object)InfinispanRoutePolicy.this.lockKey, (Object)InfinispanRoutePolicy.this.lockValue, this.version.longValue(), (int)InfinispanRoutePolicy.this.lifespanTimeUnit.toSeconds(InfinispanRoutePolicy.this.lifespan))) {
                    InfinispanRoutePolicy.this.setLeader(false);
                } else {
                    this.version = this.cache.getWithMetadata((Object)InfinispanRoutePolicy.this.lockKey).getVersion();
                    LOGGER.debug("Lock refreshed key={} with new version={}", (Object)InfinispanRoutePolicy.this.lockKey, (Object)this.version);
                }
            }
            if (!InfinispanRoutePolicy.this.isLeader()) {
                Object result = this.cache.putIfAbsent((Object)InfinispanRoutePolicy.this.lockKey, (Object)InfinispanRoutePolicy.this.lockValue, InfinispanRoutePolicy.this.lifespan, InfinispanRoutePolicy.this.lifespanTimeUnit);
                if (result == null) {
                    InfinispanRoutePolicy.this.setLeader(true);
                    this.version = this.cache.getWithMetadata((Object)InfinispanRoutePolicy.this.lockKey).getVersion();
                    LOGGER.debug("Lock acquired key={} with version={}", (Object)InfinispanRoutePolicy.this.lockKey, (Object)this.version);
                } else if (ObjectHelper.equal((Object)InfinispanRoutePolicy.this.lockValue, (Object)result) && !InfinispanRoutePolicy.this.isLeader()) {
                    InfinispanRoutePolicy.this.setLeader(true);
                    this.version = this.cache.getWithMetadata((Object)InfinispanRoutePolicy.this.lockKey).getVersion();
                    LOGGER.debug("Lock resumed key={} with version={}", (Object)InfinispanRoutePolicy.this.lockKey, (Object)this.version);
                } else {
                    InfinispanRoutePolicy.this.setLeader(false);
                }
            }
        }

        @ClientCacheEntryRemoved
        public void onCacheEntryRemoved(ClientCacheEntryRemovedEvent<String> event) {
            if (ObjectHelper.equal((Object)InfinispanRoutePolicy.this.lockKey, (Object)event.getKey())) {
                this.run();
            }
        }

        @ClientCacheEntryExpired
        public void onCacheEntryExpired(ClientCacheEntryExpiredEvent<String> event) {
            if (ObjectHelper.equal((Object)InfinispanRoutePolicy.this.lockKey, (Object)event.getKey())) {
                this.run();
            }
        }
    }

    @Listener(clustered=true, sync=false)
    private final class EmbeddedCacheService
    extends ServiceSupport
    implements Runnable {
        private Cache<String, String> cache;
        private ScheduledFuture<?> future;

        EmbeddedCacheService(Cache<String, String> cache) {
            this.cache = cache;
            this.future = null;
        }

        protected void doStart() throws Exception {
            this.future = InfinispanRoutePolicy.this.executorService.scheduleAtFixedRate(this::run, 0L, InfinispanRoutePolicy.this.lifespan / 2L, InfinispanRoutePolicy.this.lifespanTimeUnit);
            this.cache.addListener((Object)this);
        }

        protected void doStop() throws Exception {
            this.cache.removeListener((Object)this);
            this.cache.remove((Object)InfinispanRoutePolicy.this.lockKey, (Object)InfinispanRoutePolicy.this.lockValue);
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
        }

        @Override
        public void run() {
            if (!this.isRunAllowed() || !InfinispanRoutePolicy.this.isRunAllowed()) {
                return;
            }
            if (InfinispanRoutePolicy.this.isLeader() && !this.cache.replace((Object)InfinispanRoutePolicy.this.lockKey, (Object)InfinispanRoutePolicy.this.lockValue, (Object)InfinispanRoutePolicy.this.lockValue, InfinispanRoutePolicy.this.lifespan, InfinispanRoutePolicy.this.lifespanTimeUnit)) {
                InfinispanRoutePolicy.this.setLeader(false);
            }
            if (!InfinispanRoutePolicy.this.isLeader()) {
                Object result = this.cache.putIfAbsent((Object)InfinispanRoutePolicy.this.lockKey, (Object)InfinispanRoutePolicy.this.lockValue, InfinispanRoutePolicy.this.lifespan, InfinispanRoutePolicy.this.lifespanTimeUnit);
                if (result == null) {
                    InfinispanRoutePolicy.this.setLeader(true);
                } else if (ObjectHelper.equal((Object)InfinispanRoutePolicy.this.lockValue, (Object)result) && !InfinispanRoutePolicy.this.isLeader()) {
                    InfinispanRoutePolicy.this.setLeader(true);
                } else {
                    InfinispanRoutePolicy.this.setLeader(false);
                }
            }
        }

        @CacheEntryRemoved
        public void onCacheEntryRemoved(CacheEntryEvent<Object, Object> event) {
            if (ObjectHelper.equal((Object)InfinispanRoutePolicy.this.lockKey, (Object)event.getKey())) {
                this.run();
            }
        }

        @CacheEntryExpired
        public void onCacheEntryExpired(CacheEntryEvent<Object, Object> event) {
            if (ObjectHelper.equal((Object)InfinispanRoutePolicy.this.lockKey, (Object)event.getKey())) {
                this.run();
            }
        }
    }
}

