/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.infinispan.InfinispanCustomListener;
import org.apache.camel.component.infinispan.InfinispanQueryBuilder;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.util.ObjectHelper;
import org.infinispan.commons.api.BasicCacheContainer;
import org.infinispan.context.Flag;

@UriParams
public class InfinispanConfiguration
implements Cloneable {
    @UriParam
    private String hosts;
    @UriParam(label="producer", defaultValue="put", enums="put,putAll,putIfAbsent,putAsync,putAllAsync,putIfAbsentAsync,get,containsKey,containsValue,remove,removeAsync,replace,replaceAsync,size,clear,clearAsync,query,stats")
    private String command;
    @UriParam(label="consumer", defaultValue="true")
    private boolean sync = true;
    @UriParam(label="consumer", javaType="java.lang.String")
    private Set<String> eventTypes;
    @UriParam(label="consumer")
    private InfinispanCustomListener customListener;
    @UriParam(label="consumer", defaultValue="false")
    private boolean clusteredListener;
    @UriParam
    private InfinispanQueryBuilder queryBuilder;
    @UriParam(label="advanced", javaType="java.lang.String")
    private Flag[] flags;
    @UriParam(label="advanced")
    private String configurationUri;
    @UriParam(label="advanced")
    private Map<String, String> configurationProperties;
    @UriParam(label="advanced")
    private BasicCacheContainer cacheContainer;
    @UriParam(label="advanced")
    private Object cacheContainerConfiguration;

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public boolean hasCommand() {
        return ObjectHelper.isNotEmpty((Object)this.command);
    }

    public String getHosts() {
        return this.hosts;
    }

    public void setHosts(String hosts) {
        this.hosts = hosts;
    }

    public BasicCacheContainer getCacheContainer() {
        return this.cacheContainer;
    }

    public void setCacheContainer(BasicCacheContainer cacheContainer) {
        this.cacheContainer = cacheContainer;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public boolean isClusteredListener() {
        return this.clusteredListener;
    }

    public void setClusteredListener(boolean clusteredListener) {
        this.clusteredListener = clusteredListener;
    }

    public Set<String> getEventTypes() {
        return this.eventTypes;
    }

    public void setEventTypes(Set<String> eventTypes) {
        this.eventTypes = eventTypes;
    }

    public void setEventTypes(String eventTypes) {
        this.eventTypes = new HashSet<String>(Arrays.asList(eventTypes.split(",")));
    }

    public InfinispanCustomListener getCustomListener() {
        return this.customListener;
    }

    public void setCustomListener(InfinispanCustomListener customListener) {
        this.customListener = customListener;
    }

    public boolean hasCustomListener() {
        return this.customListener != null;
    }

    public InfinispanQueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }

    public void setQueryBuilder(InfinispanQueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    public boolean hasQueryBuilder() {
        return this.queryBuilder != null;
    }

    public Flag[] getFlags() {
        return this.flags;
    }

    public void setFlags(String flagsAsString) {
        String[] flagsArray = flagsAsString.split(",");
        this.flags = new Flag[flagsArray.length];
        for (int i = 0; i < flagsArray.length; ++i) {
            this.flags[i] = Flag.valueOf((String)flagsArray[i]);
        }
    }

    public void setFlags(Flag ... flags) {
        this.flags = flags;
    }

    public boolean hasFlags() {
        return this.flags != null && this.flags.length > 0;
    }

    public String getConfigurationUri() {
        return this.configurationUri;
    }

    public void setConfigurationUri(String configurationUri) {
        this.configurationUri = configurationUri;
    }

    public Map<String, String> getConfigurationProperties() {
        return this.configurationProperties;
    }

    public void setConfigurationProperties(Map<String, String> configurationProperties) {
        this.configurationProperties = configurationProperties;
    }

    public void addConfigurationProperty(String key, String value) {
        if (this.configurationProperties == null) {
            this.configurationProperties = new HashMap<String, String>();
        }
        this.configurationProperties.put(key, value);
    }

    public Object getCacheContainerConfiguration() {
        return this.cacheContainerConfiguration;
    }

    public void setCacheContainerConfiguration(Object cacheContainerConfiguration) {
        this.cacheContainerConfiguration = cacheContainerConfiguration;
    }

    public InfinispanConfiguration copy() {
        try {
            return (InfinispanConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

