/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.commands.jolokia;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;
import org.apache.camel.commands.AbstractCamelController;
import org.apache.camel.commands.jolokia.JolokiaCamelController;
import org.apache.camel.commands.jolokia.JolokiaClientFactory;
import org.jolokia.client.J4pClient;
import org.jolokia.client.exception.J4pException;
import org.jolokia.client.exception.J4pRemoteException;
import org.jolokia.client.request.J4pExecRequest;
import org.jolokia.client.request.J4pExecResponse;
import org.jolokia.client.request.J4pReadRequest;
import org.jolokia.client.request.J4pReadResponse;
import org.jolokia.client.request.J4pRequest;
import org.jolokia.client.request.J4pSearchRequest;
import org.jolokia.client.request.J4pSearchResponse;
import org.jolokia.client.request.J4pVersionRequest;
import org.jolokia.client.request.J4pVersionResponse;
import org.json.simple.JSONObject;

public class DefaultJolokiaCamelController
extends AbstractCamelController
implements JolokiaCamelController {
    private Map<String, ObjectName> cache = new HashMap<String, ObjectName>(100);
    private J4pClient jolokia;
    private String url;

    private ObjectName lookupCamelContext(String camelContextName) throws Exception {
        ObjectName on = this.cache.get(camelContextName);
        if (on == null) {
            ObjectName found = null;
            J4pSearchResponse sr = (J4pSearchResponse)this.jolokia.execute((J4pRequest)new J4pSearchRequest("*:type=context,*"));
            if (sr != null) {
                for (ObjectName name : sr.getObjectNames()) {
                    String id = name.getKeyProperty("name");
                    if (!camelContextName.equals(id = DefaultJolokiaCamelController.removeLeadingAndEndingQuotes(id))) continue;
                    found = name;
                    break;
                }
            }
            if (found != null) {
                on = found;
                this.cache.put(camelContextName, on);
            }
        }
        return on;
    }

    @Override
    public void using(J4pClient client) {
        this.jolokia = client;
        this.url = null;
    }

    @Override
    public void connect(String url, String username, String password) throws Exception {
        this.jolokia = JolokiaClientFactory.createJolokiaClient(url, username, password);
        this.url = url;
    }

    @Override
    public boolean ping() {
        if (this.jolokia == null) {
            throw new IllegalStateException("Need to connect to remote jolokia first");
        }
        try {
            J4pVersionResponse vr = (J4pVersionResponse)this.jolokia.execute((J4pRequest)new J4pVersionRequest());
            return vr != null && vr.getValue() != null;
        }
        catch (J4pException e) {
            return false;
        }
    }

    public Map<String, Object> getCamelContextInformation(String camelContextName) throws Exception {
        if (this.jolokia == null) {
            throw new IllegalStateException("Need to connect to remote jolokia first");
        }
        LinkedHashMap<String, Object> answer = new LinkedHashMap<String, Object>();
        ObjectName found = this.lookupCamelContext(camelContextName);
        if (found != null) {
            block12: {
                String pattern = String.format("%s:context=%s,type=services,name=DefaultTypeConverter", found.getDomain(), found.getKeyProperty("context"));
                ObjectName tc = ObjectName.getInstance(pattern);
                String pattern2 = String.format("%s:context=%s,type=services,name=DefaultAsyncProcessorAwaitManager", found.getDomain(), found.getKeyProperty("context"));
                ObjectName am = ObjectName.getInstance(pattern2);
                ArrayList<J4pReadRequest> list = new ArrayList<J4pReadRequest>();
                list.add(new J4pReadRequest(found, new String[0]));
                list.add(new J4pReadRequest(tc, new String[0]));
                list.add(new J4pReadRequest(am, new String[0]));
                List rr = this.jolokia.execute(list);
                if (rr != null && rr.size() > 0) {
                    J4pReadResponse second;
                    J4pReadResponse first = (J4pReadResponse)rr.get(0);
                    for (String key : first.getAttributes()) {
                        answer.put(DefaultJolokiaCamelController.asKey(key), first.getValue(key));
                    }
                    if (rr.size() >= 2) {
                        second = (J4pReadResponse)rr.get(1);
                        for (String key : second.getAttributes()) {
                            answer.put("typeConverter." + DefaultJolokiaCamelController.asKey(key), second.getValue(key));
                        }
                    }
                    if (rr.size() >= 3) {
                        second = (J4pReadResponse)rr.get(2);
                        for (String key : second.getAttributes()) {
                            answer.put("asyncProcessorAwaitManager." + DefaultJolokiaCamelController.asKey(key), second.getValue(key));
                        }
                    }
                }
                answer.put("streamCachingEnabled", false);
                try {
                    pattern = String.format("%s:context=%s,type=services,name=DefaultStreamCachingStrategy", found.getDomain(), found.getKeyProperty("context"));
                    ObjectName sc = ObjectName.getInstance(pattern);
                    J4pReadResponse rsc = (J4pReadResponse)this.jolokia.execute((J4pRequest)new J4pReadRequest(sc, new String[0]));
                    if (rsc != null) {
                        for (String key : rsc.getAttributes()) {
                            answer.put("streamCaching." + DefaultJolokiaCamelController.asKey(key), rsc.getValue(key));
                        }
                    }
                    answer.put("streamCachingEnabled", true);
                }
                catch (J4pRemoteException e) {
                    boolean ignore = InstanceNotFoundException.class.getName().equals(e.getErrorType());
                    if (ignore) break block12;
                    throw e;
                }
            }
            answer.put("name", answer.get("camelId"));
            answer.put("status", answer.get("state"));
            answer.put("version", answer.get("camelVersion"));
            answer.put("suspended", "Suspended".equals(answer.get("state")));
            TimeUnit unit = TimeUnit.valueOf((String)answer.get("timeUnit"));
            long timeout = (Long)answer.get("timeout");
            answer.put("shutdownTimeout", "" + unit.toSeconds(timeout));
            answer.put("applicationContextClassLoader", answer.get("applicationContextClassName"));
        }
        return answer;
    }

    public List<Map<String, String>> getCamelContexts() throws Exception {
        if (this.jolokia == null) {
            throw new IllegalStateException("Need to connect to remote jolokia first");
        }
        ArrayList<Map<String, String>> answer = new ArrayList<Map<String, String>>();
        J4pSearchResponse sr = (J4pSearchResponse)this.jolokia.execute((J4pRequest)new J4pSearchRequest("*:type=context,*"));
        ArrayList<J4pReadRequest> list = new ArrayList<J4pReadRequest>();
        for (ObjectName on : sr.getObjectNames()) {
            list.add(new J4pReadRequest(on, new String[]{"CamelId", "State", "Uptime", "ExchangesTotal", "ExchangesInflight", "ExchangesFailed"}));
        }
        List lrr = this.jolokia.execute(list);
        for (J4pReadResponse rr : lrr) {
            LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
            row.put("name", rr.getValue("CamelId").toString());
            row.put("state", rr.getValue("State").toString());
            row.put("uptime", rr.getValue("Uptime").toString());
            row.put("exchangesTotal", rr.getValue("ExchangesTotal").toString());
            row.put("exchangesInflight", rr.getValue("ExchangesInflight").toString());
            row.put("exchangesFailed", rr.getValue("ExchangesFailed").toString());
            answer.add(row);
        }
        return answer;
    }

    public String getCamelContextStatsAsXml(String camelContextName, boolean fullStats, boolean includeProcessors) throws Exception {
        J4pExecResponse er;
        if (this.jolokia == null) {
            throw new IllegalStateException("Need to connect to remote jolokia first");
        }
        ObjectName found = this.lookupCamelContext(camelContextName);
        if (found != null && (er = (J4pExecResponse)this.jolokia.execute((J4pRequest)new J4pExecRequest(found, "dumpRoutesStatsAsXml(boolean,boolean)", new Object[]{fullStats, includeProcessors}))) != null) {
            String xml = (String)er.getValue();
            return xml;
        }
        return null;
    }

    public List<Map<String, Object>> browseInflightExchanges(String camelContextName, String route, int limit, boolean sortByLongestDuration) throws Exception {
        JSONObject data;
        String pattern;
        ObjectName on;
        J4pExecResponse er;
        if (this.jolokia == null) {
            throw new IllegalStateException("Need to connect to remote jolokia first");
        }
        ArrayList<Map<String, Object>> answer = new ArrayList<Map<String, Object>>();
        ObjectName found = this.lookupCamelContext(camelContextName);
        if (found != null && (er = (J4pExecResponse)this.jolokia.execute((J4pRequest)new J4pExecRequest(on = ObjectName.getInstance(pattern = String.format("%s:context=%s,type=services,name=DefaultInflightRepository", found.getDomain(), found.getKeyProperty("context"))), "browse(String,int,boolean)", new Object[]{route, limit, sortByLongestDuration}))) != null && (data = (JSONObject)er.getValue()) != null) {
            for (Object obj : data.values()) {
                JSONObject inflight = (JSONObject)obj;
                LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
                row.put("exchangeId", DefaultJolokiaCamelController.asString(inflight.get((Object)"exchangeId")));
                row.put("fromRouteId", DefaultJolokiaCamelController.asString(inflight.get((Object)"fromRouteId")));
                row.put("routeId", DefaultJolokiaCamelController.asString(inflight.get((Object)"routeId")));
                row.put("nodeId", DefaultJolokiaCamelController.asString(inflight.get((Object)"nodeId")));
                row.put("elapsed", DefaultJolokiaCamelController.asString(inflight.get((Object)"elapsed")));
                row.put("duration", DefaultJolokiaCamelController.asString(inflight.get((Object)"duration")));
                answer.add(row);
            }
        }
        return answer;
    }

    public void startContext(String camelContextName) throws Exception {
        if (this.jolokia == null) {
            throw new IllegalStateException("Need to connect to remote jolokia first");
        }
        ObjectName found = this.lookupCamelContext(camelContextName);
        if (found != null) {
            this.jolokia.execute((J4pRequest)new J4pExecRequest(found, "start", new Object[0]));
        }
    }

    public void stopContext(String camelContextName) throws Exception {
        if (this.jolokia == null) {
            throw new IllegalStateException("Need to connect to remote jolokia first");
        }
        ObjectName found = this.lookupCamelContext(camelContextName);
        if (found != null) {
            this.jolokia.execute((J4pRequest)new J4pExecRequest(found, "stop", new Object[0]));
        }
    }

    public void suspendContext(String camelContextName) throws Exception {
        if (this.jolokia == null) {
            throw new IllegalStateException("Need to connect to remote jolokia first");
        }
        ObjectName found = this.lookupCamelContext(camelContextName);
        if (found != null) {
            this.jolokia.execute((J4pRequest)new J4pExecRequest(found, "suspend", new Object[0]));
        }
    }

    public void resumeContext(String camelContextName) throws Exception {
        if (this.jolokia == null) {
            throw new IllegalStateException("Need to connect to remote jolokia first");
        }
        ObjectName found = this.lookupCamelContext(camelContextName);
        if (found != null) {
            this.jolokia.execute((J4pRequest)new J4pExecRequest(found, "resume", new Object[0]));
        }
    }

    public List<Map<String, String>> getRoutes(String camelContextName) throws Exception {
        return this.getRoutes(camelContextName, null);
    }

    public List<Map<String, String>> getRoutes(String camelContextName, String filter) throws Exception {
        ObjectName found;
        if (this.jolokia == null) {
            throw new IllegalStateException("Need to connect to remote jolokia first");
        }
        ArrayList<Map<String, String>> answer = new ArrayList<Map<String, String>>();
        ObjectName objectName = found = camelContextName != null ? this.lookupCamelContext(camelContextName) : null;
        if (found != null) {
            String pattern = String.format("%s:context=%s,type=routes,*", found.getDomain(), found.getKeyProperty("context"));
            J4pSearchResponse sr = (J4pSearchResponse)this.jolokia.execute((J4pRequest)new J4pSearchRequest(pattern));
            ArrayList<J4pReadRequest> list = new ArrayList<J4pReadRequest>();
            for (ObjectName on : sr.getObjectNames()) {
                list.add(new J4pReadRequest(on, new String[]{"CamelId", "RouteId", "State", "Uptime", "ExchangesTotal", "ExchangesInflight", "ExchangesFailed"}));
            }
            List lrr = this.jolokia.execute(list);
            for (J4pReadResponse rr : lrr) {
                String routeId = rr.getValue("RouteId").toString();
                if (filter != null && !routeId.matches(filter)) continue;
                LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
                row.put("camelContextName", rr.getValue("CamelId").toString());
                row.put("routeId", routeId);
                row.put("state", rr.getValue("State").toString());
                row.put("uptime", rr.getValue("Uptime").toString());
                row.put("exchangesTotal", rr.getValue("ExchangesTotal").toString());
                row.put("exchangesInflight", rr.getValue("ExchangesInflight").toString());
                row.put("exchangesFailed", rr.getValue("ExchangesFailed").toString());
                answer.add(row);
            }
        } else {
            List<Map<String, String>> camelContexts = this.getCamelContexts();
            for (Map<String, String> row : camelContexts) {
                List<Map<String, String>> routes = this.getRoutes(row.get("name"), filter);
                answer.addAll(routes);
            }
        }
        Collections.sort(answer, new Comparator<Map<String, String>>(){

            @Override
            public int compare(Map<String, String> o1, Map<String, String> o2) {
                String c2;
                String c1 = o1.get("camelContextName");
                int answer = c1.compareTo(c2 = o2.get("camelContextName"));
                if (answer == 0) {
                    answer = o1.get("routeId").compareTo(o2.get("routeId"));
                }
                return answer;
            }
        });
        return answer;
    }

    public void resetRouteStats(String camelContextName) throws Exception {
        if (this.jolokia == null) {
            throw new IllegalStateException("Need to connect to remote jolokia first");
        }
        ObjectName found = this.lookupCamelContext(camelContextName);
        if (found != null) {
            String pattern = String.format("%s:context=%s,type=routes,name=*", found.getDomain(), found.getKeyProperty("context"));
            J4pSearchResponse sr = (J4pSearchResponse)this.jolokia.execute((J4pRequest)new J4pSearchRequest(pattern));
            ArrayList<J4pExecRequest> list = new ArrayList<J4pExecRequest>();
            for (ObjectName on : sr.getObjectNames()) {
                list.add(new J4pExecRequest(on, "reset(boolean)", new Object[]{true}));
            }
            this.jolokia.execute(list);
        }
    }

    public void startRoute(String camelContextName, String routeId) throws Exception {
        if (this.jolokia == null) {
            throw new IllegalStateException("Need to connect to remote jolokia first");
        }
        ObjectName found = this.lookupCamelContext(camelContextName);
        if (found != null) {
            String pattern = String.format("%s:context=%s,type=routes,name=\"%s\"", found.getDomain(), found.getKeyProperty("context"), routeId);
            ObjectName on = ObjectName.getInstance(pattern);
            this.jolokia.execute((J4pRequest)new J4pExecRequest(on, "start()", new Object[0]));
        }
    }

    public void stopRoute(String camelContextName, String routeId) throws Exception {
        if (this.jolokia == null) {
            throw new IllegalStateException("Need to connect to remote jolokia first");
        }
        ObjectName found = this.lookupCamelContext(camelContextName);
        if (found != null) {
            String pattern = String.format("%s:context=%s,type=routes,name=\"%s\"", found.getDomain(), found.getKeyProperty("context"), routeId);
            ObjectName on = ObjectName.getInstance(pattern);
            this.jolokia.execute((J4pRequest)new J4pExecRequest(on, "stop()", new Object[0]));
        }
    }

    public void suspendRoute(String camelContextName, String routeId) throws Exception {
        if (this.jolokia == null) {
            throw new IllegalStateException("Need to connect to remote jolokia first");
        }
        ObjectName found = this.lookupCamelContext(camelContextName);
        if (found != null) {
            String pattern = String.format("%s:context=%s,type=routes,name=\"%s\"", found.getDomain(), found.getKeyProperty("context"), routeId);
            ObjectName on = ObjectName.getInstance(pattern);
            this.jolokia.execute((J4pRequest)new J4pExecRequest(on, "suspend()", new Object[0]));
        }
    }

    public void resumeRoute(String camelContextName, String routeId) throws Exception {
        if (this.jolokia == null) {
            throw new IllegalStateException("Need to connect to remote jolokia first");
        }
        ObjectName found = this.lookupCamelContext(camelContextName);
        if (found != null) {
            String pattern = String.format("%s:context=%s,type=routes,name=\"%s\"", found.getDomain(), found.getKeyProperty("context"), routeId);
            ObjectName on = ObjectName.getInstance(pattern);
            this.jolokia.execute((J4pRequest)new J4pExecRequest(on, "resume()", new Object[0]));
        }
    }

    public String getRouteModelAsXml(String routeId, String camelContextName) throws Exception {
        String pattern;
        ObjectName on;
        J4pExecResponse response;
        if (this.jolokia == null) {
            throw new IllegalStateException("Need to connect to remote jolokia first");
        }
        ObjectName found = this.lookupCamelContext(camelContextName);
        if (found != null && (response = (J4pExecResponse)this.jolokia.execute((J4pRequest)new J4pExecRequest(on = ObjectName.getInstance(pattern = String.format("%s:context=%s,type=routes,name=\"%s\"", found.getDomain(), found.getKeyProperty("context"), routeId)), "dumpRouteAsXml()", new Object[0]))) != null) {
            String xml = (String)response.getValue();
            return xml;
        }
        return null;
    }

    public String getRouteStatsAsXml(String routeId, String camelContextName, boolean fullStats, boolean includeProcessors) throws Exception {
        if (this.jolokia == null) {
            throw new IllegalStateException("Need to connect to remote jolokia first");
        }
        ObjectName found = this.lookupCamelContext(camelContextName);
        if (found != null) {
            String pattern = String.format("%s:context=%s,type=routes,name=\"%s\"", found.getDomain(), found.getKeyProperty("context"), routeId);
            ObjectName on = ObjectName.getInstance(pattern);
            J4pExecResponse response = (J4pExecResponse)this.jolokia.execute((J4pRequest)new J4pExecRequest(on, "dumpRouteStatsAsXml(boolean,boolean)", new Object[]{fullStats, includeProcessors}));
            if (response != null) {
                String xml = (String)response.getValue();
                return xml;
            }
        }
        return null;
    }

    public String getRestModelAsXml(String camelContextName) throws Exception {
        J4pExecResponse response;
        if (this.jolokia == null) {
            throw new IllegalStateException("Need to connect to remote jolokia first");
        }
        ObjectName found = this.lookupCamelContext(camelContextName);
        if (found != null && (response = (J4pExecResponse)this.jolokia.execute((J4pRequest)new J4pExecRequest(found, "dumpRestsAsXml()", new Object[0]))) != null) {
            String xml = (String)response.getValue();
            return xml;
        }
        return null;
    }

    public String getRestApiDocAsJson(String camelContextName) throws Exception {
        String pattern;
        ObjectName on;
        J4pExecResponse response;
        if (this.jolokia == null) {
            throw new IllegalStateException("Need to connect to remote jolokia first");
        }
        ObjectName found = this.lookupCamelContext(camelContextName);
        if (found != null && (response = (J4pExecResponse)this.jolokia.execute((J4pRequest)new J4pExecRequest(on = ObjectName.getInstance(pattern = String.format("%s:context=%s,type=services,name=DefaultRestRegistry", found.getDomain(), found.getKeyProperty("context"))), "apiDocAsJson()", new Object[0]))) != null) {
            String json = (String)response.getValue();
            return json;
        }
        return null;
    }

    public List<Map<String, String>> getEndpoints(String camelContextName) throws Exception {
        if (this.jolokia == null) {
            throw new IllegalStateException("Need to connect to remote jolokia first");
        }
        ArrayList<Map<String, String>> answer = new ArrayList<Map<String, String>>();
        ObjectName found = this.lookupCamelContext(camelContextName);
        if (found != null) {
            String pattern = String.format("%s:context=%s,type=endpoints,*", found.getDomain(), found.getKeyProperty("context"));
            J4pSearchResponse sr = (J4pSearchResponse)this.jolokia.execute((J4pRequest)new J4pSearchRequest(pattern));
            ArrayList<J4pReadRequest> list = new ArrayList<J4pReadRequest>();
            for (ObjectName on : sr.getObjectNames()) {
                list.add(new J4pReadRequest(on, new String[]{"CamelId", "EndpointUri", "State"}));
            }
            List lrr = this.jolokia.execute(list);
            for (J4pReadResponse rr : lrr) {
                LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
                row.put("camelContextName", rr.getValue("CamelId").toString());
                row.put("uri", rr.getValue("EndpointUri").toString());
                row.put("state", rr.getValue("State").toString());
                answer.add(row);
            }
        }
        return answer;
    }

    public List<Map<String, String>> getEndpointRuntimeStatistics(String camelContextName) throws Exception {
        if (this.jolokia == null) {
            throw new IllegalStateException("Need to connect to remote jolokia first");
        }
        ArrayList<Map<String, String>> answer = new ArrayList<Map<String, String>>();
        ObjectName found = this.lookupCamelContext(camelContextName);
        if (found != null) {
            String pattern = String.format("%s:context=%s,type=services,name=DefaultRuntimeEndpointRegistry", found.getDomain(), found.getKeyProperty("context"));
            ObjectName on = ObjectName.getInstance(pattern);
            J4pExecResponse response = (J4pExecResponse)this.jolokia.execute((J4pRequest)new J4pExecRequest(on, "endpointStatistics()", new Object[0]));
            if (response != null) {
                JSONObject data = (JSONObject)response.getValue();
                for (Object obj : data.values()) {
                    JSONObject data2 = (JSONObject)obj;
                    JSONObject service = (JSONObject)data2.values().iterator().next();
                    LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
                    row.put("index", DefaultJolokiaCamelController.asString(service.get((Object)"index")));
                    row.put("url", DefaultJolokiaCamelController.asString(service.get((Object)"url")));
                    row.put("routeId", DefaultJolokiaCamelController.asString(service.get((Object)"routeId")));
                    row.put("direction", DefaultJolokiaCamelController.asString(service.get((Object)"direction")));
                    row.put("static", DefaultJolokiaCamelController.asString(service.get((Object)"static")));
                    row.put("dynamic", DefaultJolokiaCamelController.asString(service.get((Object)"dynamic")));
                    row.put("hits", DefaultJolokiaCamelController.asString(service.get((Object)"hits")));
                    answer.add(row);
                }
            }
            Collections.sort(answer, new Comparator<Map<String, String>>(){

                @Override
                public int compare(Map<String, String> endpoint1, Map<String, String> endpoint2) {
                    String route2;
                    String route1 = endpoint1.get("routeId");
                    int num = route1.compareTo(route2 = endpoint2.get("routeId"));
                    if (num == 0) {
                        String dir1 = endpoint1.get("direction");
                        String dir2 = endpoint2.get("direction");
                        num = dir1.compareTo(dir2);
                    }
                    return num;
                }
            });
        }
        return answer;
    }

    public List<Map<String, String>> getRestServices(String camelContextName) throws Exception {
        if (this.jolokia == null) {
            throw new IllegalStateException("Need to connect to remote jolokia first");
        }
        ArrayList<Map<String, String>> answer = new ArrayList<Map<String, String>>();
        ObjectName found = this.lookupCamelContext(camelContextName);
        if (found != null) {
            JSONObject data;
            String pattern = String.format("%s:context=%s,type=services,name=DefaultRestRegistry", found.getDomain(), found.getKeyProperty("context"));
            ObjectName on = ObjectName.getInstance(pattern);
            J4pExecResponse response = (J4pExecResponse)this.jolokia.execute((J4pRequest)new J4pExecRequest(on, "listRestServices()", new Object[0]));
            if (response != null && (data = (JSONObject)response.getValue()) != null) {
                for (Object obj : data.values()) {
                    JSONObject data2 = (JSONObject)obj;
                    JSONObject service = (JSONObject)data2.values().iterator().next();
                    LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
                    row.put("basePath", DefaultJolokiaCamelController.asString(service.get((Object)"basePath")));
                    row.put("baseUrl", DefaultJolokiaCamelController.asString(service.get((Object)"baseUrl")));
                    row.put("consumes", DefaultJolokiaCamelController.asString(service.get((Object)"consumes")));
                    row.put("description", DefaultJolokiaCamelController.asString(service.get((Object)"description")));
                    row.put("inType", DefaultJolokiaCamelController.asString(service.get((Object)"inType")));
                    row.put("method", DefaultJolokiaCamelController.asString(service.get((Object)"method")));
                    row.put("outType", DefaultJolokiaCamelController.asString(service.get((Object)"outType")));
                    row.put("produces", DefaultJolokiaCamelController.asString(service.get((Object)"produces")));
                    row.put("routeId", DefaultJolokiaCamelController.asString(service.get((Object)"routeId")));
                    row.put("state", DefaultJolokiaCamelController.asString(service.get((Object)"state")));
                    row.put("uriTemplate", DefaultJolokiaCamelController.asString(service.get((Object)"uriTemplate")));
                    row.put("url", DefaultJolokiaCamelController.asString(service.get((Object)"url")));
                    answer.add(row);
                }
            }
            Collections.sort(answer, new Comparator<Map<String, String>>(){

                @Override
                public int compare(Map<String, String> service1, Map<String, String> service2) {
                    String url1 = service1.get("url");
                    String url2 = service2.get("url");
                    return url1.compareTo(url2);
                }
            });
        }
        return answer;
    }

    public String explainEndpointAsJSon(String camelContextName, String uri, boolean allOptions) throws Exception {
        J4pExecResponse response;
        if (this.jolokia == null) {
            throw new IllegalStateException("Need to connect to remote jolokia first");
        }
        ObjectName found = this.lookupCamelContext(camelContextName);
        if (found != null && (response = (J4pExecResponse)this.jolokia.execute((J4pRequest)new J4pExecRequest(found, "explainEndpointJson(java.lang.String,boolean)", new Object[]{uri, allOptions}))) != null) {
            String json = (String)response.getValue();
            return json;
        }
        return null;
    }

    public String explainEipAsJSon(String camelContextName, String nameOrId, boolean allOptions) throws Exception {
        J4pExecResponse response;
        if (this.jolokia == null) {
            throw new IllegalStateException("Need to connect to remote jolokia first");
        }
        ObjectName found = this.lookupCamelContext(camelContextName);
        if (found != null && (response = (J4pExecResponse)this.jolokia.execute((J4pRequest)new J4pExecRequest(found, "explainEipJson(java.lang.String,boolean)", new Object[]{nameOrId, allOptions}))) != null) {
            String json = (String)response.getValue();
            return json;
        }
        return null;
    }

    public List<Map<String, String>> listComponents(String camelContextName) throws Exception {
        if (this.jolokia == null) {
            throw new IllegalStateException("Need to connect to remote jolokia first");
        }
        ArrayList<Map<String, String>> answer = new ArrayList<Map<String, String>>();
        ObjectName found = this.lookupCamelContext(camelContextName);
        if (found != null) {
            J4pExecResponse response = (J4pExecResponse)this.jolokia.execute((J4pRequest)new J4pExecRequest(found, "listComponents()", new Object[0]));
            if (response != null) {
                JSONObject data = (JSONObject)response.getValue();
                for (Object obj : data.values()) {
                    JSONObject component = (JSONObject)obj;
                    LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
                    row.put("artifactId", DefaultJolokiaCamelController.asString(component.get((Object)"artifactId")));
                    row.put("title", DefaultJolokiaCamelController.asString(component.get((Object)"title")));
                    row.put("description", DefaultJolokiaCamelController.asString(component.get((Object)"description")));
                    row.put("groupId", DefaultJolokiaCamelController.asString(component.get((Object)"groupId")));
                    row.put("label", DefaultJolokiaCamelController.asString(component.get((Object)"label")));
                    row.put("name", DefaultJolokiaCamelController.asString(component.get((Object)"name")));
                    row.put("status", DefaultJolokiaCamelController.asString(component.get((Object)"status")));
                    row.put("type", DefaultJolokiaCamelController.asString(component.get((Object)"type")));
                    row.put("version", DefaultJolokiaCamelController.asString(component.get((Object)"version")));
                    answer.add(row);
                }
            }
            Collections.sort(answer, new Comparator<Map<String, String>>(){

                @Override
                public int compare(Map<String, String> component1, Map<String, String> component2) {
                    String name1 = component1.get("name");
                    String name2 = component2.get("name");
                    return name1.compareTo(name2);
                }
            });
        }
        return answer;
    }

    public List<Map<String, String>> getTransformers(String camelContextName) throws Exception {
        if (this.jolokia == null) {
            throw new IllegalStateException("Need to connect to remote jolokia first");
        }
        ArrayList<Map<String, String>> answer = new ArrayList<Map<String, String>>();
        ObjectName found = this.lookupCamelContext(camelContextName);
        if (found != null) {
            JSONObject data;
            String pattern = String.format("%s:context=%s,type=services,name=DefaultTransformerRegistry", found.getDomain(), found.getKeyProperty("context"));
            ObjectName on = ObjectName.getInstance(pattern);
            J4pExecResponse response = (J4pExecResponse)this.jolokia.execute((J4pRequest)new J4pExecRequest(on, "listTransformers()", new Object[0]));
            if (response != null && (data = (JSONObject)response.getValue()) != null) {
                for (Object obj : data.values()) {
                    JSONObject data2 = (JSONObject)obj;
                    JSONObject service = (JSONObject)data2.values().iterator().next();
                    LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
                    row.put("scheme", DefaultJolokiaCamelController.asString(service.get((Object)"scheme")));
                    row.put("from", DefaultJolokiaCamelController.asString(service.get((Object)"from")));
                    row.put("to", DefaultJolokiaCamelController.asString(service.get((Object)"to")));
                    row.put("static", DefaultJolokiaCamelController.asString(service.get((Object)"static")));
                    row.put("dynamic", DefaultJolokiaCamelController.asString(service.get((Object)"dynamic")));
                    row.put("description", DefaultJolokiaCamelController.asString(service.get((Object)"description")));
                    answer.add(row);
                }
            }
            Collections.sort(answer, new Comparator<Map<String, String>>(){

                @Override
                public int compare(Map<String, String> service1, Map<String, String> service2) {
                    String from2;
                    String scheme1 = service1.get("scheme");
                    String scheme2 = service2.get("scheme");
                    if (scheme1 != null && scheme2 != null) {
                        return scheme1.compareTo(scheme2);
                    }
                    if (scheme1 != null) {
                        return -1;
                    }
                    if (scheme2 != null) {
                        return 1;
                    }
                    String from1 = service1.get("from");
                    if (from1.equals(from2 = service2.get("from"))) {
                        String to1 = service1.get("to");
                        String to2 = service2.get("to");
                        return to1.compareTo(to2);
                    }
                    return from1.compareTo(from2);
                }
            });
        }
        return answer;
    }

    public List<Map<String, String>> getValidators(String camelContextName) throws Exception {
        if (this.jolokia == null) {
            throw new IllegalStateException("Need to connect to remote jolokia first");
        }
        ArrayList<Map<String, String>> answer = new ArrayList<Map<String, String>>();
        ObjectName found = this.lookupCamelContext(camelContextName);
        if (found != null) {
            JSONObject data;
            String pattern = String.format("%s:context=%s,type=services,name=DefaultValidatorRegistry", found.getDomain(), found.getKeyProperty("context"));
            ObjectName on = ObjectName.getInstance(pattern);
            J4pExecResponse response = (J4pExecResponse)this.jolokia.execute((J4pRequest)new J4pExecRequest(on, "listValidators()", new Object[0]));
            if (response != null && (data = (JSONObject)response.getValue()) != null) {
                for (Object obj : data.values()) {
                    JSONObject data2 = (JSONObject)obj;
                    JSONObject service = (JSONObject)data2.values().iterator().next();
                    LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
                    row.put("type", DefaultJolokiaCamelController.asString(service.get((Object)"type")));
                    row.put("static", DefaultJolokiaCamelController.asString(service.get((Object)"static")));
                    row.put("dynamic", DefaultJolokiaCamelController.asString(service.get((Object)"dynamic")));
                    row.put("description", DefaultJolokiaCamelController.asString(service.get((Object)"description")));
                    answer.add(row);
                }
            }
            Collections.sort(answer, new Comparator<Map<String, String>>(){

                @Override
                public int compare(Map<String, String> service1, Map<String, String> service2) {
                    String type1 = service1.get("type");
                    String type2 = service2.get("type");
                    return type1.compareTo(type2);
                }
            });
        }
        return answer;
    }

    private static String asKey(String attributeKey) {
        char ch = Character.toLowerCase(attributeKey.charAt(0));
        return ch + attributeKey.substring(1);
    }

    private static String asString(Object basePath) {
        if (basePath == null) {
            return null;
        }
        return basePath.toString();
    }

    private static String removeLeadingAndEndingQuotes(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        String copy = s.trim();
        if (copy.startsWith("'") && copy.endsWith("'")) {
            return copy.substring(1, copy.length() - 1);
        }
        if (copy.startsWith("\"") && copy.endsWith("\"")) {
            return copy.substring(1, copy.length() - 1);
        }
        return s;
    }
}

