/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcr;

import java.util.LinkedList;
import java.util.List;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import org.apache.camel.Message;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.util.ObjectHelper;

public class JcrMessage
extends DefaultMessage {
    private EventIterator eventIterator;
    private List<Event> eventList;

    public JcrMessage(EventIterator eventIterator) {
        this.eventIterator = eventIterator;
    }

    public String toString() {
        if (this.eventIterator != null) {
            return "JcrMessage[eventIterator: " + this.eventIterator + ", eventList: " + this.eventList + "]";
        }
        return "JcrMessage@" + ObjectHelper.getIdentityHashCode((Object)((Object)this));
    }

    public void copyFrom(Message that) {
        if (that == this) {
            return;
        }
        this.getHeaders().clear();
        if (that instanceof JcrMessage) {
            JcrMessage thatMessage = (JcrMessage)that;
            this.eventIterator = thatMessage.eventIterator;
            this.eventList = thatMessage.eventList;
        }
        this.setBody(that.getBody());
        this.setFault(that.isFault());
        if (that.hasHeaders()) {
            this.getHeaders().putAll(that.getHeaders());
        }
        this.getAttachments().clear();
        if (that.hasAttachments()) {
            this.getAttachmentObjects().putAll(that.getAttachmentObjects());
        }
    }

    public EventIterator getEventIterator() {
        return this.eventIterator;
    }

    protected Object createBody() {
        if (this.eventList == null) {
            this.eventList = new LinkedList<Event>();
            if (this.eventIterator != null) {
                while (this.eventIterator.hasNext()) {
                    this.eventList.add(this.eventIterator.nextEvent());
                }
            }
        }
        return this.eventList;
    }
}

