/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.mongodb.CamelMongoDbException;
import org.apache.camel.component.mongodb.MongoDbComponent;
import org.apache.camel.component.mongodb.MongoDbEndpoint;
import org.apache.camel.component.mongodb.MongoDbOperation;
import org.apache.camel.component.mongodb.MongoDbOutputType;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbProducer.class);
    private final Map<MongoDbOperation, Processor> operations = new HashMap<MongoDbOperation, Processor>();
    private MongoDbEndpoint endpoint;

    public MongoDbProducer(MongoDbEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.bind(MongoDbOperation.aggregate, this.createDoAggregate());
        this.bind(MongoDbOperation.command, this.createDoCommand());
        this.bind(MongoDbOperation.count, this.createDoCount());
        this.bind(MongoDbOperation.findAll, this.createDoFindAll());
        this.bind(MongoDbOperation.findById, this.createDoFindById());
        this.bind(MongoDbOperation.findOneByQuery, this.createDoFindOneByQuery());
        this.bind(MongoDbOperation.getColStats, this.createDoGetColStats());
        this.bind(MongoDbOperation.getDbStats, this.createDoGetDbStats());
        this.bind(MongoDbOperation.insert, this.createDoInsert());
        this.bind(MongoDbOperation.remove, this.createDoRemove());
        this.bind(MongoDbOperation.save, this.createDoSave());
        this.bind(MongoDbOperation.update, this.createDoUpdate());
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        MongoDbOperation operation = this.endpoint.getOperation();
        Object header = exchange.getIn().getHeader("CamelMongoDbOperation");
        if (header != null) {
            LOG.debug("Overriding default operation with operation specified on header: {}", header);
            try {
                operation = header instanceof MongoDbOperation ? (MongoDbOperation)((Object)ObjectHelper.cast(MongoDbOperation.class, (Object)header)) : MongoDbOperation.valueOf((String)exchange.getIn().getHeader("CamelMongoDbOperation", String.class));
            }
            catch (Exception e) {
                throw new CamelMongoDbException("Operation specified on header is not supported. Value: " + header, e);
            }
        }
        try {
            this.invokeOperation(operation, exchange);
        }
        catch (Exception e) {
            throw MongoDbComponent.wrapInCamelMongoDbException(e);
        }
    }

    protected void invokeOperation(MongoDbOperation operation, Exchange exchange) throws Exception {
        Processor processor = this.operations.get((Object)operation);
        if (processor == null) {
            throw new CamelMongoDbException("Operation not supported. Value: " + (Object)((Object)operation));
        }
        processor.process(exchange);
    }

    private MongoDbProducer bind(MongoDbOperation operation, Function<Exchange, Object> mongoDbFunction) {
        this.operations.put(operation, this.wrap(mongoDbFunction, operation));
        return this;
    }

    private BasicDBObject createDbStatsCommand() {
        return new BasicDBObject("dbStats", (Object)1).append("scale", (Object)1);
    }

    private BasicDBObject createCollStatsCommand(String collectionName) {
        return new BasicDBObject("collStats", (Object)collectionName);
    }

    private MongoDatabase calculateDb(Exchange exchange) {
        if (!this.endpoint.isDynamicity()) {
            return this.endpoint.getMongoDatabase();
        }
        String dynamicDB = (String)exchange.getIn().getHeader("CamelMongoDbDatabase", String.class);
        MongoDatabase db = dynamicDB == null ? this.endpoint.getMongoDatabase() : this.endpoint.getMongoConnection().getDatabase(dynamicDB);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Dynamic database selected: {}", (Object)db.getName());
        }
        return db;
    }

    private String calculateCollectionName(Exchange exchange) {
        if (!this.endpoint.isDynamicity()) {
            return this.endpoint.getCollection();
        }
        String dynamicCollection = (String)exchange.getIn().getHeader("CamelMongoDbCollection", String.class);
        if (dynamicCollection == null) {
            return this.endpoint.getCollection();
        }
        return dynamicCollection;
    }

    private MongoCollection<BasicDBObject> calculateCollection(Exchange exchange) {
        MongoCollection dbCol;
        if (!this.endpoint.isDynamicity()) {
            return this.endpoint.getMongoCollection().withWriteConcern(this.endpoint.getWriteConcern());
        }
        String dynamicDB = (String)exchange.getIn().getHeader("CamelMongoDbDatabase", String.class);
        String dynamicCollection = (String)exchange.getIn().getHeader("CamelMongoDbCollection", String.class);
        List dynamicIndex = (List)exchange.getIn().getHeader("CamelMongoDbCollectionIndex", List.class);
        if (dynamicDB == null && dynamicCollection == null) {
            dbCol = this.endpoint.getMongoCollection().withWriteConcern(this.endpoint.getWriteConcern());
        } else {
            MongoDatabase db = this.calculateDb(exchange);
            if (dynamicCollection == null) {
                dbCol = db.getCollection(this.endpoint.getCollection(), BasicDBObject.class);
            } else {
                dbCol = db.getCollection(dynamicCollection, BasicDBObject.class);
                if (dynamicIndex == null) {
                    this.endpoint.ensureIndex((MongoCollection<BasicDBObject>)dbCol, this.endpoint.createIndex());
                } else {
                    this.endpoint.ensureIndex((MongoCollection<BasicDBObject>)dbCol, dynamicIndex);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Dynamic database and/or collection selected: {}->{}", (Object)this.endpoint.getDatabase(), (Object)this.endpoint.getCollection());
        }
        return dbCol;
    }

    private List<DBObject> attemptConvertToList(List insertList, Exchange exchange) throws CamelMongoDbException {
        ArrayList<DBObject> dbObjectList = new ArrayList<DBObject>(insertList.size());
        TypeConverter converter = exchange.getContext().getTypeConverter();
        for (Object item : insertList) {
            try {
                DBObject dbObject = (DBObject)converter.mandatoryConvertTo(DBObject.class, item);
                dbObjectList.add(dbObject);
            }
            catch (Exception e) {
                throw new CamelMongoDbException("MongoDB operation = insert, Assuming List variant of MongoDB insert operation, but List contains non-DBObject items", e);
            }
        }
        return dbObjectList;
    }

    private boolean isWriteOperation(MongoDbOperation operation) {
        return MongoDbComponent.WRITE_OPERATIONS.contains((Object)operation);
    }

    private Processor wrap(Function<Exchange, Object> supplier, MongoDbOperation operation) {
        return exchange -> {
            Object result = supplier.apply(exchange);
            this.copyHeaders(exchange);
            this.moveBodyToOutIfResultIsReturnedAsHeader(exchange, operation);
            this.processAndTransferResult(result, exchange, operation);
        };
    }

    private void copyHeaders(Exchange exchange) {
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)false);
    }

    private void moveBodyToOutIfResultIsReturnedAsHeader(Exchange exchange, MongoDbOperation operation) {
        if (this.isWriteOperation(operation) && this.endpoint.isWriteResultAsHeader()) {
            exchange.getOut().setBody(exchange.getIn().getBody());
        }
    }

    private void processAndTransferResult(Object result, Exchange exchange, MongoDbOperation operation) {
        if (this.isWriteOperation(operation) && this.endpoint.isWriteResultAsHeader()) {
            exchange.getOut().setHeader("CamelMongoWriteResult", result);
        } else {
            exchange.getOut().setBody(result);
        }
    }

    private Function<Exchange, Object> createDoGetColStats() {
        return exch -> this.calculateDb((Exchange)exch).runCommand((Bson)this.createCollStatsCommand(this.calculateCollectionName((Exchange)exch)));
    }

    private Function<Exchange, Object> createDoFindOneByQuery() {
        return exch -> {
            try {
                MongoCollection<BasicDBObject> dbCol = this.calculateCollection((Exchange)exch);
                BasicDBObject o = (BasicDBObject)exch.getIn().getMandatoryBody(BasicDBObject.class);
                BasicDBObject sortBy = (BasicDBObject)exch.getIn().getHeader("CamelMongoDbSortBy", BasicDBObject.class);
                BasicDBObject fieldFilter = (BasicDBObject)exch.getIn().getHeader("CamelMongoDbFieldsFilter", BasicDBObject.class);
                if (fieldFilter == null) {
                    fieldFilter = new BasicDBObject();
                }
                if (sortBy == null) {
                    sortBy = new BasicDBObject();
                }
                BasicDBObject ret = (BasicDBObject)dbCol.find((Bson)o).projection((Bson)fieldFilter).sort((Bson)sortBy).first();
                exch.getOut().setHeader("CamelMongoDbResultTotalSize", (Object)(ret == null ? 0 : 1));
                return ret;
            }
            catch (InvalidPayloadException e) {
                throw new CamelMongoDbException("Payload is no BasicDBObject", e);
            }
        };
    }

    private Function<Exchange, Object> createDoCount() {
        return exchange -> {
            BasicDBObject query = (BasicDBObject)exchange.getContext().getTypeConverter().tryConvertTo(BasicDBObject.class, exchange, exchange.getIn().getBody());
            if (query == null) {
                query = new BasicDBObject();
            }
            return this.calculateCollection((Exchange)exchange).count((Bson)query);
        };
    }

    private Function<Exchange, Object> createDoFindAll() {
        return exchange -> {
            Object result;
            MongoCollection<BasicDBObject> dbCol = this.calculateCollection((Exchange)exchange);
            BasicDBObject query = null;
            if (exchange.getIn().getBody() != null) {
                query = (BasicDBObject)exchange.getContext().getTypeConverter().tryConvertTo(BasicDBObject.class, exchange, exchange.getIn().getBody());
            }
            BasicDBObject fieldFilter = (BasicDBObject)exchange.getIn().getHeader("CamelMongoDbFieldsFilter", BasicDBObject.class);
            Integer batchSize = (Integer)exchange.getIn().getHeader("CamelMongoDbBatchSize", Integer.class);
            Integer numToSkip = (Integer)exchange.getIn().getHeader("CamelMongoDbNumToSkip", Integer.class);
            Integer limit = (Integer)exchange.getIn().getHeader("CamelMongoDbLimit", Integer.class);
            BasicDBObject sortBy = (BasicDBObject)exchange.getIn().getHeader("CamelMongoDbSortBy", BasicDBObject.class);
            FindIterable ret = query == null && fieldFilter == null ? dbCol.find((Bson)new BasicDBObject()) : (fieldFilter == null ? dbCol.find((Bson)query) : (query != null ? dbCol.find((Bson)query).projection((Bson)fieldFilter) : dbCol.find((Bson)new BasicDBObject()).projection((Bson)fieldFilter)));
            if (sortBy != null) {
                ret.sort((Bson)sortBy);
            }
            if (batchSize != null) {
                ret.batchSize(batchSize.intValue());
            }
            if (numToSkip != null) {
                ret.skip(numToSkip.intValue());
            }
            if (limit != null) {
                ret.limit(limit.intValue());
            }
            if (!MongoDbOutputType.DBCursor.equals((Object)this.endpoint.getOutputType())) {
                try {
                    result = new ArrayList();
                    ret.iterator().forEachRemaining(((List)result)::add);
                    exchange.getOut().setHeader("CamelMongoDbResultPageSize", (Object)((List)result).size());
                }
                finally {
                    ret.iterator().close();
                }
            } else {
                result = ret;
            }
            return result;
        };
    }

    private Function<Exchange, Object> createDoInsert() {
        return exchange -> {
            Object insert;
            boolean singleInsert;
            MongoCollection<BasicDBObject> dbCol = this.calculateCollection((Exchange)exchange);
            boolean bl = singleInsert = (Boolean)exchange.getIn().getHeader("CamelMongoDbMultiInsert", (Object)Boolean.FALSE, Boolean.class) == false;
            if (singleInsert) {
                insert = exchange.getContext().getTypeConverter().tryConvertTo(DBObject.class, exchange, exchange.getIn().getBody());
                if (insert == null) {
                    insert = this.getMultiInsertBody((Exchange)exchange);
                    singleInsert = false;
                } else if (insert instanceof BasicDBList) {
                    singleInsert = false;
                }
            } else {
                insert = this.getMultiInsertBody((Exchange)exchange);
            }
            if (singleInsert) {
                BasicDBObject insertObject2 = (BasicDBObject)insert;
                dbCol.insertOne((Object)insertObject2);
                exchange.getIn().setHeader("CamelMongoOid", insertObject2.get("_id"));
            } else {
                List insertObjects = (List)insert;
                dbCol.insertMany(insertObjects);
                ArrayList objectIdentification = new ArrayList(insertObjects.size());
                objectIdentification.addAll(insertObjects.stream().map(insertObject -> insertObject.get("_id")).collect(Collectors.toList()));
                exchange.getIn().setHeader("CamelMongoOid", objectIdentification);
            }
            return insert;
        };
    }

    private Object getMultiInsertBody(Exchange exchange) {
        List<DBObject> insert = exchange.getIn().getBody(List.class);
        insert = insert != null ? this.attemptConvertToList(insert, exchange) : exchange.getContext().getTypeConverter().tryConvertTo(BasicDBList.class, exchange, exchange.getIn().getBody());
        if (insert == null) {
            throw new CamelMongoDbException("MongoDB operation = insert, Body is not conversible to type DBObject nor List<DBObject>");
        }
        return insert;
    }

    private Function<Exchange, Object> createDoUpdate() {
        return exchange -> {
            try {
                UpdateResult result;
                MongoCollection<BasicDBObject> dbCol = this.calculateCollection((Exchange)exchange);
                List saveObj = (List)exchange.getIn().getMandatoryBody(List.class);
                if (saveObj.size() != 2) {
                    throw new CamelMongoDbException("MongoDB operation = insert, failed because body is not a List of DBObject objects with size = 2");
                }
                BasicDBObject updateCriteria = (BasicDBObject)saveObj.get(0);
                BasicDBObject objNew = (BasicDBObject)saveObj.get(1);
                Boolean multi = (Boolean)exchange.getIn().getHeader("CamelMongoDbMultiUpdate", Boolean.class);
                Boolean upsert = (Boolean)exchange.getIn().getHeader("CamelMongoDbUpsert", Boolean.class);
                UpdateOptions options = new UpdateOptions();
                if (upsert != null) {
                    options.upsert(true);
                }
                if ((result = multi == null ? dbCol.updateOne((Bson)updateCriteria, (Bson)objNew, options) : dbCol.updateMany((Bson)updateCriteria, (Bson)objNew, options)).isModifiedCountAvailable()) {
                    exchange.getOut().setHeader("CamelMongoDbRecordsAffected", (Object)result.getModifiedCount());
                }
                return result;
            }
            catch (InvalidPayloadException e) {
                throw new CamelMongoDbException("Invalid payload for update", e);
            }
        };
    }

    private Function<Exchange, Object> createDoRemove() {
        return exchange -> {
            try {
                MongoCollection<BasicDBObject> dbCol = this.calculateCollection((Exchange)exchange);
                BasicDBObject removeObj = (BasicDBObject)exchange.getIn().getMandatoryBody(BasicDBObject.class);
                DeleteResult result = dbCol.deleteMany((Bson)removeObj);
                if (result.wasAcknowledged()) {
                    exchange.getOut().setHeader("CamelMongoDbRecordsAffected", (Object)result.getDeletedCount());
                }
                return result;
            }
            catch (InvalidPayloadException e) {
                throw new CamelMongoDbException("Invalid payload for remove", e);
            }
        };
    }

    private Function<Exchange, Object> createDoAggregate() {
        return exchange -> {
            try {
                AggregateIterable aggregationResult;
                MongoCollection<BasicDBObject> dbCol = this.calculateCollection((Exchange)exchange);
                DBObject query = (DBObject)exchange.getIn().getMandatoryBody(DBObject.class);
                ArrayList dbIterator = new ArrayList();
                if (query instanceof BasicDBList) {
                    List queryList = ((BasicDBList)query).stream().map(o -> (Bson)o).collect(Collectors.toList());
                    aggregationResult = dbCol.aggregate(queryList);
                } else {
                    ArrayList<Bson> queryList = new ArrayList<Bson>();
                    queryList.add((Bson)query);
                    aggregationResult = dbCol.aggregate(queryList);
                }
                aggregationResult.iterator().forEachRemaining(dbIterator::add);
                return dbIterator;
            }
            catch (InvalidPayloadException e) {
                throw new CamelMongoDbException("Invalid payload for aggregate", e);
            }
        };
    }

    private Function<Exchange, Object> createDoCommand() {
        return exchange -> {
            try {
                MongoDatabase db = this.calculateDb((Exchange)exchange);
                BasicDBObject cmdObj = (BasicDBObject)exchange.getIn().getMandatoryBody(BasicDBObject.class);
                return db.runCommand((Bson)cmdObj);
            }
            catch (InvalidPayloadException e) {
                throw new CamelMongoDbException("Invalid payload for command", e);
            }
        };
    }

    private Function<Exchange, Object> createDoGetDbStats() {
        return exchange1 -> this.calculateDb((Exchange)exchange1).runCommand((Bson)this.createDbStatsCommand());
    }

    private Function<Exchange, Object> createDoFindById() {
        return exchange -> {
            try {
                MongoCollection<BasicDBObject> dbCol = this.calculateCollection((Exchange)exchange);
                Object id = exchange.getIn().getMandatoryBody();
                BasicDBObject o = new BasicDBObject("_id", id);
                BasicDBObject fieldFilter = (BasicDBObject)exchange.getIn().getHeader("CamelMongoDbFieldsFilter", BasicDBObject.class);
                if (fieldFilter == null) {
                    fieldFilter = new BasicDBObject();
                }
                DBObject ret = (DBObject)dbCol.find((Bson)o).projection((Bson)fieldFilter).first();
                exchange.getOut().setHeader("CamelMongoDbResultTotalSize", (Object)(ret == null ? 0 : 1));
                return ret;
            }
            catch (InvalidPayloadException e) {
                throw new CamelMongoDbException("Invalid payload for findById", e);
            }
        };
    }

    private Function<Exchange, Object> createDoSave() {
        return exchange -> {
            try {
                MongoCollection<BasicDBObject> dbCol = this.calculateCollection((Exchange)exchange);
                BasicDBObject saveObj = (BasicDBObject)exchange.getIn().getMandatoryBody(BasicDBObject.class);
                UpdateOptions options = new UpdateOptions().upsert(true);
                BasicDBObject queryObject = new BasicDBObject("_id", saveObj.get("_id"));
                UpdateResult result = dbCol.replaceOne((Bson)queryObject, (Object)saveObj, options);
                exchange.getIn().setHeader("CamelMongoOid", saveObj.get("_id"));
                return result;
            }
            catch (InvalidPayloadException e) {
                throw new CamelMongoDbException("Body incorrect type for save", e);
            }
        };
    }
}

