/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.connector;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultAsyncProducer;
import org.apache.camel.util.AsyncProcessorConverterHelper;
import org.apache.camel.util.ServiceHelper;

public class ConnectorProducer
extends DefaultAsyncProducer {
    private final AsyncProcessor producer;
    private final Processor beforeProducer;
    private final Processor afterProducer;

    public ConnectorProducer(Endpoint endpoint, Producer producer, Processor beforeProducer, Processor afterProducer) {
        super(endpoint);
        this.producer = AsyncProcessorConverterHelper.convert((Processor)producer);
        this.beforeProducer = beforeProducer;
        this.afterProducer = afterProducer;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        AsyncCallback delegate = doneSync -> {
            if (this.afterProducer != null) {
                try {
                    this.afterProducer.process(exchange);
                }
                catch (Throwable e) {
                    exchange.setException(e);
                }
            }
            callback.done(doneSync);
        };
        if (this.beforeProducer != null) {
            try {
                this.beforeProducer.process(exchange);
            }
            catch (Throwable e) {
                exchange.setException(e);
                callback.done(true);
                return true;
            }
        }
        return this.producer.process(exchange, delegate);
    }

    protected void doStart() throws Exception {
        ServiceHelper.startServices((Object[])new Object[]{this.beforeProducer, this.producer, this.afterProducer});
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopServices((Object[])new Object[]{this.beforeProducer, this.producer, this.afterProducer});
    }

    protected void doSuspend() throws Exception {
        ServiceHelper.suspendService((Object)this.producer);
    }

    protected void doResume() throws Exception {
        ServiceHelper.resumeService((Object)this.producer);
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.beforeProducer, this.producer, this.afterProducer});
    }
}

