/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openstack.neutron.producer;

import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.openstack.common.AbstractOpenstackProducer;
import org.apache.camel.component.openstack.neutron.NeutronEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.openstack4j.api.Builders;
import org.openstack4j.api.OSClient;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.network.AttachInterfaceType;
import org.openstack4j.model.network.Router;
import org.openstack4j.model.network.RouterInterface;
import org.openstack4j.model.network.builder.RouterBuilder;

public class RouterProducer
extends AbstractOpenstackProducer {
    public RouterProducer(NeutronEndpoint endpoint, OSClient client) {
        super(endpoint, client);
    }

    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = this.getOperation(exchange)) {
            case "create": {
                this.doCreate(exchange);
                break;
            }
            case "get": {
                this.doGet(exchange);
                break;
            }
            case "getAll": {
                this.doGetAll(exchange);
                break;
            }
            case "update": {
                this.doUpdate(exchange);
                break;
            }
            case "delete": {
                this.doDelete(exchange);
                break;
            }
            case "attachInterface": {
                this.doAttach(exchange);
                break;
            }
            case "detachInterface": {
                this.doDetach(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsuproutered operation " + operation);
            }
        }
    }

    private void doCreate(Exchange exchange) {
        Router in = this.messageToRouter(exchange.getIn());
        Router out = this.os.networking().router().create(in);
        exchange.getIn().setBody((Object)out);
    }

    private void doGet(Exchange exchange) {
        Message msg = exchange.getIn();
        String id = (String)msg.getHeader("ID", msg.getHeader("routerId", String.class), String.class);
        ObjectHelper.notEmpty((String)id, (String)"Router ID");
        Router result = this.os.networking().router().get(id);
        msg.setBody((Object)result);
    }

    private void doGetAll(Exchange exchange) {
        List out = this.os.networking().router().list();
        exchange.getIn().setBody((Object)out);
    }

    private void doUpdate(Exchange exchange) {
        Message msg = exchange.getIn();
        Router router = this.messageToRouter(msg);
        Router updatedRouter = this.os.networking().router().update(router);
        msg.setBody((Object)updatedRouter);
    }

    private void doDelete(Exchange exchange) {
        Message msg = exchange.getIn();
        String id = (String)msg.getHeader("ID", msg.getHeader("routerId", String.class), String.class);
        ObjectHelper.notEmpty((String)id, (String)"Router ID");
        ActionResponse response = this.os.networking().router().delete(id);
        this.checkFailure(response, msg, "Delete router with ID " + id);
    }

    private void doDetach(Exchange exchange) {
        Message msg = exchange.getIn();
        String routerId = (String)msg.getHeader("routerId", String.class);
        String subnetId = (String)msg.getHeader("subnetId", String.class);
        String portId = (String)msg.getHeader("portId", String.class);
        ObjectHelper.notEmpty((String)routerId, (String)"Router ID");
        RouterInterface iface = this.os.networking().router().detachInterface(routerId, subnetId, portId);
        msg.setBody((Object)iface);
    }

    private void doAttach(Exchange exchange) {
        Message msg = exchange.getIn();
        String routerId = (String)msg.getHeader("routerId", String.class);
        String subnetPortId = (String)msg.getHeader("subnetId", msg.getHeader("portId"), String.class);
        AttachInterfaceType type = (AttachInterfaceType)msg.getHeader("interfaceType", AttachInterfaceType.class);
        ObjectHelper.notEmpty((String)routerId, (String)"Router ID");
        ObjectHelper.notEmpty((String)subnetPortId, (String)"Subnet/Port ID");
        ObjectHelper.notNull((Object)type, (String)"AttachInterfaceType ");
        RouterInterface routerInterface = this.os.networking().router().attachInterface(routerId, type, subnetPortId);
        msg.setBody((Object)routerInterface);
    }

    private Router messageToRouter(Message message) {
        Router router = (Router)message.getBody(Router.class);
        if (router == null) {
            Map headers = message.getHeaders();
            RouterBuilder builder = Builders.router();
            ObjectHelper.notEmpty((String)((String)message.getHeader("name", String.class)), (String)"Name");
            builder.name((String)message.getHeader("name", String.class));
            if (headers.containsKey("tenantId")) {
                builder.tenantId((String)message.getHeader("tenantId", String.class));
            }
            router = (Router)builder.build();
        }
        return router;
    }
}

