/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.queue;

import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.queue.CloudQueue;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.azure.queue.QueueServiceConfiguration;
import org.apache.camel.component.azure.queue.QueueServiceEndpoint;
import org.apache.camel.impl.UriEndpointComponent;

public class QueueServiceComponent
extends UriEndpointComponent {
    public QueueServiceComponent() {
        super(QueueServiceEndpoint.class);
    }

    public QueueServiceComponent(CamelContext context) {
        super(context, QueueServiceEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        QueueServiceConfiguration configuration = new QueueServiceConfiguration();
        this.setProperties(configuration, parameters);
        String[] parts = null;
        if (remaining != null) {
            parts = remaining.split("/");
        }
        if (parts == null || parts.length < 2) {
            throw new IllegalArgumentException("The account and queue names must be specified.");
        }
        if (parts.length > 2) {
            throw new IllegalArgumentException("Only the account and queue names must be specified.");
        }
        configuration.setAccountName(parts[0]);
        configuration.setQueueName(parts[1]);
        this.checkCredentials(configuration);
        QueueServiceEndpoint endpoint = new QueueServiceEndpoint(uri, (Component)this, configuration);
        this.setProperties((Object)endpoint, parameters);
        return endpoint;
    }

    private void checkCredentials(QueueServiceConfiguration cfg) {
        StorageCredentials creds;
        CloudQueue client = cfg.getAzureQueueClient();
        StorageCredentials storageCredentials = creds = client == null ? cfg.getCredentials() : client.getServiceClient().getCredentials();
        if (creds == null) {
            throw new IllegalArgumentException("Credentials must be specified.");
        }
    }
}

