/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bonita.api.util;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import org.apache.camel.component.bonita.api.filter.BonitaAuthFilter;
import org.apache.camel.component.bonita.api.filter.JsonClientFilter;
import org.apache.camel.component.bonita.api.model.FileInput;
import org.apache.camel.component.bonita.api.model.ProcessDefinitionResponse;
import org.apache.camel.component.bonita.api.model.UploadFileResponse;
import org.apache.camel.component.bonita.api.util.BonitaAPIConfig;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;

public class BonitaAPIUtil {
    private static BonitaAPIUtil instance;
    private WebTarget webTarget;

    public static BonitaAPIUtil getInstance(BonitaAPIConfig bonitaAPIConfig) {
        if (instance == null) {
            instance = new BonitaAPIUtil();
            ClientConfig clientConfig = new ClientConfig();
            clientConfig.register(MultiPartFeature.class);
            clientConfig.register(JacksonJsonProvider.class);
            Logger logger = Logger.getLogger("org.bonitasoft.camel.bonita.api.util.BonitaAPIUtil");
            LoggingFeature feature = new LoggingFeature(logger, Level.INFO, null, null);
            clientConfig.register((Object)feature);
            ClientBuilder clientBuilder = ClientBuilder.newBuilder().withConfig((Configuration)clientConfig);
            Client client = clientBuilder.build();
            client.register((Object)new JsonClientFilter());
            client.register((Object)new BonitaAuthFilter(bonitaAPIConfig));
            instance.setWebTarget(client.target(bonitaAPIConfig.getBaseBonitaURI()));
        }
        return instance;
    }

    public UploadFileResponse uploadFile(ProcessDefinitionResponse processDefinition, FileInput file) throws Exception {
        WebTarget resource = this.webTarget.path("portal/resource/process/{processName}/{processVersion}/API/formFileUpload").resolveTemplate("processName", (Object)processDefinition.getName()).resolveTemplate("processVersion", (Object)processDefinition.getVersion());
        File tempFile = File.createTempFile("tempFile", ".tmp");
        FileOutputStream fos = new FileOutputStream(tempFile);
        fos.write(file.getContent());
        fos.close();
        FileDataBodyPart filePart = new FileDataBodyPart("file", tempFile, MediaType.APPLICATION_OCTET_STREAM_TYPE);
        MultiPart multipart = new FormDataMultiPart().bodyPart((BodyPart)filePart);
        return (UploadFileResponse)resource.request().accept(new String[]{"application/json"}).post(Entity.entity((Object)multipart, (String)"multipart/form-data"), UploadFileResponse.class);
    }

    public Map<String, Serializable> prepareInputs(ProcessDefinitionResponse processDefinition, Map<String, Serializable> inputs) throws Exception {
        for (Map.Entry<String, Serializable> entry : inputs.entrySet()) {
            if (!(entry.getValue() instanceof FileInput)) continue;
            FileInput file = (FileInput)entry.getValue();
            String tmpFile = this.uploadFile(processDefinition, file).getTempPath();
            HashMap<String, String> fileInput = new HashMap<String, String>();
            fileInput.put("filename", file.getFilename());
            fileInput.put("tempPath", tmpFile);
            entry.setValue(fileInput);
        }
        return inputs;
    }

    public WebTarget getWebTarget() {
        return this.webTarget;
    }

    public void setWebTarget(WebTarget webTarget) {
        this.webTarget = webTarget;
    }
}

