/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb3;

import com.mongodb.client.AggregateIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.mongodb3.CamelMongoDbException;
import org.apache.camel.component.mongodb3.MongoDbComponent;
import org.apache.camel.component.mongodb3.MongoDbEndpoint;
import org.apache.camel.component.mongodb3.MongoDbOperation;
import org.apache.camel.component.mongodb3.MongoDbOutputType;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbProducer.class);
    private final Map<MongoDbOperation, Processor> operations = new HashMap<MongoDbOperation, Processor>();
    private MongoDbEndpoint endpoint;

    public MongoDbProducer(MongoDbEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.bind(MongoDbOperation.aggregate, this.createDoAggregate());
        this.bind(MongoDbOperation.command, this.createDoCommand());
        this.bind(MongoDbOperation.count, this.createDoCount());
        this.bind(MongoDbOperation.findAll, this.createDoFindAll());
        this.bind(MongoDbOperation.findById, this.createDoFindById());
        this.bind(MongoDbOperation.findOneByQuery, this.createDoFindOneByQuery());
        this.bind(MongoDbOperation.getColStats, this.createDoGetColStats());
        this.bind(MongoDbOperation.getDbStats, this.createDoGetDbStats());
        this.bind(MongoDbOperation.insert, this.createDoInsert());
        this.bind(MongoDbOperation.remove, this.createDoRemove());
        this.bind(MongoDbOperation.save, this.createDoSave());
        this.bind(MongoDbOperation.update, this.createDoUpdate());
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        MongoDbOperation operation = this.endpoint.getOperation();
        Object header = exchange.getIn().getHeader("CamelMongoDbOperation");
        if (header != null) {
            LOG.debug("Overriding default operation with operation specified on header: {}", header);
            try {
                operation = header instanceof MongoDbOperation ? (MongoDbOperation)((Object)ObjectHelper.cast(MongoDbOperation.class, (Object)header)) : MongoDbOperation.valueOf((String)exchange.getIn().getHeader("CamelMongoDbOperation", String.class));
            }
            catch (Exception e) {
                throw new CamelMongoDbException("Operation specified on header is not supported. Value: " + header, e);
            }
        }
        try {
            this.invokeOperation(operation, exchange);
        }
        catch (Exception e) {
            throw MongoDbComponent.wrapInCamelMongoDbException(e);
        }
    }

    protected void invokeOperation(MongoDbOperation operation, Exchange exchange) throws Exception {
        Processor processor = this.operations.get((Object)operation);
        if (processor == null) {
            throw new CamelMongoDbException("Operation not supported. Value: " + (Object)((Object)operation));
        }
        processor.process(exchange);
    }

    private MongoDbProducer bind(MongoDbOperation operation, Function<Exchange, Object> mongoDbFunction) {
        this.operations.put(operation, this.wrap(mongoDbFunction, operation));
        return this;
    }

    private Document createDbStatsCommand() {
        return new Document("dbStats", (Object)1).append("scale", (Object)1);
    }

    private Document createCollStatsCommand(String collectionName) {
        return new Document("collStats", (Object)collectionName);
    }

    private MongoDatabase calculateDb(Exchange exchange) {
        if (!this.endpoint.isDynamicity()) {
            return this.endpoint.getMongoDatabase();
        }
        String dynamicDB = (String)exchange.getIn().getHeader("CamelMongoDbDatabase", String.class);
        MongoDatabase db = dynamicDB == null ? this.endpoint.getMongoDatabase() : this.endpoint.getMongoConnection().getDatabase(dynamicDB);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Dynamic database selected: {}", (Object)db.getName());
        }
        return db;
    }

    private String calculateCollectionName(Exchange exchange) {
        if (!this.endpoint.isDynamicity()) {
            return this.endpoint.getCollection();
        }
        String dynamicCollection = (String)exchange.getIn().getHeader("CamelMongoDbCollection", String.class);
        if (dynamicCollection == null) {
            return this.endpoint.getCollection();
        }
        return dynamicCollection;
    }

    private MongoCollection<Document> calculateCollection(Exchange exchange) {
        MongoCollection dbCol;
        if (!this.endpoint.isDynamicity()) {
            return this.endpoint.getMongoCollection().withWriteConcern(this.endpoint.getWriteConcern());
        }
        String dynamicDB = (String)exchange.getIn().getHeader("CamelMongoDbDatabase", String.class);
        String dynamicCollection = (String)exchange.getIn().getHeader("CamelMongoDbCollection", String.class);
        List dynamicIndex = (List)exchange.getIn().getHeader("CamelMongoDbCollectionIndex", List.class);
        if (dynamicDB == null && dynamicCollection == null) {
            dbCol = this.endpoint.getMongoCollection().withWriteConcern(this.endpoint.getWriteConcern());
        } else {
            MongoDatabase db = this.calculateDb(exchange);
            if (dynamicCollection == null) {
                dbCol = db.getCollection(this.endpoint.getCollection(), Document.class);
            } else {
                dbCol = db.getCollection(dynamicCollection, Document.class);
                if (dynamicIndex == null) {
                    this.endpoint.ensureIndex((MongoCollection<Document>)dbCol, this.endpoint.createIndex());
                } else {
                    this.endpoint.ensureIndex((MongoCollection<Document>)dbCol, dynamicIndex);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Dynamic database and/or collection selected: {}->{}", (Object)this.endpoint.getDatabase(), (Object)this.endpoint.getCollection());
        }
        return dbCol;
    }

    private List<Document> attemptConvertToList(List insertList, Exchange exchange) throws CamelMongoDbException {
        ArrayList<Document> documentList = new ArrayList<Document>(insertList.size());
        TypeConverter converter = exchange.getContext().getTypeConverter();
        for (Object item : insertList) {
            try {
                Document document = (Document)converter.mandatoryConvertTo(Document.class, item);
                documentList.add(document);
            }
            catch (Exception e) {
                throw new CamelMongoDbException("MongoDB operation = insert, Assuming List variant of MongoDB insert operation, but List contains non-Document items", e);
            }
        }
        return documentList;
    }

    private boolean isWriteOperation(MongoDbOperation operation) {
        return MongoDbComponent.WRITE_OPERATIONS.contains((Object)operation);
    }

    private Processor wrap(Function<Exchange, Object> supplier, MongoDbOperation operation) {
        return exchange -> {
            Object result = supplier.apply(exchange);
            this.copyHeaders(exchange);
            this.moveBodyToOutIfResultIsReturnedAsHeader(exchange, operation);
            this.processAndTransferResult(result, exchange, operation);
        };
    }

    private void copyHeaders(Exchange exchange) {
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)false);
    }

    private void moveBodyToOutIfResultIsReturnedAsHeader(Exchange exchange, MongoDbOperation operation) {
        if (this.isWriteOperation(operation) && this.endpoint.isWriteResultAsHeader()) {
            exchange.getOut().setBody(exchange.getIn().getBody());
        }
    }

    private void processAndTransferResult(Object result, Exchange exchange, MongoDbOperation operation) {
        if (this.isWriteOperation(operation) && this.endpoint.isWriteResultAsHeader()) {
            exchange.getOut().setHeader("CamelMongoWriteResult", result);
        } else {
            exchange.getOut().setBody(result);
        }
    }

    private Function<Exchange, Object> createDoGetColStats() {
        return exch -> this.calculateDb((Exchange)exch).runCommand((Bson)this.createCollStatsCommand(this.calculateCollectionName((Exchange)exch)));
    }

    private Function<Exchange, Object> createDoFindOneByQuery() {
        return exchange -> {
            try {
                MongoCollection<Document> dbCol = this.calculateCollection((Exchange)exchange);
                Bson query = (Bson)exchange.getIn().getHeader("CamelMongoDbCriteria", Bson.class);
                if (null == query) {
                    query = (Bson)exchange.getIn().getMandatoryBody(Bson.class);
                }
                Bson sortBy = (Bson)exchange.getIn().getHeader("CamelMongoDbSortBy", Bson.class);
                Bson fieldFilter = (Bson)exchange.getIn().getHeader("CamelMongoDbFieldsProjection", Bson.class);
                if (fieldFilter == null) {
                    fieldFilter = new Document();
                }
                if (sortBy == null) {
                    sortBy = new Document();
                }
                Document ret = (Document)dbCol.find(query).projection(fieldFilter).sort(sortBy).first();
                exchange.getOut().setHeader("CamelMongoDbResultTotalSize", (Object)(ret == null ? 0 : 1));
                return ret;
            }
            catch (InvalidPayloadException e) {
                throw new CamelMongoDbException("Payload is no Document", e);
            }
        };
    }

    private Function<Exchange, Object> createDoCount() {
        return exchange -> {
            Bson query = (Bson)exchange.getIn().getHeader("CamelMongoDbCriteria", Bson.class);
            if (query == null) {
                query = (Bson)exchange.getContext().getTypeConverter().tryConvertTo(Bson.class, exchange, exchange.getIn().getBody());
            }
            if (query == null) {
                query = new Document();
            }
            return this.calculateCollection((Exchange)exchange).count(query);
        };
    }

    private Function<Exchange, Object> createDoFindAll() {
        return exchange -> {
            Object result;
            MongoCollection<Document> dbCol = this.calculateCollection((Exchange)exchange);
            Bson query = (Bson)exchange.getIn().getHeader("CamelMongoDbCriteria", Bson.class);
            if (query == null && exchange.getIn().getBody() != null) {
                query = (Bson)exchange.getContext().getTypeConverter().tryConvertTo(Bson.class, exchange, exchange.getIn().getBody());
            }
            Bson fieldFilter = (Bson)exchange.getIn().getHeader("CamelMongoDbFieldsProjection", Bson.class);
            Integer batchSize = (Integer)exchange.getIn().getHeader("CamelMongoDbBatchSize", Integer.class);
            Integer numToSkip = (Integer)exchange.getIn().getHeader("CamelMongoDbNumToSkip", Integer.class);
            Integer limit = (Integer)exchange.getIn().getHeader("CamelMongoDbLimit", Integer.class);
            Document sortBy = (Document)exchange.getIn().getHeader("CamelMongoDbSortBy", Document.class);
            FindIterable ret = query == null && fieldFilter == null ? dbCol.find((Bson)new Document()) : (fieldFilter == null ? dbCol.find(query) : (query != null ? dbCol.find(query).projection(fieldFilter) : dbCol.find((Bson)new Document()).projection(fieldFilter)));
            if (sortBy != null) {
                ret.sort((Bson)sortBy);
            }
            if (batchSize != null) {
                ret.batchSize(batchSize.intValue());
            }
            if (numToSkip != null) {
                ret.skip(numToSkip.intValue());
            }
            if (limit != null) {
                ret.limit(limit.intValue());
            }
            if (!MongoDbOutputType.MongoIterable.equals((Object)this.endpoint.getOutputType())) {
                try {
                    result = new ArrayList();
                    ret.iterator().forEachRemaining(((List)result)::add);
                    exchange.getOut().setHeader("CamelMongoDbResultPageSize", (Object)((List)result).size());
                }
                finally {
                    ret.iterator().close();
                }
            } else {
                result = ret;
            }
            return result;
        };
    }

    private Function<Exchange, Object> createDoInsert() {
        return exchange -> {
            MongoCollection<Document> dbCol = this.calculateCollection((Exchange)exchange);
            boolean singleInsert = true;
            Object insert = exchange.getContext().getTypeConverter().tryConvertTo(Document.class, exchange, exchange.getIn().getBody());
            if (insert == null) {
                insert = exchange.getIn().getBody(List.class);
                if (insert != null) {
                    singleInsert = false;
                    insert = this.attemptConvertToList((List)insert, (Exchange)exchange);
                } else {
                    throw new CamelMongoDbException("MongoDB operation = insert, Body is not conversible to type Document nor List<Document>");
                }
            }
            if (singleInsert) {
                Document insertObject2 = (Document)Document.class.cast(insert);
                dbCol.insertOne((Object)insertObject2);
                exchange.getIn().setHeader("CamelMongoOid", insertObject2.get((Object)"_id"));
            } else {
                List insertObjects = (List)insert;
                dbCol.insertMany(insertObjects);
                ArrayList objectIdentification = new ArrayList(insertObjects.size());
                objectIdentification.addAll(insertObjects.stream().map(insertObject -> insertObject.get((Object)"_id")).collect(Collectors.toList()));
                exchange.getIn().setHeader("CamelMongoOid", objectIdentification);
            }
            return insert;
        };
    }

    private Function<Exchange, Object> createDoUpdate() {
        return exchange -> {
            try {
                UpdateResult result;
                Bson objNew;
                MongoCollection<Document> dbCol = this.calculateCollection((Exchange)exchange);
                Bson updateCriteria = (Bson)exchange.getIn().getHeader("CamelMongoDbCriteria", Bson.class);
                if (null == updateCriteria) {
                    List saveObj = (List)exchange.getIn().getMandatoryBody((Class)Class.class.cast(List.class));
                    if (saveObj.size() != 2) {
                        throw new CamelMongoDbException("MongoDB operation = insert, failed because body is not a List of Document objects with size = 2");
                    }
                    updateCriteria = (Bson)saveObj.get(0);
                    objNew = (Bson)saveObj.get(1);
                } else {
                    objNew = (Bson)exchange.getIn().getMandatoryBody(Bson.class);
                }
                Boolean multi = (Boolean)exchange.getIn().getHeader("CamelMongoDbMultiUpdate", Boolean.class);
                Boolean upsert = (Boolean)exchange.getIn().getHeader("CamelMongoDbUpsert", Boolean.class);
                UpdateOptions options = new UpdateOptions();
                if (upsert != null) {
                    options.upsert(upsert.booleanValue());
                }
                if ((result = multi == null || multi == false ? dbCol.updateOne(updateCriteria, objNew, options) : dbCol.updateMany(updateCriteria, objNew, options)).isModifiedCountAvailable()) {
                    exchange.getOut().setHeader("CamelMongoDbRecordsAffected", (Object)result.getModifiedCount());
                }
                exchange.getOut().setHeader("CamelMongoDbRecordsMatched", (Object)result.getMatchedCount());
                return result;
            }
            catch (InvalidPayloadException e) {
                throw new CamelMongoDbException("Invalid payload for update", e);
            }
        };
    }

    private Function<Exchange, Object> createDoRemove() {
        return exchange -> {
            try {
                MongoCollection<Document> dbCol = this.calculateCollection((Exchange)exchange);
                Document removeObj = (Document)exchange.getIn().getMandatoryBody(Document.class);
                DeleteResult result = dbCol.deleteMany((Bson)removeObj);
                if (result.wasAcknowledged()) {
                    exchange.getOut().setHeader("CamelMongoDbRecordsAffected", (Object)result.getDeletedCount());
                }
                return result;
            }
            catch (InvalidPayloadException e) {
                throw new CamelMongoDbException("Invalid payload for remove", e);
            }
        };
    }

    private Function<Exchange, Object> createDoAggregate() {
        return exchange -> {
            try {
                AggregateIterable aggregationResult;
                MongoCollection<Document> dbCol = this.calculateCollection((Exchange)exchange);
                ArrayList dbIterator = new ArrayList();
                List query = (List)exchange.getIn().getMandatoryBody((Class)Class.class.cast(List.class));
                if (query != null) {
                    List queryList = query.stream().map(o -> o).collect(Collectors.toList());
                    aggregationResult = dbCol.aggregate(queryList);
                } else {
                    ArrayList queryList = new ArrayList();
                    queryList.add(Bson.class.cast(exchange.getIn().getMandatoryBody(Bson.class)));
                    aggregationResult = dbCol.aggregate(queryList);
                }
                aggregationResult.iterator().forEachRemaining(dbIterator::add);
                return dbIterator;
            }
            catch (InvalidPayloadException e) {
                throw new CamelMongoDbException("Invalid payload for aggregate", e);
            }
        };
    }

    private Function<Exchange, Object> createDoCommand() {
        return exchange -> {
            try {
                MongoDatabase db = this.calculateDb((Exchange)exchange);
                Document cmdObj = (Document)exchange.getIn().getMandatoryBody(Document.class);
                return db.runCommand((Bson)cmdObj);
            }
            catch (InvalidPayloadException e) {
                throw new CamelMongoDbException("Invalid payload for command", e);
            }
        };
    }

    private Function<Exchange, Object> createDoGetDbStats() {
        return exchange1 -> this.calculateDb((Exchange)exchange1).runCommand((Bson)this.createDbStatsCommand());
    }

    private Function<Exchange, Object> createDoFindById() {
        return exchange -> {
            try {
                MongoCollection<Document> dbCol = this.calculateCollection((Exchange)exchange);
                Object id = exchange.getIn().getMandatoryBody();
                Bson o = Filters.eq((String)"_id", (Object)id);
                Bson fieldFilter = (Bson)exchange.getIn().getHeader("CamelMongoDbFieldsProjection", Bson.class);
                if (fieldFilter == null) {
                    fieldFilter = new Document();
                }
                Document ret = (Document)dbCol.find(o).projection(fieldFilter).first();
                exchange.getOut().setHeader("CamelMongoDbResultTotalSize", (Object)(ret == null ? 0 : 1));
                return ret;
            }
            catch (InvalidPayloadException e) {
                throw new CamelMongoDbException("Invalid payload for findById", e);
            }
        };
    }

    private Function<Exchange, Object> createDoSave() {
        return exchange -> {
            try {
                UpdateResult result;
                MongoCollection<Document> dbCol = this.calculateCollection((Exchange)exchange);
                Document saveObj = (Document)exchange.getIn().getMandatoryBody(Document.class);
                UpdateOptions options = new UpdateOptions().upsert(true);
                if (null == saveObj.get((Object)"_id")) {
                    result = dbCol.replaceOne(Filters.where((String)"false"), (Object)saveObj, options);
                    exchange.getIn().setHeader("CamelMongoOid", (Object)result.getUpsertedId().asObjectId().getValue());
                } else {
                    result = dbCol.replaceOne(Filters.eq((String)"_id", (Object)saveObj.get((Object)"_id")), (Object)saveObj, options);
                    exchange.getIn().setHeader("CamelMongoOid", saveObj.get((Object)"_id"));
                }
                return result;
            }
            catch (InvalidPayloadException e) {
                throw new CamelMongoDbException("Body incorrect type for save", e);
            }
        };
    }
}

