/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.barcode.springboot;

import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConverter;
import org.apache.camel.dataformat.barcode.BarcodeDataFormat;
import org.apache.camel.dataformat.barcode.springboot.BarcodeDataFormatConfiguration;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatFactory;
import org.apache.camel.util.IntrospectionSupport;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration
@ConditionalOnBean(type={"org.apache.camel.spring.boot.CamelAutoConfiguration"})
@Conditional(value={Condition.class})
@AutoConfigureAfter(name={"org.apache.camel.spring.boot.CamelAutoConfiguration"})
@EnableConfigurationProperties(value={BarcodeDataFormatConfiguration.class})
public class BarcodeDataFormatAutoConfiguration {
    @Bean(name={"barcode-dataformat-factory"})
    @ConditionalOnClass(value={CamelContext.class})
    @ConditionalOnMissingBean(value={BarcodeDataFormat.class})
    public DataFormatFactory configureBarcodeDataFormatFactory(final CamelContext camelContext, final BarcodeDataFormatConfiguration configuration) {
        return new DataFormatFactory(){

            public DataFormat newInstance() {
                CamelContextAware contextAware;
                BarcodeDataFormat dataformat = new BarcodeDataFormat();
                if (CamelContextAware.class.isAssignableFrom(BarcodeDataFormat.class) && (contextAware = (CamelContextAware)CamelContextAware.class.cast(dataformat)) != null) {
                    contextAware.setCamelContext(camelContext);
                }
                try {
                    HashMap parameters = new HashMap();
                    IntrospectionSupport.getProperties((Object)configuration, parameters, null, (boolean)false);
                    IntrospectionSupport.setProperties((CamelContext)camelContext, (TypeConverter)camelContext.getTypeConverter(), (Object)dataformat, parameters);
                }
                catch (Exception e) {
                    throw new RuntimeCamelException((Throwable)e);
                }
                return dataformat;
            }
        };
    }

    public static class Condition
    extends SpringBootCondition {
        public ConditionOutcome getMatchOutcome(ConditionContext conditionContext, AnnotatedTypeMetadata annotatedTypeMetadata) {
            boolean groupEnabled = this.isEnabled(conditionContext, "camel.dataformat.", true);
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"camel.dataformat.barcode", (Object[])new Object[0]);
            if (this.isEnabled(conditionContext, "camel.dataformat.barcode.", groupEnabled)) {
                return ConditionOutcome.match((ConditionMessage)message.because("enabled"));
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.because("not enabled"));
        }

        private boolean isEnabled(ConditionContext context, String prefix, boolean defaultValue) {
            RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)context.getEnvironment(), prefix);
            return (Boolean)resolver.getProperty("enabled", Boolean.class, (Object)defaultValue);
        }
    }
}

