/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atmos.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.camel.component.atmos.util.AtmosException;

public final class AtmosPropertyManager {
    private static Properties properties;
    private static AtmosPropertyManager instance;

    private AtmosPropertyManager() {
    }

    public static synchronized AtmosPropertyManager getInstance() throws Exception {
        if (instance == null) {
            instance = new AtmosPropertyManager();
            properties = AtmosPropertyManager.loadProperties();
        }
        return instance;
    }

    public String getProperty(String key) {
        return properties.getProperty(key);
    }

    private static Properties loadProperties() throws Exception {
        InputStream inStream;
        URL url = AtmosPropertyManager.class.getResource("/atmos.properties");
        try {
            inStream = url.openStream();
        }
        catch (IOException e) {
            throw new AtmosException("atmos.properties could not be found");
        }
        properties = new Properties();
        try {
            properties.load(inStream);
        }
        catch (IOException e) {
            throw new AtmosException("atmos.properties can't be read");
        }
        return properties;
    }
}

