/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.reactive.streams.util;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConversionException;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertingPublisher<R>
implements Publisher<R> {
    private static final Logger LOG = LoggerFactory.getLogger(ConvertingPublisher.class);
    private Publisher<Exchange> delegate;
    private Class<R> type;

    public ConvertingPublisher(Publisher<Exchange> delegate, Class<R> type) {
        Objects.requireNonNull(delegate, "delegate publisher cannot be null");
        this.delegate = delegate;
        this.type = type;
    }

    public void subscribe(final Subscriber<? super R> subscriber) {
        this.delegate.subscribe((Subscriber)new Subscriber<Exchange>(){
            private AtomicBoolean active = new AtomicBoolean(true);
            private Subscription subscription;

            public void onSubscribe(Subscription newSubscription) {
                if (newSubscription == null) {
                    throw new NullPointerException("subscription is null");
                }
                if (newSubscription == this.subscription) {
                    throw new IllegalArgumentException("already subscribed to the subscription: " + newSubscription);
                }
                if (this.subscription != null) {
                    newSubscription.cancel();
                } else {
                    this.subscription = newSubscription;
                    subscriber.onSubscribe(newSubscription);
                }
            }

            public void onNext(Exchange ex) {
                Object r;
                if (!this.active.get()) {
                    return;
                }
                try {
                    r = ex.hasOut() ? ex.getOut().getBody(ConvertingPublisher.this.type) : ex.getIn().getBody(ConvertingPublisher.this.type);
                }
                catch (TypeConversionException e) {
                    LOG.warn("Unable to convert body to the specified type: " + ConvertingPublisher.this.type.getName(), (Throwable)e);
                    r = null;
                }
                if (r == null && ex.getIn().getBody() != null) {
                    this.onError(new ClassCastException("Unable to convert body to the specified type: " + ConvertingPublisher.this.type.getName()));
                    this.active.set(false);
                    this.subscription.cancel();
                } else {
                    subscriber.onNext(r);
                }
            }

            public void onError(Throwable throwable) {
                if (!this.active.get()) {
                    return;
                }
                subscriber.onError(throwable);
            }

            public void onComplete() {
                if (!this.active.get()) {
                    return;
                }
                subscriber.onComplete();
            }
        });
    }
}

