/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.reactive.streams.api;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.component.reactive.streams.api.CamelReactiveStreamsService;
import org.apache.camel.component.reactive.streams.util.ReactiveStreamsServiceCreationHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CamelReactiveStreams {
    private static final Logger LOG = LoggerFactory.getLogger(CamelReactiveStreams.class);
    private static Map<CamelContext, String> serviceNames = new ConcurrentHashMap<CamelContext, String>();

    private CamelReactiveStreams() {
    }

    public static CamelReactiveStreamsService get(CamelContext context) {
        return CamelReactiveStreams.get(context, null);
    }

    public static CamelReactiveStreamsService get(CamelContext context, String serviceName) {
        if (serviceName != null && serviceName.trim().length() == 0) {
            throw new IllegalArgumentException("the service name cannot be an empty String");
        }
        String lookupName = serviceName != null ? serviceName : "";
        serviceNames.computeIfAbsent(context, ctx -> {
            CamelReactiveStreamsService service = (CamelReactiveStreamsService)context.hasService(CamelReactiveStreamsService.class);
            if (service == null) {
                service = CamelReactiveStreams.resolveReactiveStreamsService(context, serviceName);
                try {
                    context.addService((Object)service, true, true);
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Cannot add the CamelReactiveStreamsService to the Camel context", ex);
                }
            }
            return lookupName;
        });
        if (!ObjectHelper.equal((Object)serviceNames.get(context), (Object)lookupName)) {
            throw new IllegalArgumentException("Cannot use two different implementations of CamelReactiveStreamsService in the same CamelContext: existing service name [" + serviceNames.get(context) + "] - requested [" + lookupName + "]");
        }
        return (CamelReactiveStreamsService)context.hasService(CamelReactiveStreamsService.class);
    }

    private static CamelReactiveStreamsService resolveReactiveStreamsService(CamelContext context, String serviceName) {
        CamelReactiveStreamsService service = null;
        if (serviceName != null) {
            service = (CamelReactiveStreamsService)context.getRegistry().lookupByNameAndType(serviceName, CamelReactiveStreamsService.class);
            if (service == null) {
                service = ReactiveStreamsServiceCreationHelper.createNewReactiveStreamsService(context, serviceName);
            }
        } else {
            Set set = context.getRegistry().findByType(CamelReactiveStreamsService.class);
            if (set.size() == 1) {
                service = (CamelReactiveStreamsService)set.iterator().next();
            }
            if (service == null) {
                LOG.info("Using default reactive stream service");
                service = ReactiveStreamsServiceCreationHelper.createNewReactiveStreamsService(context, null);
            }
        }
        return service;
    }
}

