/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.reactive.streams;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.reactive.streams.ReactiveStreamsEndpoint;
import org.apache.camel.component.reactive.streams.api.CamelReactiveStreams;
import org.apache.camel.component.reactive.streams.api.CamelReactiveStreamsService;
import org.apache.camel.impl.DefaultAsyncProducer;

public class ReactiveStreamsProducer
extends DefaultAsyncProducer {
    private ReactiveStreamsEndpoint endpoint;
    private String name;
    private CamelReactiveStreamsService service;

    public ReactiveStreamsProducer(ReactiveStreamsEndpoint endpoint, String name) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.name = name;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        this.service.sendCamelExchange(this.name, exchange, (data, error) -> {
            if (error != null) {
                data.setException(error);
            }
            callback.done(false);
        });
        return false;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.service = CamelReactiveStreams.get(this.endpoint.getCamelContext(), this.endpoint.getServiceName());
        this.service.attachCamelProducer(this.endpoint.getStream(), this);
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.service.detachCamelProducer(this.endpoint.getStream());
    }

    public ReactiveStreamsEndpoint getEndpoint() {
        return this.endpoint;
    }
}

