/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.ganglia.springboot;

import javax.annotation.Generated;
import info.ganglia.gmetric4j.gmetric.GMetric.UDPAddressingMode;
import info.ganglia.gmetric4j.gmetric.GMetricSlope;
import info.ganglia.gmetric4j.gmetric.GMetricType;
import org.apache.camel.component.ganglia.GangliaComponent;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * The ganglia component is used for sending metrics to the Ganglia monitoring
 * system.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.SpringBootAutoConfigurationMojo")
@ConfigurationProperties(prefix = "camel.component.ganglia")
public class GangliaComponentConfiguration {

    /**
     * To use the shared configuration
     */
    private GangliaConfigurationNestedConfiguration configuration;
    /**
     * Whether the component should resolve property placeholders on itself when
     * starting. Only properties which are of String type can use property
     * placeholders.
     */
    private Boolean resolvePropertyPlaceholders = true;

    public GangliaConfigurationNestedConfiguration getConfiguration() {
        return configuration;
    }

    public void setConfiguration(
            GangliaConfigurationNestedConfiguration configuration) {
        this.configuration = configuration;
    }

    public Boolean getResolvePropertyPlaceholders() {
        return resolvePropertyPlaceholders;
    }

    public void setResolvePropertyPlaceholders(
            Boolean resolvePropertyPlaceholders) {
        this.resolvePropertyPlaceholders = resolvePropertyPlaceholders;
    }

    public static class GangliaConfigurationNestedConfiguration {
        public static final Class CAMEL_NESTED_CLASS = org.apache.camel.component.ganglia.GangliaConfiguration.class;
        /**
         * Host name for Ganglia server
         */
        private String host = "239.2.11.71";
        /**
         * Port for Ganglia server
         */
        private Integer port = 8649;
        /**
         * Send the UDP metric packets using MULTICAST or UNICAST
         */
        private UDPAddressingMode mode = UDPAddressingMode.MULTICAST;
        /**
         * If using multicast, set the TTL of the packets
         */
        private Integer ttl = 5;
        /**
         * Use the wire format of Ganglia 3.1.0 and later versions. Set this to
         * false to use Ganglia 3.0.x or earlier.
         */
        private Boolean wireFormat31x = true;
        /**
         * Spoofing information IP:hostname
         */
        private String spoofHostname;
        /**
         * The group that the metric belongs to.
         */
        private String groupName = "java";
        /**
         * Prefix the metric name with this string and an underscore.
         */
        private String prefix;
        /**
         * The name to use for the metric.
         */
        private String metricName = "metric";
        /**
         * The type of value
         */
        private GMetricType type = GMetricType.STRING;
        /**
         * The slope
         */
        private GMetricSlope slope = GMetricSlope.BOTH;
        /**
         * Any unit of measurement that qualifies the metric, e.g. widgets,
         * litres, bytes. Do not include a prefix such as k (kilo) or m (milli),
         * other tools may scale the units later. The value should be unscaled.
         */
        private String units;
        /**
         * Maximum time in seconds that the value can be considered current.
         * After this, Ganglia considers the value to have expired.
         */
        private Integer tmax = 60;
        /**
         * Minumum time in seconds before Ganglia will purge the metric value if
         * it expires. Set to 0 and the value will remain in Ganglia
         * indefinitely until a gmond agent restart.
         */
        private Integer dmax = 0;

        public String getHost() {
            return host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public Integer getPort() {
            return port;
        }

        public void setPort(Integer port) {
            this.port = port;
        }

        public UDPAddressingMode getMode() {
            return mode;
        }

        public void setMode(UDPAddressingMode mode) {
            this.mode = mode;
        }

        public Integer getTtl() {
            return ttl;
        }

        public void setTtl(Integer ttl) {
            this.ttl = ttl;
        }

        public Boolean getWireFormat31x() {
            return wireFormat31x;
        }

        public void setWireFormat31x(Boolean wireFormat31x) {
            this.wireFormat31x = wireFormat31x;
        }

        public String getSpoofHostname() {
            return spoofHostname;
        }

        public void setSpoofHostname(String spoofHostname) {
            this.spoofHostname = spoofHostname;
        }

        public String getGroupName() {
            return groupName;
        }

        public void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public String getPrefix() {
            return prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getMetricName() {
            return metricName;
        }

        public void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public GMetricType getType() {
            return type;
        }

        public void setType(GMetricType type) {
            this.type = type;
        }

        public GMetricSlope getSlope() {
            return slope;
        }

        public void setSlope(GMetricSlope slope) {
            this.slope = slope;
        }

        public String getUnits() {
            return units;
        }

        public void setUnits(String units) {
            this.units = units;
        }

        public Integer getTmax() {
            return tmax;
        }

        public void setTmax(Integer tmax) {
            this.tmax = tmax;
        }

        public Integer getDmax() {
            return dmax;
        }

        public void setDmax(Integer dmax) {
            this.dmax = dmax;
        }
    }
}