/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.foo.salesforce.contact.springboot;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * The salesforce connector is used for integrating Camel with the massive
 * Salesforce API.
 * 
 * Generated by camel-connector-maven-plugin - do not edit this file!
 */
@ConfigurationProperties(prefix = "camel.connector.salesforce-upsert-contact")
public class SalesforceUpsertContactConnectorConfiguration {

    /**
     * URL of the Salesforce instance by default set to
     * https://login.salesforce.com
     */
    private String loginUrl = "https://login.salesforce.com";
    /**
     * OAuth Consumer Key of the connected app configured in the Salesforce
     * instance setup. Typically a connected app needs to be configured but one
     * can be provided by installing a package.
     */
    private String clientId;
    /**
     * OAuth Consumer Secret of the connected app configured in the Salesforce
     * instance setup.
     */
    private String clientSecret;
    /**
     * Refresh token already obtained in the refresh token OAuth flow. One needs
     * to setup a web application and configure a callback URL to receive the
     * refresh token or configure using the builtin callback at
     * https://login.salesforce.com/services/oauth2/success or
     * https://test.salesforce.com/services/oauth2/success and then retrive the
     * refresh_token from the URL at the end of the flow. Note that in
     * development organizations Salesforce allows hosting the callback web
     * application at localhost.
     */
    private String refreshToken;

    public String getLoginUrl() {
        return loginUrl;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getRefreshToken() {
        return refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }
}