/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.camel.component.hazelcast;

import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultProducer;

public abstract class HazelcastDefaultProducer extends DefaultProducer {
    public HazelcastDefaultProducer(HazelcastDefaultEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public HazelcastDefaultEndpoint getEndpoint() {
        return (HazelcastDefaultEndpoint)super.getEndpoint();
    }

    protected int lookupOperationNumber(Exchange exchange) {
        int defaultNumber = -1;
        // if there is a default operation we need to convert that first to a number
        if (getEndpoint().getDefaultOperation() != null) {
            defaultNumber = HazelcastComponentHelper.extractOperationNumber(getEndpoint().getDefaultOperation(), -1);
        }
        return HazelcastComponentHelper.lookupOperationNumber(exchange, defaultNumber);
    }
}
