/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ehcache;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.ehcache.EhcacheConfiguration;
import org.apache.camel.component.ehcache.EhcacheEndpoint;
import org.apache.camel.component.ehcache.EhcacheManager;
import org.apache.camel.impl.DefaultConsumer;
import org.ehcache.Cache;
import org.ehcache.event.CacheEvent;
import org.ehcache.event.CacheEventListener;

public class EhcacheConsumer
extends DefaultConsumer
implements CacheEventListener<Object, Object> {
    private final EhcacheConfiguration configuration;
    private final EhcacheManager manager;
    private final Cache cache;

    public EhcacheConsumer(EhcacheEndpoint endpoint, EhcacheConfiguration configuration, Processor processor) throws Exception {
        super((Endpoint)endpoint, processor);
        this.configuration = configuration;
        this.manager = endpoint.getManager();
        this.cache = this.manager.getCache();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.cache.getRuntimeConfiguration().registerCacheEventListener((CacheEventListener)this, this.configuration.getEventOrdering(), this.configuration.getEventFiring(), this.configuration.getEventTypes());
    }

    protected void doStop() throws Exception {
        this.cache.getRuntimeConfiguration().deregisterCacheEventListener((CacheEventListener)this);
        super.doStop();
    }

    public void onEvent(CacheEvent<Object, Object> event) {
        Exchange exchange = this.getEndpoint().createExchange();
        Message message = exchange.getIn();
        message.setHeader("CamelEhcacheKey", event.getKey());
        message.setHeader("CamelEhcacheEventType", (Object)event.getType());
        message.setHeader("CamelEhcacheOldValue", event.getOldValue());
        message.setBody(event.getNewValue());
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)e);
        }
    }
}

