/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.gridfs;

import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.gridfs.GridFS;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.gridfs.GridFsComponent;
import org.apache.camel.component.gridfs.GridFsConsumer;
import org.apache.camel.component.gridfs.GridFsProducer;
import org.apache.camel.component.gridfs.QueryStrategy;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.CamelContextHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="gridfs", title="MongoDBGridFS", syntax="gridfs:connectionBean", label="database,nosql")
public class GridFsEndpoint
extends DefaultEndpoint {
    public static final String GRIDFS_OPERATION = "gridfs.operation";
    public static final String GRIDFS_METADATA = "gridfs.metadata";
    public static final String GRIDFS_CHUNKSIZE = "gridfs.chunksize";
    public static final String GRIDFS_FILE_ID_PRODUCED = "gridfs.fileid";
    private static final Logger LOG = LoggerFactory.getLogger(GridFsEndpoint.class);
    @UriPath
    @Metadata(required="true")
    private String connectionBean;
    @UriParam
    @Metadata(required="true")
    private String database;
    @UriParam(defaultValue="fs")
    private String bucket;
    @UriParam(enums="ACKNOWLEDGED,W1,W2,W3,UNACKNOWLEDGED,JOURNALED,MAJORITY,SAFE")
    private WriteConcern writeConcern;
    @UriParam
    private WriteConcern writeConcernRef;
    @UriParam
    private ReadPreference readPreference;
    @UriParam(label="producer")
    private String operation;
    @UriParam(label="consumer")
    private String query;
    @UriParam(label="consumer", defaultValue="1000")
    private long initialDelay = 1000L;
    @UriParam(label="consumer", defaultValue="500")
    private long delay = 500L;
    @UriParam(label="consumer", defaultValue="TimeStamp")
    private QueryStrategy queryStrategy = QueryStrategy.TimeStamp;
    @UriParam(label="consumer", defaultValue="camel-timestamps")
    private String persistentTSCollection = "camel-timestamps";
    @UriParam(label="consumer", defaultValue="camel-timestamp")
    private String persistentTSObject = "camel-timestamp";
    @UriParam(label="consumer", defaultValue="camel-processed")
    private String fileAttributeName = "camel-processed";
    private Mongo mongoConnection;
    private DB db;
    private GridFS gridFs;
    private DBCollection filesCollection;

    public GridFsEndpoint(String uri, GridFsComponent component) {
        super(uri, (Component)component);
    }

    public Producer createProducer() throws Exception {
        this.initializeConnection();
        return new GridFsProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        this.initializeConnection();
        return new GridFsConsumer(this, processor);
    }

    public boolean isSingleton() {
        return true;
    }

    public void initializeConnection() throws Exception {
        LOG.info("Initialize GridFS endpoint: {}", (Object)this.toString());
        if (this.database == null) {
            throw new IllegalStateException("Missing required endpoint configuration: database");
        }
        this.db = this.mongoConnection.getDB(this.database);
        if (this.db == null) {
            throw new IllegalStateException("Could not initialize GridFsComponent. Database " + this.database + " does not exist.");
        }
        this.gridFs = new GridFS(this.db, this.bucket == null ? "fs" : this.bucket){
            {
                GridFsEndpoint.this.filesCollection = this.getFilesCollection();
            }
        };
    }

    protected void doStart() throws Exception {
        if (this.writeConcern != null && this.writeConcernRef != null) {
            String msg = "Cannot set both writeConcern and writeConcernRef at the same time. Respective values: " + this.writeConcern + ", " + this.writeConcernRef + ". Aborting initialization.";
            throw new IllegalArgumentException(msg);
        }
        this.mongoConnection = (Mongo)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)this.connectionBean, MongoClient.class);
        LOG.debug("Resolved the connection with the name {} as {}", (Object)this.connectionBean, (Object)this.mongoConnection);
        this.setWriteReadOptionsOnConnection();
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.mongoConnection != null) {
            LOG.debug("Closing connection");
            this.mongoConnection.close();
        }
    }

    private void setWriteReadOptionsOnConnection() {
        if (this.writeConcern != null) {
            this.mongoConnection.setWriteConcern(this.writeConcern);
        } else if (this.writeConcernRef != null) {
            this.mongoConnection.setWriteConcern(this.writeConcernRef);
        }
        if (this.readPreference != null) {
            this.mongoConnection.setReadPreference(this.readPreference);
        }
    }

    public String getConnectionBean() {
        return this.connectionBean;
    }

    public void setConnectionBean(String connectionBean) {
        this.connectionBean = connectionBean;
    }

    public Mongo getMongoConnection() {
        return this.mongoConnection;
    }

    public void setMongoConnection(Mongo mongoConnection) {
        this.mongoConnection = mongoConnection;
    }

    public DB getDB() {
        return this.db;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(long initialDelay) {
        this.initialDelay = this.delay;
    }

    public void setQueryStrategy(String s) {
        this.queryStrategy = QueryStrategy.valueOf(s);
    }

    public QueryStrategy getQueryStrategy() {
        return this.queryStrategy;
    }

    public void setPersistentTSCollection(String s) {
        this.persistentTSCollection = s;
    }

    public String getPersistentTSCollection() {
        return this.persistentTSCollection;
    }

    public void setPersistentTSObject(String id) {
        this.persistentTSObject = id;
    }

    public String getPersistentTSObject() {
        return this.persistentTSObject;
    }

    public void setFileAttributeName(String f) {
        this.fileAttributeName = f;
    }

    public String getFileAttributeName() {
        return this.fileAttributeName;
    }

    public void setWriteConcern(String writeConcern) {
        this.writeConcern = WriteConcern.valueOf((String)writeConcern);
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public void setWriteConcernRef(String writeConcernRef) {
        WriteConcern wc = (WriteConcern)this.getCamelContext().getRegistry().lookupByNameAndType(writeConcernRef, WriteConcern.class);
        if (wc == null) {
            String msg = "Camel MongoDB component could not find the WriteConcern in the Registry. Verify that the provided bean name (" + writeConcernRef + ")  is correct. Aborting initialization.";
            throw new IllegalArgumentException(msg);
        }
        this.writeConcernRef = wc;
    }

    public WriteConcern getWriteConcernRef() {
        return this.writeConcernRef;
    }

    public void setReadPreference(String readPreference) {
        this.readPreference = ReadPreference.valueOf((String)readPreference);
    }

    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getOperation() {
        return this.operation;
    }

    public GridFS getGridFs() {
        return this.gridFs;
    }

    public void setGridFs(GridFS gridFs) {
        this.gridFs = gridFs;
    }

    public DBCollection getFilesCollection() {
        return this.filesCollection;
    }
}

