/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.gridfs;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.util.JSON;
import java.io.InputStream;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.gridfs.GridFsEndpoint;
import org.apache.camel.component.gridfs.QueryStrategy;
import org.apache.camel.impl.DefaultConsumer;

public class GridFsConsumer
extends DefaultConsumer
implements Runnable {
    final GridFsEndpoint endpoint;
    private ExecutorService executor;

    public GridFsConsumer(GridFsEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.endpoint.getCamelContext().getExecutorServiceManager().newFixedThreadPool((Object)this, this.endpoint.getEndpointUri(), 1);
        this.executor.execute(this);
    }

    @Override
    public void run() {
        DBCursor c = null;
        Date fromDate = null;
        QueryStrategy s = this.endpoint.getQueryStrategy();
        boolean usesTimestamp = s != QueryStrategy.FileAttribute;
        boolean persistsTimestamp = s == QueryStrategy.PersistentTimestamp || s == QueryStrategy.PersistentTimestampAndFileAttribute;
        boolean usesAttribute = s == QueryStrategy.FileAttribute || s == QueryStrategy.TimeStampAndFileAttribute || s == QueryStrategy.PersistentTimestampAndFileAttribute;
        DBCollection ptsCollection = null;
        DBObject persistentTimestamp = null;
        if (persistsTimestamp) {
            ptsCollection = this.endpoint.getDB().getCollection(this.endpoint.getPersistentTSCollection());
            try {
                if (ptsCollection.count() < 1000L) {
                    ptsCollection.createIndex((DBObject)new BasicDBObject("id", (Object)1));
                }
            }
            catch (MongoException mongoException) {
                // empty catch block
            }
            persistentTimestamp = ptsCollection.findOne((DBObject)new BasicDBObject("id", (Object)this.endpoint.getPersistentTSObject()));
            if (persistentTimestamp == null) {
                persistentTimestamp = new BasicDBObject("id", (Object)this.endpoint.getPersistentTSObject());
                fromDate = new Date();
                persistentTimestamp.put("timestamp", (Object)fromDate);
                ptsCollection.save(persistentTimestamp);
            }
            fromDate = (Date)persistentTimestamp.get("timestamp");
        } else if (usesTimestamp) {
            fromDate = new Date();
        }
        try {
            Thread.sleep(this.endpoint.getInitialDelay());
            while (this.isStarted()) {
                if (c == null || c.getCursorId() == 0L) {
                    String queryString;
                    if (c != null) {
                        c.close();
                    }
                    Object query = (queryString = this.endpoint.getQuery()) == null ? new BasicDBObject() : (DBObject)JSON.parse((String)queryString);
                    if (usesTimestamp) {
                        query.put("uploadDate", (Object)new BasicDBObject("$gt", (Object)fromDate));
                    }
                    if (usesAttribute) {
                        query.put(this.endpoint.getFileAttributeName(), null);
                    }
                    c = this.endpoint.getFilesCollection().find((DBObject)query);
                }
                boolean dateModified = false;
                while (c.hasNext() && this.isStarted()) {
                    GridFSDBFile file;
                    GridFSDBFile forig = file = (GridFSDBFile)c.next();
                    if (usesAttribute) {
                        file.put(this.endpoint.getFileAttributeName(), (Object)"processing");
                        DBObject q = BasicDBObjectBuilder.start((String)"_id", (Object)file.getId()).append("camel-processed", null).get();
                        forig = (GridFSDBFile)this.endpoint.getFilesCollection().findAndModify(q, null, null, false, (DBObject)file, true, false);
                    }
                    if (forig == null) continue;
                    file = this.endpoint.getGridFs().findOne((DBObject)new BasicDBObject("_id", file.getId()));
                    Exchange exchange = this.endpoint.createExchange();
                    exchange.getIn().setHeader("gridfs.metadata", (Object)JSON.serialize((Object)file.getMetaData()));
                    exchange.getIn().setHeader("CamelFileContentType", (Object)file.getContentType());
                    exchange.getIn().setHeader("CamelFileLength", (Object)file.getLength());
                    exchange.getIn().setHeader("CamelFileLastModified", (Object)file.getUploadDate());
                    exchange.getIn().setBody((Object)file.getInputStream(), InputStream.class);
                    try {
                        this.getProcessor().process(exchange);
                        if (usesAttribute) {
                            forig.put(this.endpoint.getFileAttributeName(), (Object)"done");
                            this.endpoint.getFilesCollection().save((DBObject)forig);
                        }
                        if (!usesTimestamp || file.getUploadDate().compareTo(fromDate) <= 0) continue;
                        fromDate = file.getUploadDate();
                        dateModified = true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (persistsTimestamp && dateModified) {
                    persistentTimestamp.put("timestamp", (Object)fromDate);
                    ptsCollection.save(persistentTimestamp);
                }
                Thread.sleep(this.endpoint.getDelay());
            }
        }
        catch (Throwable e1) {
            e1.printStackTrace();
        }
        if (c != null) {
            c.close();
        }
    }
}

