/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cometd;

import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.camel.Endpoint;
import org.apache.camel.component.cometd.CometdEndpoint;
import org.apache.camel.component.cometd.CometdProducerConsumer;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.SecurityPolicy;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.CometDServlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CometdComponent
extends UriEndpointComponent {
    private static final Logger LOG = LoggerFactory.getLogger(CometdComponent.class);
    private final Map<String, ConnectorRef> connectors = new LinkedHashMap<String, ConnectorRef>();
    private String sslKeyPassword;
    private String sslPassword;
    private String sslKeystore;
    private SecurityPolicy securityPolicy;
    private List<BayeuxServer.Extension> extensions;
    private List<BayeuxServer.BayeuxServerListener> serverListeners;
    private SSLContextParameters sslContextParameters;

    public CometdComponent() {
        super(CometdEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        CometdEndpoint endpoint = new CometdEndpoint(this, uri, remaining, parameters);
        this.setProperties((Object)endpoint, parameters);
        return endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(CometdProducerConsumer prodcon) throws Exception {
        Server server = null;
        CometdEndpoint endpoint = prodcon.getEndpoint();
        String connectorKey = endpoint.getProtocol() + ":" + endpoint.getUri().getHost() + ":" + endpoint.getPort();
        Map<String, ConnectorRef> map = this.connectors;
        synchronized (map) {
            ConnectorRef connectorRef = this.connectors.get(connectorKey);
            if (connectorRef == null) {
                server = this.createServer();
                ServerConnector connector = "cometds".equals(endpoint.getProtocol()) ? this.getSslSocketConnector(server) : new ServerConnector(server);
                connector.setPort(endpoint.getPort());
                connector.setHost(endpoint.getUri().getHost());
                if ("localhost".equalsIgnoreCase(endpoint.getUri().getHost())) {
                    LOG.warn("You use localhost interface! It means that no external connections will be available. Don't you want to use 0.0.0.0 instead (all network interfaces)?");
                }
                server.addConnector((Connector)connector);
                CometDServlet servlet = this.createServletForConnector(server, (Connector)connector, endpoint);
                connectorRef = new ConnectorRef((Connector)connector, servlet, server);
                server.start();
                this.connectors.put(connectorKey, connectorRef);
            } else {
                connectorRef.increment();
            }
            BayeuxServerImpl bayeux = connectorRef.servlet.getBayeux();
            if (this.securityPolicy != null) {
                bayeux.setSecurityPolicy(this.securityPolicy);
            }
            if (this.extensions != null) {
                for (BayeuxServer.Extension extension : this.extensions) {
                    bayeux.addExtension(extension);
                }
            }
            if (this.serverListeners != null) {
                for (BayeuxServer.BayeuxServerListener serverListener : this.serverListeners) {
                    bayeux.addListener(serverListener);
                }
            }
            prodcon.setBayeux(bayeux);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(CometdProducerConsumer prodcon) throws Exception {
        CometdEndpoint endpoint = prodcon.getEndpoint();
        String connectorKey = endpoint.getProtocol() + ":" + endpoint.getUri().getHost() + ":" + endpoint.getPort();
        Map<String, ConnectorRef> map = this.connectors;
        synchronized (map) {
            ConnectorRef connectorRef = this.connectors.get(connectorKey);
            if (connectorRef != null && connectorRef.decrement() == 0) {
                connectorRef.server.removeConnector(connectorRef.connector);
                connectorRef.connector.stop();
                connectorRef.server.stop();
                this.connectors.remove(connectorKey);
            }
        }
    }

    protected CometDServlet createServletForConnector(Server server, Connector connector, CometdEndpoint endpoint) throws Exception {
        CometDServlet servlet = new CometDServlet();
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)server, "/", 0);
        ServletHolder holder = new ServletHolder();
        holder.setServlet((Servlet)servlet);
        holder.setAsyncSupported(true);
        if (endpoint.getBaseResource() != null) {
            String[] resources = endpoint.getBaseResource().split(":");
            if (LOG.isDebugEnabled()) {
                LOG.debug(">>> Protocol found: " + resources[0] + ", and resource: " + resources[1]);
            }
            if (resources[0].equals("file")) {
                context.setBaseResource(Resource.newResource((String)resources[1]));
            } else if (resources[0].equals("classpath")) {
                URL url = this.getCamelContext().getClassResolver().loadResourceAsURL(resources[1]);
                context.setBaseResource(Resource.newResource((URL)url));
            }
        }
        this.applyCrossOriginFiltering(endpoint, context);
        context.addServlet(holder, "/cometd/*");
        context.addServlet("org.eclipse.jetty.servlet.DefaultServlet", "/");
        context.setSessionHandler(new SessionHandler((SessionManager)new HashSessionManager()));
        holder.setInitParameter("timeout", Integer.toString(endpoint.getTimeout()));
        holder.setInitParameter("interval", Integer.toString(endpoint.getInterval()));
        holder.setInitParameter("maxInterval", Integer.toString(endpoint.getMaxInterval()));
        holder.setInitParameter("multiFrameInterval", Integer.toString(endpoint.getMultiFrameInterval()));
        holder.setInitParameter("JSONCommented", Boolean.toString(endpoint.isJsonCommented()));
        holder.setInitParameter("logLevel", Integer.toString(endpoint.getLogLevel()));
        return servlet;
    }

    protected ServerConnector getSslSocketConnector(Server server) throws Exception {
        ServerConnector sslSocketConnector = null;
        if (this.sslContextParameters != null) {
            CometdComponentSslContextFactory sslContextFactory = new CometdComponentSslContextFactory();
            sslContextFactory.setSslContext(this.sslContextParameters.createSSLContext(this.getCamelContext()));
            sslSocketConnector = new ServerConnector(server, (SslContextFactory)sslContextFactory);
        } else {
            SslContextFactory sslContextFactory = new SslContextFactory();
            sslContextFactory.setKeyStorePassword(this.sslKeyPassword);
            sslContextFactory.setKeyManagerPassword(this.sslPassword);
            if (this.sslKeystore != null) {
                sslContextFactory.setKeyStorePath(this.sslKeystore);
            }
            sslSocketConnector = new ServerConnector(server, sslContextFactory);
        }
        return sslSocketConnector;
    }

    public String getSslKeyPassword() {
        return this.sslKeyPassword;
    }

    public String getSslPassword() {
        return this.sslPassword;
    }

    public String getSslKeystore() {
        return this.sslKeystore;
    }

    public void setSslKeyPassword(String sslKeyPassword) {
        this.sslKeyPassword = sslKeyPassword;
    }

    public void setSslPassword(String sslPassword) {
        this.sslPassword = sslPassword;
    }

    public void setSslKeystore(String sslKeystore) {
        this.sslKeystore = sslKeystore;
    }

    public void setSecurityPolicy(SecurityPolicy securityPolicy) {
        this.securityPolicy = securityPolicy;
    }

    public SecurityPolicy getSecurityPolicy() {
        return this.securityPolicy;
    }

    public List<BayeuxServer.Extension> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(List<BayeuxServer.Extension> extensions) {
        this.extensions = extensions;
    }

    public void addExtension(BayeuxServer.Extension extension) {
        if (this.extensions == null) {
            this.extensions = new ArrayList<BayeuxServer.Extension>();
        }
        this.extensions.add(extension);
    }

    public void addServerListener(BayeuxServer.BayeuxServerListener serverListener) {
        if (this.serverListeners == null) {
            this.serverListeners = new ArrayList<BayeuxServer.BayeuxServerListener>();
        }
        this.serverListeners.add(serverListener);
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    protected Server createServer() throws Exception {
        Server server = new Server();
        ContextHandlerCollection collection = new ContextHandlerCollection();
        server.setHandler((Handler)collection);
        return server;
    }

    protected void doStop() throws Exception {
        for (ConnectorRef connectorRef : this.connectors.values()) {
            connectorRef.connector.stop();
        }
        this.connectors.clear();
        super.doStop();
    }

    protected void doStart() throws Exception {
        super.doStart();
    }

    private void applyCrossOriginFiltering(CometdEndpoint endpoint, ServletContextHandler context) {
        if (endpoint.isCrossOriginFilterOn()) {
            FilterHolder filterHolder = new FilterHolder();
            CrossOriginFilter filter = new CrossOriginFilter();
            filterHolder.setFilter((Filter)filter);
            filterHolder.setInitParameter("allowedOrigins", endpoint.getAllowedOrigins());
            context.addFilter(filterHolder, endpoint.getFilterPath(), EnumSet.allOf(DispatcherType.class));
        }
    }

    private static final class CometdComponentSslContextFactory
    extends SslContextFactory {
        private CometdComponentSslContextFactory() {
        }

        public void checkKeyStore() {
        }
    }

    class ConnectorRef {
        Connector connector;
        CometDServlet servlet;
        Server server;
        int refCount;

        ConnectorRef(Connector connector, CometDServlet servlet, Server server) {
            this.connector = connector;
            this.servlet = servlet;
            this.server = server;
            this.increment();
        }

        public int increment() {
            return ++this.refCount;
        }

        public int decrement() {
            return --this.refCount;
        }
    }
}

