/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.etcd.processor.remote;

import com.fasterxml.jackson.databind.ObjectMapper;
import mousio.etcd4j.EtcdClient;
import org.apache.camel.component.etcd.EtcdConfiguration;
import org.apache.camel.component.etcd.EtcdHelper;
import org.apache.camel.component.etcd.processor.remote.EtcdServiceCallServer;
import org.apache.camel.impl.remote.DefaultServiceCallServerListStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdServiceCallServerListStrategy
extends DefaultServiceCallServerListStrategy<EtcdServiceCallServer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EtcdServiceCallServerListStrategy.class);
    private static final ObjectMapper MAPPER = EtcdHelper.createObjectMapper();
    private final EtcdConfiguration configuration;
    private EtcdClient client;

    public EtcdServiceCallServerListStrategy(EtcdConfiguration configuration) {
        this.configuration = configuration;
        this.client = null;
    }

    protected void doStart() throws Exception {
        if (this.client == null) {
            this.client = this.configuration.createClient();
        }
    }

    protected void doStop() throws Exception {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    protected EtcdConfiguration getConfiguration() {
        return this.configuration;
    }

    protected EtcdClient getClient() {
        return this.client;
    }

    protected EtcdServiceCallServer nodeFromString(String value) {
        EtcdServiceCallServer server = null;
        try {
            server = (EtcdServiceCallServer)((Object)MAPPER.readValue(value, EtcdServiceCallServer.class));
        }
        catch (Exception e) {
            LOGGER.warn("", (Throwable)e);
        }
        return server;
    }
}

