/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.etcd.processor.remote;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import mousio.client.promises.ResponsePromise;
import mousio.etcd4j.requests.EtcdKeyGetRequest;
import mousio.etcd4j.responses.EtcdException;
import mousio.etcd4j.responses.EtcdKeysResponse;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.etcd.EtcdConfiguration;
import org.apache.camel.component.etcd.EtcdHelper;
import org.apache.camel.component.etcd.processor.remote.EtcdServiceCallServer;
import org.apache.camel.component.etcd.processor.remote.EtcdServiceCallServerListStrategy;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EtcdServiceCallServerListStrategies {
    private EtcdServiceCallServerListStrategies() {
    }

    public static EtcdServiceCallServerListStrategy onDemand(EtcdConfiguration configuration) throws Exception {
        return new OnDemand(configuration);
    }

    public static EtcdServiceCallServerListStrategy watch(EtcdConfiguration configuration) throws Exception {
        return new Watch(configuration);
    }

    public static final class Watch
    extends AbstractStrategy
    implements ResponsePromise.IsSimplePromiseResponseHandler<EtcdKeysResponse> {
        private static final Logger LOGGER = LoggerFactory.getLogger(Watch.class);
        private final AtomicReference<List<EtcdServiceCallServer>> serversRef = new AtomicReference();
        private final AtomicLong index = new AtomicLong(0L);
        private final String servicePath;

        public Watch(EtcdConfiguration configuration) throws Exception {
            super(configuration);
            this.servicePath = (String)ObjectHelper.notNull((Object)configuration.getServicePath(), (String)"servicePath");
        }

        public List<EtcdServiceCallServer> getUpdatedListOfServers(String name) {
            List<EtcdServiceCallServer> servers = this.serversRef.get();
            if (servers == null) {
                this.serversRef.set(this.getServers());
                this.watch();
            }
            return this.serversRef.get().stream().filter(s -> name.equalsIgnoreCase(s.getName())).collect(Collectors.toList());
        }

        public String toString() {
            return "EtcdServiceCallServerListStrategy.Watch";
        }

        public void onResponse(ResponsePromise<EtcdKeysResponse> promise) {
            if (!this.isRunAllowed()) {
                return;
            }
            Throwable throwable = promise.getException();
            if (throwable != null && throwable instanceof EtcdException) {
                EtcdException exception = (EtcdException)throwable;
                if (EtcdHelper.isOutdatedIndexException(exception)) {
                    LOGGER.debug("Outdated index, key={}, cause={}", (Object)this.servicePath, (Object)exception.etcdCause);
                    this.index.set(exception.index + 1L);
                }
            } else {
                try {
                    EtcdKeysResponse response = (EtcdKeysResponse)promise.get();
                    EtcdHelper.setIndex(this.index, response);
                    this.serversRef.set(this.getServers());
                }
                catch (TimeoutException e) {
                    LOGGER.debug("Timeout watching for {}", (Object)this.getConfiguration().getServicePath());
                    throwable = null;
                }
                catch (Exception e) {
                    throwable = e;
                }
            }
            if (throwable != null) {
                throw new RuntimeCamelException(throwable);
            }
            this.watch();
        }

        private void watch() {
            if (!this.isRunAllowed()) {
                return;
            }
            try {
                this.getClient().get(this.servicePath).recursive().waitForChange(this.index.get()).timeout(1L, TimeUnit.SECONDS).send().addListener((ResponsePromise.IsSimplePromiseResponseHandler)this);
            }
            catch (Exception e) {
                throw new RuntimeCamelException((Throwable)e);
            }
        }
    }

    public static final class OnDemand
    extends AbstractStrategy {
        public OnDemand(EtcdConfiguration configuration) throws Exception {
            super(configuration);
        }

        public List<EtcdServiceCallServer> getUpdatedListOfServers(String name) {
            return this.getServers(s -> name.equalsIgnoreCase(s.getName()));
        }

        public String toString() {
            return "EtcdServiceCallServerListStrategy.OnDemand";
        }
    }

    private static abstract class AbstractStrategy
    extends EtcdServiceCallServerListStrategy {
        AbstractStrategy(EtcdConfiguration configuration) throws Exception {
            super(configuration);
        }

        protected List<EtcdServiceCallServer> getServers() {
            return this.getServers(s -> true);
        }

        protected List<EtcdServiceCallServer> getServers(Predicate<EtcdServiceCallServer> filter) {
            List<EtcdServiceCallServer> servers = Collections.emptyList();
            if (this.isRunAllowed()) {
                try {
                    EtcdConfiguration conf = this.getConfiguration();
                    EtcdKeyGetRequest request = this.getClient().get(conf.getServicePath()).recursive();
                    if (conf.hasTimeout()) {
                        request.timeout(conf.getTimeout().longValue(), TimeUnit.SECONDS);
                    }
                    EtcdKeysResponse response = (EtcdKeysResponse)request.send().get();
                    if (Objects.nonNull(response.node) && !response.node.nodes.isEmpty()) {
                        servers = response.node.nodes.stream().map(node -> node.value).filter(ObjectHelper::isNotEmpty).map(this::nodeFromString).filter(Objects::nonNull).filter(filter).sorted(EtcdServiceCallServer.COMPARATOR).collect(Collectors.toList());
                    }
                }
                catch (Exception e) {
                    throw new RuntimeCamelException((Throwable)e);
                }
            }
            return servers;
        }
    }
}

