/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.etcd.processor.remote;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.apache.camel.impl.remote.DefaultServiceCallServer;

public class EtcdServiceCallServer
extends DefaultServiceCallServer {
    public static final Comparator<EtcdServiceCallServer> COMPARATOR = EtcdServiceCallServer.comparator();
    private final String name;
    private final Map<String, String> tags;

    @JsonCreator
    public EtcdServiceCallServer(@JsonProperty(value="name") String name, @JsonProperty(value="address") String address, @JsonProperty(value="port") Integer port, @JsonProperty(value="tags") Map<String, String> tags) {
        super(address, port.intValue());
        this.name = name;
        this.tags = Collections.unmodifiableMap(tags != null ? tags : Collections.EMPTY_MAP);
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public static Comparator<EtcdServiceCallServer> comparator() {
        Comparator byAddress = (e1, e2) -> e2.getIp().compareTo(e1.getIp());
        Comparator byPort = (e1, e2) -> Integer.compare(e2.getPort(), e1.getPort());
        return byAddress.thenComparing(byPort);
    }
}

