/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.etcd.processor.remote;

import java.util.Map;
import java.util.Optional;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.etcd.EtcdConfiguration;
import org.apache.camel.component.etcd.processor.remote.EtcdServiceCallProcessor;
import org.apache.camel.component.etcd.processor.remote.EtcdServiceCallServer;
import org.apache.camel.component.etcd.processor.remote.EtcdServiceCallServerListStrategies;
import org.apache.camel.impl.remote.DefaultServiceCallProcessor;
import org.apache.camel.impl.remote.DefaultServiceCallProcessorFactory;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.ServiceCallServerListStrategy;
import org.apache.camel.util.ObjectHelper;

public class EtcdServiceCallProcessorFactory
extends DefaultServiceCallProcessorFactory<EtcdConfiguration, EtcdServiceCallServer> {
    protected EtcdConfiguration createConfiguration(RouteContext routeContext) throws Exception {
        return new EtcdConfiguration(routeContext.getCamelContext());
    }

    protected DefaultServiceCallProcessor createProcessor(String name, String component, String uri, ExchangePattern mep, EtcdConfiguration conf, Map<String, String> properties) throws Exception {
        return new EtcdServiceCallProcessor(name, component, uri, mep, conf);
    }

    protected Optional<ServiceCallServerListStrategy> builtInServerListStrategy(EtcdConfiguration conf, String name) throws Exception {
        EtcdServiceCallServerListStrategies.OnDemand strategy = null;
        if (ObjectHelper.equal((Object)"ondemand", (Object)name, (boolean)true)) {
            strategy = new EtcdServiceCallServerListStrategies.OnDemand(conf);
        } else if (ObjectHelper.equal((Object)"watch", (Object)name, (boolean)true)) {
            strategy = new EtcdServiceCallServerListStrategies.OnDemand(conf);
        }
        return Optional.ofNullable(strategy);
    }

    protected ServiceCallServerListStrategy<EtcdServiceCallServer> createDefaultServerListStrategy(EtcdConfiguration conf) throws Exception {
        return new EtcdServiceCallServerListStrategies.OnDemand(conf);
    }
}

