/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.etcd.policy;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import mousio.client.promises.ResponsePromise;
import mousio.etcd4j.EtcdClient;
import mousio.etcd4j.responses.EtcdException;
import mousio.etcd4j.responses.EtcdKeysResponse;
import org.apache.camel.NonManagedService;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.etcd.EtcdHelper;
import org.apache.camel.support.RoutePolicySupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdRoutePolicy
extends RoutePolicySupport
implements ResponsePromise.IsSimplePromiseResponseHandler<EtcdKeysResponse>,
NonManagedService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EtcdRoutePolicy.class);
    private final Object lock;
    private final EtcdClient client;
    private final boolean managedClient;
    private final AtomicBoolean leader;
    private final Set<Route> suspendedRoutes;
    private final AtomicLong index;
    private String serviceName;
    private String servicePath;
    private int ttl;
    private int watchTimeout;
    private boolean shouldStopConsumer;

    public EtcdRoutePolicy() {
        this(new EtcdClient(new URI[0]), true);
    }

    public EtcdRoutePolicy(EtcdClient client) {
        this(client, false);
    }

    public EtcdRoutePolicy(EtcdClient client, boolean managedClient) {
        this.client = client;
        this.managedClient = managedClient;
        this.suspendedRoutes = new HashSet<Route>();
        this.leader = new AtomicBoolean(false);
        this.lock = new Object();
        this.index = new AtomicLong(0L);
        this.serviceName = null;
        this.servicePath = null;
        this.ttl = 60;
        this.watchTimeout = this.ttl / 3;
        this.shouldStopConsumer = true;
    }

    public void onStart(Route route) {
        if (!this.leader.get() && this.shouldStopConsumer) {
            this.stopConsumer(route);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStop(Route route) {
        Object object = this.lock;
        synchronized (object) {
            this.suspendedRoutes.remove(route);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onSuspend(Route route) {
        Object object = this.lock;
        synchronized (object) {
            this.suspendedRoutes.remove(route);
        }
    }

    protected void doStart() throws Exception {
        this.setLeader(this.tryTakeLeadership());
        this.watch();
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this.managedClient) {
            this.client.close();
        }
        super.doStop();
    }

    protected void setLeader(boolean isLeader) {
        if (isLeader && this.leader.compareAndSet(false, isLeader)) {
            LOGGER.info("Leadership taken (path={}, name={})", (Object)this.servicePath, (Object)this.serviceName);
            this.startAllStoppedConsumers();
        } else if (!this.leader.getAndSet(isLeader) && isLeader) {
            LOGGER.info("Leadership lost (path={}, name={})", (Object)this.servicePath, (Object)this.serviceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startConsumer(Route route) {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.suspendedRoutes.contains(route)) {
                    this.startConsumer(route.getConsumer());
                    this.suspendedRoutes.remove(route);
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopConsumer(Route route) {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (!this.suspendedRoutes.contains(route)) {
                    LOGGER.debug("Stopping consumer for {} ({})", (Object)route.getId(), (Object)route.getConsumer());
                    this.stopConsumer(route.getConsumer());
                    this.suspendedRoutes.add(route);
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAllStoppedConsumers() {
        Object object = this.lock;
        synchronized (object) {
            try {
                for (Route route : this.suspendedRoutes) {
                    LOGGER.debug("Starting consumer for {} ({})", (Object)route.getId(), (Object)route.getConsumer());
                    this.startConsumer(route.getConsumer());
                }
                this.suspendedRoutes.clear();
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    public EtcdClient getClient() {
        return this.client;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServicePath() {
        return this.servicePath;
    }

    public void setServicePath(String servicePath) {
        this.servicePath = servicePath;
    }

    public int getTtl() {
        return this.ttl;
    }

    public void setTtl(int ttl) {
        this.ttl = ttl;
    }

    public int getWatchTimeout() {
        return this.watchTimeout;
    }

    public void setWatchTimeout(int watchTimeout) {
        this.watchTimeout = watchTimeout;
    }

    public boolean isShouldStopConsumer() {
        return this.shouldStopConsumer;
    }

    public void setShouldStopConsumer(boolean shouldStopConsumer) {
        this.shouldStopConsumer = shouldStopConsumer;
    }

    public void onResponse(ResponsePromise<EtcdKeysResponse> promise) {
        if (!this.isRunAllowed()) {
            return;
        }
        Throwable throwable = promise.getException();
        if (throwable != null && throwable instanceof EtcdException) {
            EtcdException exception = (EtcdException)throwable;
            if (EtcdHelper.isOutdatedIndexException(exception)) {
                LOGGER.debug("Outdated index, key={}, cause={}", (Object)this.servicePath, (Object)exception.etcdCause);
                this.index.set(exception.index + 1L);
                throwable = null;
            }
        } else {
            try {
                EtcdKeysResponse response = (EtcdKeysResponse)promise.get();
                EtcdHelper.setIndex(this.index, response);
                if (response.node.value == null) {
                    this.setLeader(this.tryTakeLeadership());
                } else if (!ObjectHelper.equal((Object)this.serviceName, (Object)response.node.value) && this.leader.get()) {
                    this.setLeader(false);
                }
            }
            catch (TimeoutException e) {
                LOGGER.debug("Timeout watching for {}", (Object)this.servicePath);
                throwable = null;
            }
            catch (Exception e1) {
                throwable = e1;
            }
        }
        if (throwable != null) {
            throw new RuntimeCamelException(throwable);
        }
        this.watch();
    }

    private void watch() {
        if (!this.isRunAllowed()) {
            return;
        }
        try {
            if (this.leader.get()) {
                EtcdHelper.setIndex(this.index, (EtcdKeysResponse)this.client.refresh(this.servicePath, Integer.valueOf(this.ttl)).send().get());
            }
            LOGGER.debug("Watch (path={}, isLeader={}, index={})", new Object[]{this.servicePath, this.leader.get(), this.index.get()});
            this.client.get(this.servicePath).waitForChange(this.index.get()).timeout((long)(this.ttl / 3), TimeUnit.SECONDS).send().addListener((ResponsePromise.IsSimplePromiseResponseHandler)this);
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    private boolean tryTakeLeadership() throws Exception {
        boolean result;
        block2: {
            result = false;
            try {
                EtcdKeysResponse response = (EtcdKeysResponse)this.getClient().put(this.servicePath, this.serviceName).prevExist(false).ttl(Integer.valueOf(this.ttl)).send().get();
                result = ObjectHelper.equal((Object)this.serviceName, (Object)response.node.value);
                EtcdHelper.setIndex(this.index, response);
            }
            catch (EtcdException e) {
                if (e.isErrorCode(105)) break block2;
                throw e;
            }
        }
        return result;
    }
}

