/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.etcd;

import mousio.etcd4j.EtcdClient;
import org.apache.camel.Component;
import org.apache.camel.component.etcd.AbstractEtcdConsumer;
import org.apache.camel.component.etcd.EtcdComponent;
import org.apache.camel.component.etcd.EtcdConfiguration;
import org.apache.camel.component.etcd.EtcdEndpoint;
import org.apache.camel.component.etcd.EtcdNamespace;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;

@UriEndpoint(scheme="etcd", title="etcd", syntax="etcd:namespace/path", consumerClass=AbstractEtcdConsumer.class, label="etcd")
public abstract class AbstractEtcdEndpoint
extends DefaultEndpoint
implements EtcdEndpoint {
    @UriPath(description="The API namespace to use", enums="keys,stats,watch")
    @Metadata(required="true")
    private final EtcdNamespace namespace;
    @UriPath(description="The path the enpoint refers to")
    @Metadata(required="false")
    private final String path;
    @UriParam
    private final EtcdConfiguration configuration;

    protected AbstractEtcdEndpoint(String uri, EtcdComponent component, EtcdConfiguration configuration, EtcdNamespace namespace, String path) {
        super(uri, (Component)component);
        this.configuration = configuration;
        this.namespace = namespace;
        this.path = path;
    }

    public boolean isSingleton() {
        return true;
    }

    @Override
    public EtcdConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public EtcdNamespace getNamespace() {
        return this.namespace;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public EtcdClient createClient() throws Exception {
        return this.configuration.createClient();
    }
}

