/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.univocity.springboot;

import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.TypeConverter;
import org.apache.camel.dataformat.univocity.UniVocityFixedWidthDataFormat;
import org.apache.camel.dataformat.univocity.springboot.UniVocityFixedWidthDataFormatConfiguration;
import org.apache.camel.util.IntrospectionSupport;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration
@EnableConfigurationProperties(value={UniVocityFixedWidthDataFormatConfiguration.class})
@Conditional(value={Condition.class})
public class UniVocityFixedWidthDataFormatAutoConfiguration {
    @Bean(name={"univocity-fixed-dataformat"})
    @Scope(value="prototype")
    @ConditionalOnClass(value={CamelContext.class})
    @ConditionalOnMissingBean(value={UniVocityFixedWidthDataFormat.class})
    public UniVocityFixedWidthDataFormat configureUniVocityFixedWidthDataFormat(CamelContext camelContext, UniVocityFixedWidthDataFormatConfiguration configuration) throws Exception {
        UniVocityFixedWidthDataFormat dataformat = new UniVocityFixedWidthDataFormat();
        if (dataformat instanceof CamelContextAware) {
            ((CamelContextAware)dataformat).setCamelContext(camelContext);
        }
        HashMap parameters = new HashMap();
        IntrospectionSupport.getProperties((Object)configuration, parameters, null, (boolean)false);
        IntrospectionSupport.setProperties((CamelContext)camelContext, (TypeConverter)camelContext.getTypeConverter(), (Object)dataformat, parameters);
        return dataformat;
    }

    public static class Condition
    extends SpringBootCondition {
        public ConditionOutcome getMatchOutcome(ConditionContext conditionContext, AnnotatedTypeMetadata annotatedTypeMetadata) {
            boolean groupEnabled = this.isEnabled(conditionContext, "camel.dataformat.", true);
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"camel.dataformat.univocity-fixed", (Object[])new Object[0]);
            if (this.isEnabled(conditionContext, "camel.dataformat.univocity-fixed.", groupEnabled)) {
                return ConditionOutcome.match((ConditionMessage)message.because("enabled"));
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.because("not enabled"));
        }

        private boolean isEnabled(ConditionContext context, String prefix, boolean defaultValue) {
            RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)context.getEnvironment(), prefix);
            return (Boolean)resolver.getProperty("enabled", Boolean.class, (Object)defaultValue);
        }
    }
}

