/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import org.apache.camel.component.salesforce.SalesforceHttpClient;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.SalesforceMultipleChoicesException;
import org.apache.camel.component.salesforce.api.dto.RestError;
import org.apache.camel.component.salesforce.api.utils.JsonUtils;
import org.apache.camel.component.salesforce.internal.PayloadFormat;
import org.apache.camel.component.salesforce.internal.SalesforceSession;
import org.apache.camel.component.salesforce.internal.client.AbstractClientBase;
import org.apache.camel.component.salesforce.internal.client.RestClient;
import org.apache.camel.component.salesforce.internal.client.XStreamUtils;
import org.apache.camel.component.salesforce.internal.dto.RestChoices;
import org.apache.camel.component.salesforce.internal.dto.RestErrors;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.InputStreamContentProvider;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpStatus;

public class DefaultRestClient
extends AbstractClientBase
implements RestClient {
    private static final String SERVICES_DATA = "/services/data/";
    private static final String TOKEN_HEADER = "Authorization";
    private static final String TOKEN_PREFIX = "Bearer ";
    private static final String SERVICES_APEXREST = "/services/apexrest/";
    protected PayloadFormat format;
    private ObjectMapper objectMapper;
    private XStream xStream;

    public DefaultRestClient(SalesforceHttpClient httpClient, String version, PayloadFormat format, SalesforceSession session) throws SalesforceException {
        super(version, session, httpClient);
        this.format = format;
        this.objectMapper = JsonUtils.createObjectMapper();
        this.xStream = new XStream();
        this.xStream.processAnnotations(RestErrors.class);
        this.xStream.processAnnotations(RestChoices.class);
        this.xStream.ignoreUnknownElements();
        XStreamUtils.addDefaultPermissions(this.xStream);
    }

    @Override
    protected void doHttpRequest(Request request, AbstractClientBase.ClientResponseCallback callback) {
        String contentType = PayloadFormat.JSON.equals((Object)this.format) ? "application/json;charset=utf-8" : "application/xml;charset=utf-8";
        request.header(HttpHeader.ACCEPT, contentType);
        request.header(HttpHeader.ACCEPT_CHARSET, "UTF-8");
        super.doHttpRequest(request, callback);
    }

    @Override
    protected SalesforceException createRestException(Response response, InputStream responseContent) {
        int statusCode = response.getStatus();
        String reason = response.getReason();
        if (reason == null || reason.isEmpty()) {
            reason = HttpStatus.getMessage((int)statusCode);
        }
        try {
            if (responseContent != null && responseContent.available() > 0) {
                List<RestError> restErrors;
                if (statusCode == 300) {
                    List<String> choices;
                    if (PayloadFormat.JSON.equals((Object)this.format)) {
                        choices = (List<String>)this.objectMapper.readValue(responseContent, (TypeReference)new TypeReference<List<String>>(){});
                    } else {
                        RestChoices restChoices = new RestChoices();
                        this.xStream.fromXML(responseContent, (Object)restChoices);
                        choices = restChoices.getUrls();
                    }
                    return new SalesforceMultipleChoicesException(reason, statusCode, choices);
                }
                if (PayloadFormat.JSON.equals((Object)this.format)) {
                    restErrors = (List<RestError>)this.objectMapper.readValue(responseContent, (TypeReference)new TypeReference<List<RestError>>(){});
                } else {
                    RestErrors errors = new RestErrors();
                    this.xStream.fromXML(responseContent, (Object)errors);
                    restErrors = errors.getErrors();
                }
                return new SalesforceException(restErrors, statusCode);
            }
        }
        catch (IOException e) {
            String msg = "Unexpected Error parsing " + (Object)((Object)this.format) + " error response body + [" + responseContent + "] : " + e.getMessage();
            this.log.warn(msg, (Throwable)e);
        }
        catch (RuntimeException e) {
            String msg = "Unexpected Error parsing " + (Object)((Object)this.format) + " error response body + [" + responseContent + "] : " + e.getMessage();
            this.log.warn(msg, (Throwable)e);
        }
        return new SalesforceException("Unexpected error: " + reason + ", with content: " + responseContent, statusCode);
    }

    @Override
    public void getVersions(RestClient.ResponseCallback callback) {
        Request get = this.getRequest(HttpMethod.GET, this.servicesDataUrl());
        this.doHttpRequest(get, new DelegatingClientCallback(callback));
    }

    @Override
    public void getResources(RestClient.ResponseCallback callback) {
        Request get = this.getRequest(HttpMethod.GET, this.versionUrl());
        this.setAccessToken(get);
        this.doHttpRequest(get, new DelegatingClientCallback(callback));
    }

    @Override
    public void getGlobalObjects(RestClient.ResponseCallback callback) {
        Request get = this.getRequest(HttpMethod.GET, this.sobjectsUrl(""));
        this.setAccessToken(get);
        this.doHttpRequest(get, new DelegatingClientCallback(callback));
    }

    @Override
    public void getBasicInfo(String sObjectName, RestClient.ResponseCallback callback) {
        Request get = this.getRequest(HttpMethod.GET, this.sobjectsUrl(sObjectName + "/"));
        this.setAccessToken(get);
        this.doHttpRequest(get, new DelegatingClientCallback(callback));
    }

    @Override
    public void getDescription(String sObjectName, RestClient.ResponseCallback callback) {
        Request get = this.getRequest(HttpMethod.GET, this.sobjectsUrl(sObjectName + "/describe/"));
        this.setAccessToken(get);
        this.doHttpRequest(get, new DelegatingClientCallback(callback));
    }

    @Override
    public void getSObject(String sObjectName, String id, String[] fields, RestClient.ResponseCallback callback) {
        String params = "";
        if (fields != null && fields.length > 0) {
            StringBuilder fieldsValue = new StringBuilder("?fields=");
            for (int i = 0; i < fields.length; ++i) {
                fieldsValue.append(fields[i]);
                if (i >= fields.length - 1) continue;
                fieldsValue.append(',');
            }
            params = fieldsValue.toString();
        }
        Request get = this.getRequest(HttpMethod.GET, this.sobjectsUrl(sObjectName + "/" + id + params));
        this.setAccessToken(get);
        this.doHttpRequest(get, new DelegatingClientCallback(callback));
    }

    @Override
    public void createSObject(String sObjectName, InputStream sObject, RestClient.ResponseCallback callback) {
        Request post = this.getRequest(HttpMethod.POST, this.sobjectsUrl(sObjectName));
        this.setAccessToken(post);
        post.content((ContentProvider)new InputStreamContentProvider(sObject));
        post.header(HttpHeader.CONTENT_TYPE, PayloadFormat.JSON.equals((Object)this.format) ? APPLICATION_JSON_UTF8 : APPLICATION_XML_UTF8);
        this.doHttpRequest(post, new DelegatingClientCallback(callback));
    }

    @Override
    public void updateSObject(String sObjectName, String id, InputStream sObject, RestClient.ResponseCallback callback) {
        Request patch = this.getRequest("PATCH", this.sobjectsUrl(sObjectName + "/" + id));
        this.setAccessToken(patch);
        patch.content((ContentProvider)new InputStreamContentProvider(sObject));
        patch.header(HttpHeader.CONTENT_TYPE, PayloadFormat.JSON.equals((Object)this.format) ? APPLICATION_JSON_UTF8 : APPLICATION_XML_UTF8);
        this.doHttpRequest(patch, new DelegatingClientCallback(callback));
    }

    @Override
    public void deleteSObject(String sObjectName, String id, RestClient.ResponseCallback callback) {
        Request delete = this.getRequest(HttpMethod.DELETE, this.sobjectsUrl(sObjectName + "/" + id));
        this.setAccessToken(delete);
        this.doHttpRequest(delete, new DelegatingClientCallback(callback));
    }

    @Override
    public void getSObjectWithId(String sObjectName, String fieldName, String fieldValue, RestClient.ResponseCallback callback) {
        Request get = this.getRequest(HttpMethod.GET, this.sobjectsExternalIdUrl(sObjectName, fieldName, fieldValue));
        this.setAccessToken(get);
        this.doHttpRequest(get, new DelegatingClientCallback(callback));
    }

    @Override
    public void upsertSObject(String sObjectName, String fieldName, String fieldValue, InputStream sObject, RestClient.ResponseCallback callback) {
        Request patch = this.getRequest("PATCH", this.sobjectsExternalIdUrl(sObjectName, fieldName, fieldValue));
        this.setAccessToken(patch);
        patch.content((ContentProvider)new InputStreamContentProvider(sObject));
        patch.header(HttpHeader.CONTENT_TYPE, PayloadFormat.JSON.equals((Object)this.format) ? APPLICATION_JSON_UTF8 : APPLICATION_XML_UTF8);
        this.doHttpRequest(patch, new DelegatingClientCallback(callback));
    }

    @Override
    public void deleteSObjectWithId(String sObjectName, String fieldName, String fieldValue, RestClient.ResponseCallback callback) {
        Request delete = this.getRequest(HttpMethod.DELETE, this.sobjectsExternalIdUrl(sObjectName, fieldName, fieldValue));
        this.setAccessToken(delete);
        this.doHttpRequest(delete, new DelegatingClientCallback(callback));
    }

    @Override
    public void getBlobField(String sObjectName, String id, String blobFieldName, RestClient.ResponseCallback callback) {
        Request get = this.getRequest(HttpMethod.GET, this.sobjectsUrl(sObjectName + "/" + id + "/" + blobFieldName));
        this.setAccessToken(get);
        this.doHttpRequest(get, new DelegatingClientCallback(callback));
    }

    @Override
    public void query(String soqlQuery, RestClient.ResponseCallback callback) {
        try {
            String encodedQuery = this.urlEncode(soqlQuery);
            Request get = this.getRequest(HttpMethod.GET, this.versionUrl() + "query/?q=" + encodedQuery);
            this.setAccessToken(get);
            this.doHttpRequest(get, new DelegatingClientCallback(callback));
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Unexpected error: " + e.getMessage();
            callback.onResponse(null, new SalesforceException(msg, e));
        }
    }

    @Override
    public void queryMore(String nextRecordsUrl, RestClient.ResponseCallback callback) {
        Request get = this.getRequest(HttpMethod.GET, this.instanceUrl + nextRecordsUrl);
        this.setAccessToken(get);
        this.doHttpRequest(get, new DelegatingClientCallback(callback));
    }

    @Override
    public void queryAll(String soqlQuery, RestClient.ResponseCallback callback) {
        try {
            String encodedQuery = this.urlEncode(soqlQuery);
            Request get = this.getRequest(HttpMethod.GET, this.versionUrl() + "queryAll/?q=" + encodedQuery);
            this.setAccessToken(get);
            this.doHttpRequest(get, new DelegatingClientCallback(callback));
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Unexpected error: " + e.getMessage();
            callback.onResponse(null, new SalesforceException(msg, e));
        }
    }

    @Override
    public void search(String soslQuery, RestClient.ResponseCallback callback) {
        try {
            String encodedQuery = this.urlEncode(soslQuery);
            Request get = this.getRequest(HttpMethod.GET, this.versionUrl() + "search/?q=" + encodedQuery);
            this.setAccessToken(get);
            this.doHttpRequest(get, new DelegatingClientCallback(callback));
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Unexpected error: " + e.getMessage();
            callback.onResponse(null, new SalesforceException(msg, e));
        }
    }

    @Override
    public void apexCall(String httpMethod, String apexUrl, Map<String, Object> queryParams, InputStream requestDto, RestClient.ResponseCallback callback) {
        try {
            Request request = this.getRequest(httpMethod, this.apexCallUrl(apexUrl, queryParams));
            if (requestDto != null) {
                request.content((ContentProvider)new InputStreamContentProvider(requestDto));
                request.header(HttpHeader.CONTENT_TYPE, PayloadFormat.JSON.equals((Object)this.format) ? APPLICATION_JSON_UTF8 : APPLICATION_XML_UTF8);
            }
            this.setAccessToken(request);
            this.doHttpRequest(request, new DelegatingClientCallback(callback));
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Unexpected error: " + e.getMessage();
            callback.onResponse(null, new SalesforceException(msg, e));
        }
        catch (URISyntaxException e) {
            String msg = "Unexpected error: " + e.getMessage();
            callback.onResponse(null, new SalesforceException(msg, e));
        }
    }

    private String apexCallUrl(String apexUrl, Map<String, Object> queryParams) throws UnsupportedEncodingException, URISyntaxException {
        if (queryParams != null && !queryParams.isEmpty()) {
            apexUrl = URISupport.appendParametersToURI((String)apexUrl, queryParams);
        }
        return this.instanceUrl + SERVICES_APEXREST + apexUrl;
    }

    private String servicesDataUrl() {
        return this.instanceUrl + SERVICES_DATA;
    }

    private String versionUrl() {
        ObjectHelper.notNull((Object)this.version, (String)"version");
        return this.servicesDataUrl() + "v" + this.version + "/";
    }

    private String sobjectsUrl(String sObjectName) {
        ObjectHelper.notNull((Object)sObjectName, (String)"sObjectName");
        return this.versionUrl() + "sobjects/" + sObjectName;
    }

    private String sobjectsExternalIdUrl(String sObjectName, String fieldName, String fieldValue) {
        if (fieldName == null || fieldValue == null) {
            throw new IllegalArgumentException("External field name and value cannot be NULL");
        }
        try {
            String encodedValue = this.urlEncode(fieldValue);
            return this.sobjectsUrl(sObjectName + "/" + fieldName + "/" + encodedValue);
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Unexpected error: " + e.getMessage();
            throw new IllegalArgumentException(msg, e);
        }
    }

    @Override
    protected void setAccessToken(Request request) {
        request.getHeaders().put(TOKEN_HEADER, TOKEN_PREFIX + this.accessToken);
    }

    private String urlEncode(String query) throws UnsupportedEncodingException {
        String encodedQuery = URLEncoder.encode(query, "UTF-8");
        encodedQuery = encodedQuery.replace("+", "%20");
        return encodedQuery;
    }

    private static class DelegatingClientCallback
    implements AbstractClientBase.ClientResponseCallback {
        private final RestClient.ResponseCallback callback;

        DelegatingClientCallback(RestClient.ResponseCallback callback) {
            this.callback = callback;
        }

        @Override
        public void onResponse(InputStream response, SalesforceException ex) {
            this.callback.onResponse(response, ex);
        }
    }
}

