/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.influxdb;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.influxdb.CamelInfluxDbException;
import org.apache.camel.component.influxdb.InfluxDbEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.influxdb.InfluxDB;
import org.influxdb.dto.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxDbProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(InfluxDbProducer.class);
    InfluxDbEndpoint endpoint;
    InfluxDB connection;

    public InfluxDbProducer(InfluxDbEndpoint endpoint) {
        super((Endpoint)endpoint);
        if (endpoint == null) {
            throw new IllegalArgumentException("Can't create a producer when the endpoint is null");
        }
        if (endpoint.getInfluxDB() == null) {
            throw new IllegalArgumentException("Can't create a producer when the database connection is null");
        }
        this.connection = endpoint.getInfluxDB();
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        String dataBaseName = this.calculateDatabaseName(exchange);
        String retentionPolicy = this.calculateRetentionPolicy(exchange);
        Point p = (Point)exchange.getIn().getMandatoryBody(Point.class);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Writing point {}", (Object)p.lineProtocol());
            }
            this.connection.write(dataBaseName, retentionPolicy, p);
        }
        catch (Exception ex) {
            exchange.setException((Throwable)new CamelInfluxDbException(ex));
        }
    }

    private String calculateRetentionPolicy(Exchange exchange) {
        String retentionPolicy = (String)exchange.getIn().getHeader("camelInfluxDB.RetentionPolicy", String.class);
        if (retentionPolicy != null) {
            return retentionPolicy;
        }
        return this.endpoint.getRetentionPolicy();
    }

    private String calculateDatabaseName(Exchange exchange) {
        String dbName = (String)exchange.getIn().getHeader("camelInfluxDB.databaseName", String.class);
        if (dbName != null) {
            return dbName;
        }
        return this.endpoint.getDatabaseName();
    }
}

