/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.influxdb;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.influxdb.InfluxDbComponent;
import org.apache.camel.component.influxdb.InfluxDbProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.influxdb.InfluxDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="influxdb", title="InfluxDB", syntax="influxdb:connectionBean", label="database,ticks", producerOnly=true)
public class InfluxDbEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(InfluxDbEndpoint.class);
    private InfluxDB influxDB;
    @UriPath
    @Metadata(required="true", description="Connection to the influx database, of class InfluxDB.class")
    private String connectionBean;
    @UriParam(description="the name of the series where the points will be created, name can be modified dynamically by headers")
    private String databaseName;
    @UriParam(defaultValue="default", description="defines the retention policy for the points created in influxdb")
    private String retentionPolicy = "default";

    public InfluxDbEndpoint(String uri, InfluxDbComponent influxDbComponent, InfluxDB dbConn) {
        super(uri, (Component)influxDbComponent);
        if (dbConn == null) {
            throw new IllegalArgumentException("dbConn is null");
        }
        this.influxDB = dbConn;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Prepairing influxdb enpoint with uri {}", (Object)uri);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating influx db producer connectionBean:{}, databaseName:{}, retentionPolicy:{}", new Object[]{this.connectionBean, this.databaseName, this.retentionPolicy});
        }
    }

    public Producer createProducer() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating influx db producer");
        }
        return new InfluxDbProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating influx db consumer");
        }
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public boolean isSingleton() {
        return false;
    }

    public InfluxDB getInfluxDB() {
        return this.influxDB;
    }

    public void setInfluxDB(InfluxDB influxDB) {
        this.influxDB = influxDB;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getRetentionPolicy() {
        return this.retentionPolicy;
    }

    public void setRetentionPolicy(String retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
    }

    public String getConnectionBean() {
        return this.connectionBean;
    }

    public void setConnectionBean(String connectionBean) {
        this.connectionBean = connectionBean;
    }
}

