/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.influxdb;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.influxdb.InfluxDbEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.util.CamelContextHelper;
import org.influxdb.InfluxDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxDbComponent
extends UriEndpointComponent {
    private static final Logger LOG = LoggerFactory.getLogger(InfluxDbComponent.class);
    InfluxDB influxDbConnection = null;

    public InfluxDbComponent() {
        super(InfluxDbEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating influx db endpoint");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Looking for influxDb connection bean, remaining {}", (Object)remaining);
        }
        if (this.influxDbConnection == null) {
            this.influxDbConnection = (InfluxDB)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)remaining, InfluxDB.class);
        }
        return new InfluxDbEndpoint(uri, this, this.influxDbConnection);
    }
}

