/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.elasticsearch;

import java.util.ArrayList;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.elasticsearch.ElasticsearchEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.exists.ExistsRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Client;

public class ElasticsearchProducer
extends DefaultProducer {
    public ElasticsearchProducer(ElasticsearchEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public ElasticsearchEndpoint getEndpoint() {
        return (ElasticsearchEndpoint)super.getEndpoint();
    }

    private String resolveOperation(Exchange exchange) {
        Object request = exchange.getIn().getBody();
        if (request instanceof IndexRequest) {
            return "INDEX";
        }
        if (request instanceof GetRequest) {
            return "GET_BY_ID";
        }
        if (request instanceof MultiGetRequest) {
            return "MULTIGET";
        }
        if (request instanceof UpdateRequest) {
            return "UPDATE";
        }
        if (request instanceof BulkRequest) {
            if ("BULK_INDEX".equals(this.getEndpoint().getConfig().getOperation())) {
                return "BULK_INDEX";
            }
            return "BULK";
        }
        if (request instanceof DeleteRequest) {
            return "DELETE";
        }
        if (request instanceof ExistsRequest) {
            return "EXISTS";
        }
        if (request instanceof SearchRequest) {
            return "SEARCH";
        }
        if (request instanceof MultiSearchRequest) {
            return "MULTISEARCH";
        }
        String operationConfig = (String)exchange.getIn().getHeader("operation", String.class);
        if (operationConfig == null) {
            operationConfig = this.getEndpoint().getConfig().getOperation();
        }
        if (operationConfig == null) {
            throw new IllegalArgumentException("operation value '" + operationConfig + "' is not supported");
        }
        return operationConfig;
    }

    public void process(Exchange exchange) throws Exception {
        Message message = exchange.getIn();
        String operation = this.resolveOperation(exchange);
        boolean configIndexName = false;
        String indexName = (String)message.getHeader("indexName", String.class);
        if (indexName == null) {
            message.setHeader("indexName", (Object)this.getEndpoint().getConfig().getIndexName());
            configIndexName = true;
        }
        boolean configIndexType = false;
        String indexType = (String)message.getHeader("indexType", String.class);
        if (indexType == null) {
            message.setHeader("indexType", (Object)this.getEndpoint().getConfig().getIndexType());
            configIndexType = true;
        }
        boolean configConsistencyLevel = false;
        String consistencyLevel = (String)message.getHeader("consistencyLevel", String.class);
        if (consistencyLevel == null) {
            message.setHeader("consistencyLevel", (Object)this.getEndpoint().getConfig().getConsistencyLevel());
            configConsistencyLevel = true;
        }
        Client client = this.getEndpoint().getClient();
        if ("INDEX".equals(operation)) {
            IndexRequest indexRequest = (IndexRequest)message.getBody(IndexRequest.class);
            message.setBody((Object)((IndexResponse)client.index(indexRequest).actionGet()).getId());
        } else if ("UPDATE".equals(operation)) {
            UpdateRequest updateRequest = (UpdateRequest)message.getBody(UpdateRequest.class);
            message.setBody((Object)((UpdateResponse)client.update(updateRequest).actionGet()).getId());
        } else if ("GET_BY_ID".equals(operation)) {
            GetRequest getRequest = (GetRequest)message.getBody(GetRequest.class);
            message.setBody((Object)client.get(getRequest));
        } else if ("MULTIGET".equals(operation)) {
            MultiGetRequest multiGetRequest = (MultiGetRequest)message.getBody(MultiGetRequest.class);
            message.setBody((Object)client.multiGet(multiGetRequest));
        } else if ("BULK".equals(operation)) {
            BulkRequest bulkRequest = (BulkRequest)message.getBody(BulkRequest.class);
            message.setBody(client.bulk(bulkRequest).actionGet());
        } else if ("BULK_INDEX".equals(operation)) {
            BulkRequest bulkRequest = (BulkRequest)message.getBody(BulkRequest.class);
            ArrayList<String> indexedIds = new ArrayList<String>();
            for (BulkItemResponse response : ((BulkResponse)client.bulk(bulkRequest).actionGet()).getItems()) {
                indexedIds.add(response.getId());
            }
            message.setBody(indexedIds);
        } else if ("DELETE".equals(operation)) {
            DeleteRequest deleteRequest = (DeleteRequest)message.getBody(DeleteRequest.class);
            message.setBody(client.delete(deleteRequest).actionGet());
        } else if ("EXISTS".equals(operation)) {
            ExistsRequest existsRequest = (ExistsRequest)message.getBody(ExistsRequest.class);
            message.setBody((Object)((IndicesExistsResponse)client.admin().indices().prepareExists(existsRequest.indices()).get()).isExists());
        } else if ("SEARCH".equals(operation)) {
            SearchRequest searchRequest = (SearchRequest)message.getBody(SearchRequest.class);
            message.setBody(client.search(searchRequest).actionGet());
        } else if ("MULTISEARCH".equals(operation)) {
            MultiSearchRequest multiSearchRequest = (MultiSearchRequest)message.getBody(MultiSearchRequest.class);
            message.setBody((Object)client.multiSearch(multiSearchRequest));
        } else {
            throw new IllegalArgumentException("operation value '" + operation + "' is not supported");
        }
        if (configIndexName) {
            message.removeHeader("indexName");
        }
        if (configIndexType) {
            message.removeHeader("indexType");
        }
        if (configConsistencyLevel) {
            message.removeHeader("consistencyLevel");
        }
    }
}

