/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.producer;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.client.dsl.ClientMixedOperation;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientPodResource;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.kubernetes.KubernetesEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesPodsProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesPodsProducer.class);

    public KubernetesPodsProducer(KubernetesEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public KubernetesEndpoint getEndpoint() {
        return (KubernetesEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation = ObjectHelper.isEmpty((Object)this.getEndpoint().getKubernetesConfiguration().getOperation()) ? (String)exchange.getIn().getHeader("CamelKubernetesOperation", String.class) : this.getEndpoint().getKubernetesConfiguration().getOperation();
        switch (operation) {
            case "listPods": {
                this.doList(exchange, operation);
                break;
            }
            case "listPodsByLabels": {
                this.doListPodsByLabel(exchange, operation);
                break;
            }
            case "getPod": {
                this.doGetPod(exchange, operation);
                break;
            }
            case "createPod": {
                this.doCreatePod(exchange, operation);
                break;
            }
            case "deletePod": {
                this.doDeletePod(exchange, operation);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange, String operation) throws Exception {
        PodList podList = (PodList)this.getEndpoint().getKubernetesClient().pods().list();
        exchange.getOut().setBody((Object)podList.getItems());
    }

    protected void doListPodsByLabel(Exchange exchange, String operation) {
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesPodsLabels", Map.class);
        if (ObjectHelper.isEmpty((Object)labels)) {
            LOG.error("Get pods by labels require specify a labels set");
            throw new IllegalArgumentException("Get pods by labels require specify a labels set");
        }
        ClientMixedOperation pods = this.getEndpoint().getKubernetesClient().pods();
        for (Map.Entry entry : labels.entrySet()) {
            pods.withLabel((String)entry.getKey(), (String)entry.getValue());
        }
        PodList podList = (PodList)pods.list();
        exchange.getOut().setBody((Object)podList.getItems());
    }

    protected void doGetPod(Exchange exchange, String operation) throws Exception {
        Pod pod = null;
        String podName = (String)exchange.getIn().getHeader("CamelKubernetesPodName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((Object)podName)) {
            LOG.error("Get a specific pod require specify a pod name");
            throw new IllegalArgumentException("Get a specific pod require specify a pod name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Get a specific pod require specify a namespace name");
            throw new IllegalArgumentException("Get a specific pod require specify a namespace name");
        }
        pod = (Pod)((ClientPodResource)((ClientNonNamespaceOperation)this.getEndpoint().getKubernetesClient().pods().inNamespace(namespaceName)).withName(podName)).get();
        exchange.getOut().setBody((Object)pod);
    }

    protected void doCreatePod(Exchange exchange, String operation) throws Exception {
        Pod pod = null;
        String podName = (String)exchange.getIn().getHeader("CamelKubernetesPodName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        PodSpec podSpec = (PodSpec)exchange.getIn().getHeader("CamelKubernetesPodSpec", PodSpec.class);
        if (ObjectHelper.isEmpty((Object)podName)) {
            LOG.error("Create a specific pod require specify a pod name");
            throw new IllegalArgumentException("Create a specific pod require specify a pod name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Create a specific pod require specify a namespace name");
            throw new IllegalArgumentException("Create a specific pod require specify a namespace name");
        }
        if (ObjectHelper.isEmpty((Object)podSpec)) {
            LOG.error("Create a specific pod require specify a pod spec bean");
            throw new IllegalArgumentException("Create a specific pod require specify a pod spec bean");
        }
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesPodsLabels", Map.class);
        Pod podCreating = ((PodBuilder)((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName(podName)).withLabels(labels)).endMetadata()).withSpec(podSpec)).build();
        pod = (Pod)((ClientNonNamespaceOperation)this.getEndpoint().getKubernetesClient().pods().inNamespace(namespaceName)).create((Object[])new Pod[]{podCreating});
        exchange.getOut().setBody((Object)pod);
    }

    protected void doDeletePod(Exchange exchange, String operation) throws Exception {
        String podName = (String)exchange.getIn().getHeader("CamelKubernetesPodName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((Object)podName)) {
            LOG.error("Delete a specific pod require specify a pod name");
            throw new IllegalArgumentException("Delete a specific pod require specify a pod name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Delete a specific pod require specify a namespace name");
            throw new IllegalArgumentException("Delete a specific pod require specify a namespace name");
        }
        boolean podDeleted = (Boolean)((ClientPodResource)((ClientNonNamespaceOperation)this.getEndpoint().getKubernetesClient().pods().inNamespace(namespaceName)).withName(podName)).delete();
        exchange.getOut().setBody((Object)podDeleted);
    }
}

