/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.producer;

import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpec;
import io.fabric8.kubernetes.client.dsl.ClientMixedOperation;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.kubernetes.KubernetesEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesPersistentVolumesClaimsProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesPersistentVolumesClaimsProducer.class);

    public KubernetesPersistentVolumesClaimsProducer(KubernetesEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public KubernetesEndpoint getEndpoint() {
        return (KubernetesEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation = ObjectHelper.isEmpty((Object)this.getEndpoint().getKubernetesConfiguration().getOperation()) ? (String)exchange.getIn().getHeader("CamelKubernetesOperation", String.class) : this.getEndpoint().getKubernetesConfiguration().getOperation();
        switch (operation) {
            case "listPersistentVolumesClaims": {
                this.doList(exchange, operation);
                break;
            }
            case "listPersistentVolumesClaimsByLabels": {
                this.doListPersistentVolumesClaimsByLabels(exchange, operation);
                break;
            }
            case "getPersistentVolumeClaim": {
                this.doGetPersistentVolumeClaim(exchange, operation);
                break;
            }
            case "createPersistentVolumeClaim": {
                this.doCreatePersistentVolumeClaim(exchange, operation);
                break;
            }
            case "deletePersistentVolumeClaim": {
                this.doDeletePersistentVolumeClaim(exchange, operation);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange, String operation) throws Exception {
        PersistentVolumeClaimList persistentVolumeClaimList = (PersistentVolumeClaimList)this.getEndpoint().getKubernetesClient().persistentVolumeClaims().list();
        exchange.getOut().setBody((Object)persistentVolumeClaimList.getItems());
    }

    protected void doListPersistentVolumesClaimsByLabels(Exchange exchange, String operation) throws Exception {
        PersistentVolumeClaimList pvcList = null;
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesPersistentVolumesClaimsLabels", Map.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (!ObjectHelper.isEmpty((Object)namespaceName)) {
            ClientNonNamespaceOperation pvcs = (ClientNonNamespaceOperation)this.getEndpoint().getKubernetesClient().persistentVolumeClaims().inNamespace(namespaceName);
            for (Map.Entry entry : labels.entrySet()) {
                pvcs.withLabel((String)entry.getKey(), (String)entry.getValue());
            }
            pvcList = (PersistentVolumeClaimList)pvcs.list();
        } else {
            ClientMixedOperation pvcs = this.getEndpoint().getKubernetesClient().persistentVolumeClaims();
            for (Map.Entry entry : labels.entrySet()) {
                pvcs.withLabel((String)entry.getKey(), (String)entry.getValue());
            }
            pvcList = (PersistentVolumeClaimList)pvcs.list();
        }
        exchange.getOut().setBody((Object)pvcList.getItems());
    }

    protected void doGetPersistentVolumeClaim(Exchange exchange, String operation) throws Exception {
        PersistentVolumeClaim pvc = null;
        String pvcName = (String)exchange.getIn().getHeader("CamelKubernetesPersistentVolumeClaimName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((Object)pvcName)) {
            LOG.error("Get a specific Persistent Volume Claim require specify a Persistent Volume Claim name");
            throw new IllegalArgumentException("Get a specific Persistent Volume Claim require specify a Persistent Volume Claim name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Get a specific Persistent Volume Claim require specify a namespace name");
            throw new IllegalArgumentException("Get a specific Persistent Volume Claim require specify a namespace name");
        }
        pvc = (PersistentVolumeClaim)((ClientResource)((ClientNonNamespaceOperation)this.getEndpoint().getKubernetesClient().persistentVolumeClaims().inNamespace(namespaceName)).withName(pvcName)).get();
        exchange.getOut().setBody((Object)pvc);
    }

    protected void doCreatePersistentVolumeClaim(Exchange exchange, String operation) throws Exception {
        PersistentVolumeClaim pvc = null;
        String pvcName = (String)exchange.getIn().getHeader("CamelKubernetesPersistentVolumeClaimName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        PersistentVolumeClaimSpec pvcSpec = (PersistentVolumeClaimSpec)exchange.getIn().getHeader("CamelKubernetesPersistentVolumeClaimSpec", PersistentVolumeClaimSpec.class);
        if (ObjectHelper.isEmpty((Object)pvcName)) {
            LOG.error("Create a specific Persistent Volume Claim require specify a Persistent Volume Claim name");
            throw new IllegalArgumentException("Create a specific Persistent Volume Claim require specify a Persistent Volume Claim name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Create a specific Persistent Volume Claim require specify a namespace name");
            throw new IllegalArgumentException("Create a specific Persistent Volume Claim require specify a namespace name");
        }
        if (ObjectHelper.isEmpty((Object)pvcSpec)) {
            LOG.error("Create a specific Persistent Volume Claim require specify a Persistent Volume Claim spec bean");
            throw new IllegalArgumentException("Create a specific Persistent Volume Claim require specify a Persistent Volume Claim spec bean");
        }
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesPersistentVolumesClaimsLabels", Map.class);
        PersistentVolumeClaim pvcCreating = ((PersistentVolumeClaimBuilder)((PersistentVolumeClaimBuilder)((PersistentVolumeClaimFluent.MetadataNested)((PersistentVolumeClaimFluent.MetadataNested)new PersistentVolumeClaimBuilder().withNewMetadata().withName(pvcName)).withLabels(labels)).endMetadata()).withSpec(pvcSpec)).build();
        pvc = (PersistentVolumeClaim)((ClientNonNamespaceOperation)this.getEndpoint().getKubernetesClient().persistentVolumeClaims().inNamespace(namespaceName)).create((Object[])new PersistentVolumeClaim[]{pvcCreating});
        exchange.getOut().setBody((Object)pvc);
    }

    protected void doDeletePersistentVolumeClaim(Exchange exchange, String operation) throws Exception {
        String pvcName = (String)exchange.getIn().getHeader("CamelKubernetesPersistentVolumeClaimName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((Object)pvcName)) {
            LOG.error("Delete a specific Persistent Volume Claim require specify a Persistent Volume Claim name");
            throw new IllegalArgumentException("Delete a specific Persistent Volume Claim require specify a Persistent Volume Claim name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Delete a specific Persistent Volume Claim require specify a namespace name");
            throw new IllegalArgumentException("Delete a specific Persistent Volume Claim require specify a namespace name");
        }
        boolean pvcDeleted = (Boolean)((ClientResource)((ClientNonNamespaceOperation)this.getEndpoint().getKubernetesClient().persistentVolumeClaims().inNamespace(namespaceName)).withName(pvcName)).delete();
        exchange.getOut().setBody((Object)pvcDeleted);
    }
}

