/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.producer;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.client.dsl.ClientMixedOperation;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.kubernetes.KubernetesEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesConfigMapsProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesConfigMapsProducer.class);

    public KubernetesConfigMapsProducer(KubernetesEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public KubernetesEndpoint getEndpoint() {
        return (KubernetesEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation = ObjectHelper.isEmpty((Object)this.getEndpoint().getKubernetesConfiguration().getOperation()) ? (String)exchange.getIn().getHeader("CamelKubernetesOperation", String.class) : this.getEndpoint().getKubernetesConfiguration().getOperation();
        switch (operation) {
            case "listConfigMaps": {
                this.doList(exchange, operation);
                break;
            }
            case "listConfigMapsByLabels": {
                this.doListConfigMapsByLabels(exchange, operation);
                break;
            }
            case "getConfigMap": {
                this.doGetConfigMap(exchange, operation);
                break;
            }
            case "createConfigMap": {
                this.doCreateConfigMap(exchange, operation);
                break;
            }
            case "deleteConfigMap": {
                this.doDeleteConfigMap(exchange, operation);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange, String operation) throws Exception {
        ConfigMapList configMapsList = (ConfigMapList)this.getEndpoint().getKubernetesClient().configMaps().list();
        exchange.getOut().setBody((Object)configMapsList.getItems());
    }

    protected void doListConfigMapsByLabels(Exchange exchange, String operation) throws Exception {
        ConfigMapList configMapsList = null;
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesConfigMapsLabels", Map.class);
        ClientMixedOperation configMaps = this.getEndpoint().getKubernetesClient().configMaps();
        for (Map.Entry entry : labels.entrySet()) {
            configMaps.withLabel((String)entry.getKey(), (String)entry.getValue());
        }
        configMapsList = (ConfigMapList)configMaps.list();
        exchange.getOut().setBody((Object)configMapsList.getItems());
    }

    protected void doGetConfigMap(Exchange exchange, String operation) throws Exception {
        ConfigMap configMap = null;
        String cfMapName = (String)exchange.getIn().getHeader("CamelKubernetesConfigMapName", String.class);
        if (ObjectHelper.isEmpty((Object)cfMapName)) {
            LOG.error("Get a specific ConfigMap require specify a ConfigMap name");
            throw new IllegalArgumentException("Get a specific ConfigMap require specify a ConfigMap name");
        }
        configMap = (ConfigMap)((ClientResource)this.getEndpoint().getKubernetesClient().configMaps().withName(cfMapName)).get();
        exchange.getOut().setBody((Object)configMap);
    }

    protected void doCreateConfigMap(Exchange exchange, String operation) throws Exception {
        ConfigMap configMap = null;
        String cfMapName = (String)exchange.getIn().getHeader("CamelKubernetesConfigMapName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        HashMap configMapData = (HashMap)exchange.getIn().getHeader("CamelKubernetesConfigData", HashMap.class);
        if (ObjectHelper.isEmpty((Object)cfMapName)) {
            LOG.error("Create a specific configMap require specify a configMap name");
            throw new IllegalArgumentException("Create a specific configMap require specify a configMap name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Create a specific configMap require specify a namespace name");
            throw new IllegalArgumentException("Create a specific configMap require specify a namespace name");
        }
        if (ObjectHelper.isEmpty((Object)configMapData)) {
            LOG.error("Create a specific configMap require specify a data map");
            throw new IllegalArgumentException("Create a specific configMap require specify a data map");
        }
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesConfigMapsLabels", Map.class);
        ConfigMap cfMapCreating = ((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(cfMapName)).withLabels(labels)).endMetadata()).withData((Map)configMapData)).build();
        configMap = (ConfigMap)((ClientNonNamespaceOperation)this.getEndpoint().getKubernetesClient().configMaps().inNamespace(namespaceName)).create((Object[])new ConfigMap[]{cfMapCreating});
        exchange.getOut().setBody((Object)configMap);
    }

    protected void doDeleteConfigMap(Exchange exchange, String operation) throws Exception {
        String configMapName = (String)exchange.getIn().getHeader("CamelKubernetesConfigMapName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((Object)configMapName)) {
            LOG.error("Delete a specific config map require specify a config map name");
            throw new IllegalArgumentException("Delete a specific config map require specify a config map name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Delete a specific config map require specify a namespace name");
            throw new IllegalArgumentException("Delete a specific config map require specify a namespace name");
        }
        boolean cfMapDeleted = (Boolean)((ClientResource)((ClientNonNamespaceOperation)this.getEndpoint().getKubernetesClient().configMaps().inNamespace(namespaceName)).withName(configMapName)).delete();
        exchange.getOut().setBody((Object)cfMapDeleted);
    }
}

