/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.processor;

import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointPort;
import io.fabric8.kubernetes.client.AutoAdaptableKubernetesClient;
import org.apache.camel.component.kubernetes.KubernetesConfiguration;
import org.apache.camel.impl.remote.DefaultServiceCallServer;
import org.apache.camel.impl.remote.DefaultServiceCallServerListStrategy;
import org.apache.camel.spi.ServiceCallServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KubernetesServiceCallServerListStrategy
extends DefaultServiceCallServerListStrategy<ServiceCallServer> {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesServiceCallServerListStrategy.class);
    private static final int FIRST = 0;
    private final KubernetesConfiguration configuration;
    private final String namespace;
    private final String portName;
    private AutoAdaptableKubernetesClient client;

    public KubernetesServiceCallServerListStrategy(KubernetesConfiguration configuration) {
        this.configuration = configuration;
        this.namespace = configuration.getNamespace() != null ? configuration.getNamespace() : System.getenv("KUBERNETES_NAMESPACE");
        this.portName = configuration.getPortName();
        this.client = null;
    }

    public String toString() {
        return "KubernetesServiceDiscovery";
    }

    protected ServiceCallServer newServer(EndpointAddress address, EndpointPort port) {
        return new DefaultServiceCallServer(address.getIp(), port.getPort().intValue());
    }

    protected KubernetesConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPortName() {
        return this.portName;
    }
}

