/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.processor;

import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointPort;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.client.AutoAdaptableKubernetesClient;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.kubernetes.KubernetesConfiguration;
import org.apache.camel.component.kubernetes.processor.KubernetesServiceCallServerListStrategy;
import org.apache.camel.impl.remote.DefaultServiceCallServer;
import org.apache.camel.spi.ServiceCallServer;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KubernetesServiceCallServerListStrategies {
    private KubernetesServiceCallServerListStrategies() {
    }

    public static final class Environment
    extends StaticServerListStrategy {
        public Environment(KubernetesConfiguration configuration) {
            super(configuration);
        }

        @Override
        protected List<ServiceCallServer> createServerList(String name) {
            try {
                CamelContext ctx = this.getCamelContext();
                String ip = ctx.resolvePropertyPlaceholders("{{service.host:" + name + "}}");
                String num = ctx.resolvePropertyPlaceholders("{{service.port:" + name + "}}");
                int port = (Integer)ctx.getTypeConverter().tryConvertTo(Integer.TYPE, (Object)num);
                return Collections.singletonList(new DefaultServiceCallServer(ip, port));
            }
            catch (Exception e) {
                throw new RuntimeCamelException((Throwable)e);
            }
        }

        @Override
        public String toString() {
            return "KubernetesServiceDiscovery.Environment";
        }
    }

    public static final class DNS
    extends StaticServerListStrategy {
        public DNS(KubernetesConfiguration configuration) {
            super(configuration);
        }

        @Override
        protected List<ServiceCallServer> createServerList(String name) {
            return Collections.singletonList(new DefaultServiceCallServer(name + "." + this.getConfiguration().getNamespace() + ".svc." + this.getConfiguration().getDnsDomain(), -1));
        }

        @Override
        public String toString() {
            return "KubernetesServiceDiscovery.DNS";
        }
    }

    private static abstract class StaticServerListStrategy
    extends KubernetesServiceCallServerListStrategy {
        private Map<String, List<ServiceCallServer>> servers = new ConcurrentHashMap<String, List<ServiceCallServer>>();

        StaticServerListStrategy(KubernetesConfiguration configuration) {
            super(configuration);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<ServiceCallServer> getUpdatedListOfServers(String name) {
            List list = this.servers.get(name);
            if (list == null) {
                Map<String, List<ServiceCallServer>> map = this.servers;
                synchronized (map) {
                    list = this.servers.computeIfAbsent(name, this::createServerList);
                }
            }
            return list;
        }

        protected abstract List<ServiceCallServer> createServerList(String var1);
    }

    public static final class Client
    extends KubernetesServiceCallServerListStrategy {
        private static final Logger LOG = LoggerFactory.getLogger(Client.class);
        private static final int FIRST = 0;
        private AutoAdaptableKubernetesClient client = null;

        public Client(KubernetesConfiguration configuration) {
            super(configuration);
        }

        public List<ServiceCallServer> getUpdatedListOfServers(String name) {
            LOG.debug("Discovering endpoints from namespace: {} with name: {}", (Object)this.getNamespace(), (Object)name);
            Endpoints endpoints = (Endpoints)((ClientResource)((ClientNonNamespaceOperation)this.client.endpoints().inNamespace(this.getNamespace())).withName(name)).get();
            ArrayList<ServiceCallServer> result = new ArrayList<ServiceCallServer>();
            if (endpoints != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found {} endpoints in namespace: {} for name: {} and portName: {}", new Object[]{endpoints.getSubsets().size(), this.getNamespace(), name, this.getPortName()});
                }
                for (EndpointSubset subset : endpoints.getSubsets()) {
                    if (subset.getPorts().size() == 1) {
                        this.addServers(result, (EndpointPort)subset.getPorts().get(0), subset);
                        continue;
                    }
                    List ports = subset.getPorts();
                    int portSize = ports.size();
                    for (int p = 0; p < portSize; ++p) {
                        EndpointPort port = (EndpointPort)ports.get(p);
                        if (!ObjectHelper.isEmpty((Object)this.getPortName()) && !this.getPortName().endsWith(port.getName())) continue;
                        this.addServers(result, port, subset);
                    }
                }
            }
            return result;
        }

        protected void addServers(List<ServiceCallServer> servers, EndpointPort port, EndpointSubset subset) {
            List addresses = subset.getAddresses();
            int size = addresses.size();
            for (int i = 0; i < size; ++i) {
                servers.add((ServiceCallServer)new DefaultServiceCallServer(((EndpointAddress)addresses.get(i)).getIp(), port.getPort().intValue()));
            }
        }

        protected void doStart() throws Exception {
            if (this.client != null) {
                return;
            }
            KubernetesConfiguration configuration = this.getConfiguration();
            ConfigBuilder builder = new ConfigBuilder();
            builder.withMasterUrl(configuration.getMasterUrl());
            if (ObjectHelper.isNotEmpty((Object)configuration.getUsername()) && ObjectHelper.isNotEmpty((Object)configuration.getPassword()) && ObjectHelper.isEmpty((Object)configuration.getOauthToken())) {
                builder.withUsername(configuration.getUsername());
                builder.withPassword(configuration.getPassword());
            } else {
                builder.withOauthToken(configuration.getOauthToken());
            }
            if (ObjectHelper.isNotEmpty((Object)configuration.getCaCertData())) {
                builder.withCaCertData(configuration.getCaCertData());
            }
            if (ObjectHelper.isNotEmpty((Object)configuration.getCaCertFile())) {
                builder.withCaCertFile(configuration.getCaCertFile());
            }
            if (ObjectHelper.isNotEmpty((Object)configuration.getClientCertData())) {
                builder.withClientCertData(configuration.getClientCertData());
            }
            if (ObjectHelper.isNotEmpty((Object)configuration.getClientCertFile())) {
                builder.withClientCertFile(configuration.getClientCertFile());
            }
            if (ObjectHelper.isNotEmpty((Object)configuration.getApiVersion())) {
                builder.withApiVersion(configuration.getApiVersion());
            }
            if (ObjectHelper.isNotEmpty((Object)configuration.getClientKeyAlgo())) {
                builder.withClientKeyAlgo(configuration.getClientKeyAlgo());
            }
            if (ObjectHelper.isNotEmpty((Object)configuration.getClientKeyData())) {
                builder.withClientKeyData(configuration.getClientKeyData());
            }
            if (ObjectHelper.isNotEmpty((Object)configuration.getClientKeyFile())) {
                builder.withClientKeyFile(configuration.getClientKeyFile());
            }
            if (ObjectHelper.isNotEmpty((Object)configuration.getClientKeyPassphrase())) {
                builder.withClientKeyPassphrase(configuration.getClientKeyPassphrase());
            }
            if (ObjectHelper.isNotEmpty((Object)configuration.getTrustCerts())) {
                builder.withTrustCerts(configuration.getTrustCerts().booleanValue());
            }
            this.client = new AutoAdaptableKubernetesClient(builder.build());
        }

        protected void doStop() throws Exception {
            if (this.client != null) {
                IOHelper.close((Closeable)this.client);
                this.client = null;
            }
        }

        @Override
        public String toString() {
            return "KubernetesServiceDiscovery.Client";
        }
    }
}

