/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.processor;

import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.component.kubernetes.KubernetesConfiguration;
import org.apache.camel.component.kubernetes.processor.KubernetesDnsServiceCallExpression;
import org.apache.camel.component.kubernetes.processor.KubernetesServiceCallServerListStrategies;
import org.apache.camel.component.kubernetes.processor.KubernetesServiceCallServerListStrategy;
import org.apache.camel.impl.remote.DefaultServiceCallProcessor;
import org.apache.camel.spi.ServiceCallServer;
import org.apache.camel.spi.ServiceCallServerListStrategy;

public class KubernetesServiceCallProcessor
extends DefaultServiceCallProcessor<ServiceCallServer> {
    public KubernetesServiceCallProcessor(String name, String scheme, String uri, ExchangePattern exchangePattern, KubernetesConfiguration conf) {
        super(name, scheme, uri, exchangePattern);
    }

    public void setServerListStrategy(ServiceCallServerListStrategy<ServiceCallServer> serverListStrategy) {
        if (!(serverListStrategy instanceof KubernetesServiceCallServerListStrategy)) {
            throw new IllegalArgumentException("ServerListStrategy is not an instance of KubernetesServiceCallServerListStrategy");
        }
        super.setServerListStrategy(serverListStrategy);
    }

    protected void doStart() throws Exception {
        ServiceCallServerListStrategy strategy = this.getServerListStrategy();
        if (strategy != null && strategy instanceof KubernetesServiceCallServerListStrategies.DNS) {
            this.setServiceCallExpression((Expression)new KubernetesDnsServiceCallExpression(this.getName(), this.getScheme(), this.getContextPath(), this.getUri()));
        }
        super.doStart();
    }
}

